/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.panel.DataPage;
import org.lsst.ccs.gconsole.plugins.alert.LsstAlertPlugin;
import org.lsst.ccs.gconsole.plugins.trending.LsstTrendingPlugin;
import org.lsst.ccs.gconsole.plugins.trending.Trend;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.rest.LsstRestService;
import org.lsst.ccs.localdb.statusdb.server.AlertEvent;
import org.lsst.ccs.localdb.statusdb.server.AlertInfo;

public class TextPage
extends JPanel
implements Persistable,
DataPage {
    public static final String CATEGORY = "TextPage";
    private final Descriptor descriptor;
    private static final int LIMIT = 10000;
    private static final Color[] RAINBOW = List.of(new Color(0, 0, 150), new Color(0, 150, 0), new Color(170, 0, 0), Color.MAGENTA, new Color(100, 100, 100), new Color(200, 140, 0), new Color(0, 150, 150), new Color(205, 125, 125)).toArray(new Color[0]);
    private final LsstTrendingPlugin plugin = Console.getConsole().getSingleton(LsstTrendingPlugin.class);
    private final LsstRestService restService = (LsstRestService)this.plugin.getConsole().getConsoleLookup().lookup(LsstRestService.class);
    private final ArrayList<Dataset> data = new ArrayList(1);
    private final JTextPane headPanel = new JTextPane();
    private final DefaultStyledDocument headDoc = (DefaultStyledDocument)this.headPanel.getStyledDocument();
    private final JTextPane mainPanel = new JTextPane();
    private final DefaultStyledDocument mainDoc = (DefaultStyledDocument)this.mainPanel.getStyledDocument();
    private final JCheckBox filterBox;
    private final JCheckBox searchBox;
    private final JTextField filterField;
    private final JTextField searchField;
    private final JButton searchNext;
    private final JButton searchPrev;
    private final Action clearAction;
    private final Action refreshAction;

    public TextPage(Descriptor desc) {
        DefaultCaret caret2;
        this.descriptor = desc.clone();
        this.setLayout(new BorderLayout());
        this.headPanel.setEditable(false);
        this.headPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        try {
            caret2 = (DefaultCaret)this.headPanel.getCaret();
            caret2.setUpdatePolicy(1);
        }
        catch (ClassCastException caret2) {
            // empty catch block
        }
        this.headPanel.setText("");
        this.add((Component)this.headPanel, "North");
        this.mainPanel.setEditable(false);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        try {
            caret2 = (DefaultCaret)this.mainPanel.getCaret();
            caret2.setUpdatePolicy(1);
        }
        catch (ClassCastException caret3) {
            // empty catch block
        }
        this.mainPanel.setText("");
        this.add((Component)new JScrollPane(this.mainPanel), "Center");
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.filterBox = new JCheckBox("Filter: ");
        this.filterBox.setSelected(this.descriptor.isFilter());
        buttonPanel.add(this.filterBox);
        this.filterField = new JTextField(this.descriptor.getFilterString());
        this.filterField.setEnabled(this.descriptor.isFilter());
        this.filterField.setToolTipText("Regular expression for filtering data records.");
        this.filterField.addActionListener(e -> {
            this.descriptor.setFilterString(this.filterField.getText());
            this.reprintMain();
        });
        buttonPanel.add(this.filterField);
        this.filterBox.addActionListener(e -> {
            boolean filterOn = this.filterBox.isSelected();
            this.filterField.setEnabled(filterOn);
            this.descriptor.setFilter(filterOn);
            String filterString = this.filterField.getText();
            this.descriptor.setFilterString(filterString);
            if (!filterString.isBlank()) {
                this.reprintMain();
            }
        });
        buttonPanel.add(Box.createRigidArea(Const.HDIM2));
        this.searchBox = new JCheckBox("Search: ");
        this.searchBox.setSelected(this.descriptor.isSearch());
        this.searchBox.setEnabled(false);
        buttonPanel.add(this.searchBox);
        this.searchField = new JTextField(this.descriptor.getSearchString());
        this.searchField.setEnabled(this.descriptor.isSearch());
        buttonPanel.add(this.searchField);
        this.searchNext = new JButton(new ImageIcon(Console.class.getResource("down_16.png"), "Next"));
        this.searchNext.setToolTipText("Next");
        this.searchNext.setEnabled(this.descriptor.isSearch());
        buttonPanel.add(this.searchNext);
        this.searchPrev = new JButton(new ImageIcon(Console.class.getResource("up_16.png"), "Previous"));
        this.searchPrev.setToolTipText("Previous");
        this.searchPrev.setEnabled(this.descriptor.isSearch());
        buttonPanel.add(this.searchPrev);
        this.searchBox.addActionListener(e -> {
            boolean enable = this.searchBox.isSelected() && !this.searchField.getText().isBlank();
            this.searchField.setEnabled(enable);
            this.searchNext.setEnabled(enable);
            this.searchPrev.setEnabled(enable);
        });
        buttonPanel.add(Box.createRigidArea(Const.HDIM2));
        JButton settingsButton = new JButton(new ImageIcon(Console.class.getResource("settings_16.png"), "Properties..."));
        settingsButton.setToolTipText("Properties...");
        settingsButton.addActionListener(e -> this.displayPropertiesDialog());
        buttonPanel.add(settingsButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.add((Component)buttonPanel, "South");
        this.clearAction = new AbstractAction("Clear"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextPage.this.clear();
            }
        };
        this.clearAction.putValue("ShortDescription", "Remove all channels from this page.");
        this.clearAction.setEnabled(false);
        this.refreshAction = new AbstractAction("Refresh"){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextPage.this.refresh();
            }
        };
        this.refreshAction.putValue("ShortDescription", "Refresh all channels. Do not change time window.");
        this.refreshAction.setEnabled(false);
    }

    public void setDateTimeFormat(DateTimeFormatter format) {
        this.descriptor.setDateTimeFormat(format);
        this.reprintMain();
    }

    public TimeWindow getTimeWindow() {
        String s = this.descriptor.getTimeWindow();
        return s == null ? null : TimeWindow.parseCompressedString(s);
    }

    public void setTimeWindow(TimeWindow timeWindow) {
        TimeWindow tw = this.getTimeWindow();
        this.descriptor.setTimeWindow(timeWindow == null ? null : timeWindow.toCompressedString());
        if (timeWindow == null || !timeWindow.equalsTime(tw)) {
            this.refresh();
        }
    }

    public void add(final Trend.Descriptor channel) {
        new SwingWorker<Dataset, Object>(){

            @Override
            protected Dataset doInBackground() throws Exception {
                return TextPage.this.fetchData(channel);
            }

            @Override
            protected void done() {
                try {
                    Dataset out = (Dataset)this.get();
                    TextPage.this.data.add(out);
                    TextPage.this.descriptor.add(channel);
                    TextPage.this.reprintHead();
                    TextPage.this.reprintMain();
                    TextPage.this.clearAction.setEnabled(true);
                    TextPage.this.refreshAction.setEnabled(true);
                }
                catch (InterruptedException | RuntimeException | ExecutionException x) {
                    Console.getConsole().error("Unable to fetch trending data for " + channel.getDisplayPath(), x);
                }
            }
        }.execute();
    }

    public void clear() {
        this.descriptor.setTrends(null);
        this.data.clear();
        this.headPanel.setText("");
        this.mainPanel.setText("");
        this.clearAction.setEnabled(false);
        this.refreshAction.setEnabled(false);
    }

    public void refresh() {
        final Trend.Descriptor[] trends = this.getDescriptor().getTrends();
        new SwingWorker<Dataset[], Object>(){

            @Override
            protected Dataset[] doInBackground() throws Exception {
                Dataset[] out = new Dataset[trends.length];
                for (int i = 0; i < trends.length; ++i) {
                    Trend.Descriptor trend = trends[i];
                    try {
                        out[i] = TextPage.this.fetchData(trend);
                        continue;
                    }
                    catch (RuntimeException x) {
                        out[i] = new Dataset(trend, x);
                    }
                }
                return out;
            }

            @Override
            protected void done() {
                try {
                    Trend.Descriptor[] currentTrends = TextPage.this.descriptor.getTrends();
                    if (!Objects.deepEquals(trends, currentTrends)) {
                        return;
                    }
                    Dataset[] out = (Dataset[])this.get();
                    TextPage.this.data.clear();
                    TextPage.this.headPanel.setText("");
                    TextPage.this.mainPanel.setText("");
                    TextPage.this.data.addAll(Arrays.asList(out));
                    TextPage.this.reprintHead();
                    TextPage.this.reprintMain();
                }
                catch (InterruptedException | CancellationException | ExecutionException x) {
                    Console.getConsole().error("Failed to refresh trending text page", x);
                }
            }
        }.execute();
    }

    public boolean contains(Trend.Descriptor channel) {
        for (Trend.Descriptor t : this.descriptor.getTrends()) {
            if (!t.equals(channel)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JPopupMenu modifyPopup(JPopupMenu menu, Component component, Point point) {
        menu.insert(new AbstractAction("Page properties..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextPage.this.displayPropertiesDialog();
            }
        }, 0);
        menu.insert(this.clearAction, 0);
        menu.insert(this.refreshAction, 0);
        return menu;
    }

    private void displayPropertiesDialog() {
        SettingsPanel sp = new SettingsPanel();
        int out = JOptionPane.showConfirmDialog(this, sp, "Trending Text Page Properties", 2);
        if (out == 0) {
            sp.save();
            this.reprintHead();
            this.reprintMain();
        }
    }

    private void reprintHead() {
        this.headPanel.setText("");
        int n = this.descriptor.getTrends().length;
        try {
            for (int i = 0; i < n; ++i) {
                Color color;
                Trend.Descriptor trend = this.descriptor.getTrends()[i];
                JCheckBox cb = new JCheckBox(trend.getDisplayPath());
                if (n > 1) {
                    color = RAINBOW[i];
                    cb.setForeground(color);
                } else {
                    color = null;
                }
                cb.setSelected(this.descriptor.isTrendEnabled(i));
                cb.addActionListener(new DataSetEnabler(i, cb));
                SimpleAttributeSet attrs = new SimpleAttributeSet();
                StyleConstants.setComponent(attrs, cb);
                this.headDoc.insertString(this.headDoc.getLength(), System.lineSeparator(), attrs);
                this.printHeadItem(this.data.get((int)i).header, color);
            }
        }
        catch (BadLocationException x) {
            this.headPanel.setText(x.toString());
        }
    }

    private void reprintMain() {
        DataIterator it;
        this.mainPanel.setText("");
        if (this.data.isEmpty()) {
            return;
        }
        Predicate<String> filter = null;
        if (this.filterBox.isSelected()) {
            try {
                filter = Pattern.compile(this.filterField.getText()).asPredicate();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        DataIterator dataIterator = it = this.data.size() == 1 ? new DataIterator1() : new DataIteratorN();
        while (it.hasNext()) {
            Item item = (Item)it.next();
            if (filter != null && !filter.test(this.toString(item))) continue;
            this.printMainItem(item, it.getColor());
        }
    }

    private Dataset fetchData(Trend.Descriptor channel) {
        String path = channel.getPath();
        int i1 = path.indexOf("/");
        int i2 = path.indexOf("/", i1 + 1);
        if (i1 < 0 || i2 < 0 || !path.substring(i1, i2 + 1).equals("/alerts/")) {
            throw new IllegalArgumentException("Cannot handle path " + path);
        }
        String agent = path.substring(0, i1);
        String alertID = path.substring(i2 + 1);
        TimeWindow timeWindow = this.getTimeWindow();
        long now = System.currentTimeMillis();
        long begin = timeWindow.getLowerEdge(now);
        long end = timeWindow.getUpperEdge(now);
        AlertInfo.AlertInfoList alertList = this.restService.getAlertList(agent, begin);
        if (alertList == null) {
            throw new RuntimeException("REST server is not available.");
        }
        AlertInfo info = alertList.list.stream().filter(a -> a.getAlertId().equals(alertID)).findAny().orElseThrow();
        Item header = new Item();
        header.text = new String[5];
        header.att = new Style[5];
        header.text[0] = "Sebsystem: ";
        header.text[1] = info.getSubsystemName();
        header.att[1] = this.getStyle(this.headDoc, StyleConstants.Bold);
        header.text[2] = "Alert ID: ";
        header.text[3] = info.getAlertId() + ". ";
        header.att[3] = this.getStyle(this.headDoc, StyleConstants.Bold);
        header.text[4] = info.getAlertDescription();
        header.att[4] = this.getStyle(this.headDoc, new Object[0]);
        List<AlertEvent> alertEvents = this.restService.geAlerts(begin, end, agent + "/" + alertID);
        if (alertEvents.size() > 10000) {
            alertEvents = alertEvents.subList(alertEvents.size() - 10000, alertEvents.size());
        }
        ArrayList<Item> items = new ArrayList<Item>(alertEvents.size());
        for (AlertEvent e : alertEvents) {
            Item item = new Item();
            item.time = e.getTime();
            item.text = new String[3];
            item.att = new Style[3];
            item.text[0] = info.getAlertId();
            item.text[1] = e.getSeverity().toString();
            item.att[1] = this.getStyle(this.mainDoc, LsstAlertPlugin.COLOR.get(e.getSeverity()));
            item.text[2] = e.getCause();
            items.add(item);
        }
        return new Dataset(channel, header, items);
    }

    private String formatTime(long millis) {
        return (this.descriptor.dateTimeFormat == null ? Const.DEFAULT_DT_FORMAT : this.descriptor.dateTimeFormat).format(Instant.ofEpochMilli(millis));
    }

    private void printMainItem(Item item, Color color) {
        try {
            this.mainDoc.insertString(this.mainDoc.getLength(), this.formatTime(item.time) + " ", this.getStyle(this.mainDoc, color));
            for (int i = 0; i < item.text.length; ++i) {
                this.mainDoc.insertString(this.mainDoc.getLength(), item.text[i] + " ", item.att[i]);
            }
            this.mainDoc.insertString(this.mainDoc.getLength(), System.lineSeparator(), this.getStyle(this.mainDoc, new Object[0]));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void printHeadItem(Item item, Color color) {
        try {
            for (int i = 0; i < item.text.length; ++i) {
                this.headDoc.insertString(this.headDoc.getLength(), item.text[i] + " ", item.att[i]);
            }
            this.headDoc.insertString(this.headDoc.getLength(), System.lineSeparator(), this.getStyle(this.headDoc, new Object[0]));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private Style getStyle(StyledDocument doc, Object ... att) {
        String name = switch (att.length) {
            case 0 -> "default";
            case 1 -> att[0].toString();
            default -> String.join((CharSequence)"+", Arrays.stream(att).map(a -> a.toString()).toList());
        };
        Style out = doc.getStyle(name);
        if (out == null) {
            out = doc.addStyle(name, doc.getStyle("default"));
            for (Object a2 : att) {
                List pair;
                if (a2 instanceof Color) {
                    Color color = (Color)a2;
                    StyleConstants.setForeground(out, color);
                    continue;
                }
                if (a2 instanceof StyleConstants) {
                    StyleConstants key = (StyleConstants)a2;
                    out.addAttribute(key, true);
                    continue;
                }
                if (!(a2 instanceof List) || (pair = (List)a2).size() != 2) continue;
                Iterator it = pair.iterator();
                out.addAttribute(it.next(), it.next());
            }
        }
        return out;
    }

    private String toString(Item item) {
        StringBuilder sb = new StringBuilder(this.formatTime(item.time));
        if (item.text != null) {
            sb.append(" ").append(String.join((CharSequence)" ", item.text));
        }
        return sb.toString();
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = this.getDescriptor().clone();
        DataPanelDescriptor pd = DataPanelDescriptor.get(this);
        desc.setPanel(pd);
        return desc;
    }

    @Override
    public void restore(Persistable.Descriptor d) {
        if (d instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)d;
        }
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private String timeWindow;
        private Trend.Descriptor[] trends;
        private boolean[] trendEnabled;
        private DateTimeFormatter dateTimeFormat;
        private boolean filter;
        private String filterString;
        private boolean search;
        private String searchString;
        private boolean latestOnTop;
        private DataPanelDescriptor panel;

        @Override
        public String getCategory() {
            return TextPage.CATEGORY;
        }

        @Override
        public void setCategory(String category) {
        }

        public String getTimeWindow() {
            return this.timeWindow;
        }

        public void setTimeWindow(String timeWindow) {
            this.timeWindow = timeWindow;
        }

        public Trend.Descriptor[] getTrends() {
            return this.trends == null ? new Trend.Descriptor[]{} : Arrays.copyOf(this.trends, this.trends.length);
        }

        public void setTrends(Trend.Descriptor[] trends) {
            this.trends = trends == null || trends.length == 0 ? null : Arrays.copyOf(trends, trends.length);
        }

        public boolean[] getTrendEnabled() {
            if (this.trendEnabled == null) {
                boolean[] out = new boolean[this.trends == null ? 0 : this.trends.length];
                Arrays.fill(out, true);
                return out;
            }
            return Arrays.copyOf(this.trendEnabled, this.trendEnabled.length);
        }

        public void setTrendEnabled(boolean[] trendEnabled) {
            if (trendEnabled == null || trendEnabled.length == 0) {
                this.trendEnabled = null;
            } else {
                for (boolean b : trendEnabled) {
                    if (b) continue;
                    this.trendEnabled = Arrays.copyOf(trendEnabled, trendEnabled.length);
                    return;
                }
                this.trendEnabled = null;
            }
        }

        public boolean isTrendEnabled(int index) {
            return this.trendEnabled == null ? true : this.trendEnabled[index];
        }

        public void setTrendEnabled(int index, boolean b) {
            if (this.trendEnabled == null) {
                if (!b) {
                    this.trendEnabled = new boolean[this.trends.length];
                    for (int i = 0; i < this.trends.length; ++i) {
                        this.trendEnabled[i] = i != index;
                    }
                }
            } else {
                this.trendEnabled[index] = b;
                if (b) {
                    for (int i = 0; i < this.trendEnabled.length; ++i) {
                        if (this.trendEnabled[i]) continue;
                        return;
                    }
                    this.trendEnabled = null;
                }
            }
        }

        public DateTimeFormatter getDateTimeFormat() {
            return this.dateTimeFormat;
        }

        public void setDateTimeFormat(DateTimeFormatter dateTimeFormat) {
            this.dateTimeFormat = dateTimeFormat;
        }

        public DataPanelDescriptor getPanel() {
            return this.panel;
        }

        public void setPanel(DataPanelDescriptor panel) {
            this.panel = panel;
        }

        public String getSearchString() {
            return this.searchString == null ? "" : this.searchString;
        }

        public void setSearchString(String searchString) {
            this.searchString = searchString == null || searchString.isBlank() ? null : searchString;
        }

        public boolean isSearch() {
            return this.search;
        }

        public void setSearch(boolean search) {
            this.search = search;
        }

        public String getFilterString() {
            return this.filterString == null ? "" : this.filterString;
        }

        public void setFilterString(String filterString) {
            this.filterString = filterString == null || filterString.isBlank() ? null : filterString;
        }

        public boolean isFilter() {
            return this.filter;
        }

        public void setFilter(boolean filter) {
            this.filter = filter;
        }

        public boolean isLatestOnTop() {
            return this.latestOnTop;
        }

        public void setLatestOnTop(boolean latestOnTop) {
            this.latestOnTop = latestOnTop;
        }

        void add(Trend.Descriptor trend) {
            if (this.trends == null) {
                this.trends = new Trend.Descriptor[]{trend};
            } else {
                int n = this.trends.length;
                this.trends = Arrays.copyOf(this.trends, n + 1);
                this.trends[n] = trend;
                if (this.trendEnabled != null) {
                    this.trendEnabled = Arrays.copyOf(this.trendEnabled, n + 1);
                    this.trendEnabled[n] = true;
                }
            }
        }

        @Override
        public Descriptor clone() {
            Descriptor clone = (Descriptor)super.clone();
            if (this.trends != null) {
                int n = this.trends.length;
                clone.trends = Arrays.copyOf(this.trends, n);
                if (this.trendEnabled != null) {
                    clone.trendEnabled = Arrays.copyOf(this.trendEnabled, n);
                }
            }
            if (this.panel != null) {
                clone.panel = this.panel.clone();
            }
            return clone;
        }
    }

    private class SettingsPanel
    extends JPanel {
        private final JCheckBox latestOnTopBox;

        SettingsPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
            Box root = Box.createVerticalBox();
            this.add(root);
            this.latestOnTopBox = new JCheckBox("Display records in reverse chronological order.");
            this.latestOnTopBox.setSelected(TextPage.this.descriptor.isLatestOnTop());
            root.add(this.latestOnTopBox);
            root.add(Box.createVerticalGlue());
        }

        void save() {
            TextPage.this.descriptor.setLatestOnTop(this.latestOnTopBox.isSelected());
        }
    }

    private class DataSetEnabler
    implements ActionListener {
        final int index;
        final JCheckBox checkBox;

        DataSetEnabler(int index, JCheckBox checkBox) {
            this.index = index;
            this.checkBox = checkBox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextPage.this.getDescriptor().setTrendEnabled(this.index, this.checkBox.isSelected());
            TextPage.this.reprintMain();
        }
    }

    private class Dataset
    implements Iterable<Item> {
        final Trend.Descriptor trend;
        Item header;
        List<Item> items;

        Dataset(Trend.Descriptor trend, Item header, List<Item> items) {
            this.trend = trend;
            this.header = header;
            this.items = items;
        }

        Dataset(Trend.Descriptor trend, Exception x) {
            this.trend = trend;
            this.header = new Item(new String[]{trend.getDisplayPath()}, new Style[]{TextPage.this.getStyle(TextPage.this.headDoc, new Object[0])});
        }

        @Override
        public ListIterator<Item> iterator() {
            return TextPage.this.descriptor.isLatestOnTop() ? new ListIterator<Item>(){
                ListIterator<Item> delegate;
                {
                    this.delegate = Dataset.this.items.listIterator(Dataset.this.items.size());
                }

                @Override
                public boolean hasNext() {
                    return this.delegate.hasPrevious();
                }

                @Override
                public Item next() {
                    return this.delegate.previous();
                }

                @Override
                public boolean hasPrevious() {
                    return this.delegate.hasNext();
                }

                @Override
                public Item previous() {
                    return this.delegate.next();
                }

                @Override
                public int nextIndex() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int previousIndex() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(Item e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(Item e) {
                    throw new UnsupportedOperationException();
                }
            } : this.items.listIterator();
        }
    }

    private static class Item {
        long time;
        String[] text;
        Style[] att;

        Item() {
        }

        Item(long time, String[] text, Style[] att) {
            this.time = time;
            this.text = text;
            this.att = att;
        }

        Item(String[] text, Style[] att) {
            this(System.currentTimeMillis(), text, att);
        }

        Item(String text, Style att) {
            this(System.currentTimeMillis(), new String[]{text}, new Style[]{att});
        }
    }

    private class DataIterator1
    implements DataIterator {
        private final ListIterator<Item> it;

        private DataIterator1() {
            this.it = TextPage.this.data.get(0).iterator();
        }

        @Override
        public int getIndex() {
            return 0;
        }

        @Override
        public Color getColor() {
            return Color.BLACK;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Item next() {
            return this.it.next();
        }
    }

    private class DataIteratorN
    implements DataIterator {
        private boolean empty;
        private int index = -1;
        private final TreeMap<Long, LinkedList<DSIterator>> head;

        DataIteratorN() {
            this.head = TextPage.this.descriptor.isLatestOnTop() ? new TreeMap(Comparator.reverseOrder()) : new TreeMap();
            for (int i = 0; i < TextPage.this.data.size(); ++i) {
                Iterator it;
                if (TextPage.this.descriptor.trendEnabled != null && !TextPage.this.descriptor.trendEnabled[i] || !(it = TextPage.this.data.get(i).iterator()).hasNext()) continue;
                DSIterator dsi = new DSIterator((ListIterator<Item>)it, i);
                this.add(dsi);
            }
            this.empty = this.head.isEmpty();
        }

        @Override
        public boolean hasNext() {
            return !this.empty;
        }

        @Override
        public Item next() {
            if (this.empty) {
                throw new NoSuchElementException();
            }
            Map.Entry<Long, LinkedList<DSIterator>> e = this.head.pollFirstEntry();
            LinkedList<DSIterator> list = e.getValue();
            DSIterator it = list.poll();
            if (!list.isEmpty()) {
                this.head.put(e.getKey(), list);
            }
            Item out = it.next();
            if (it.hasNext()) {
                this.add(it);
            } else {
                this.empty = this.head.isEmpty();
            }
            this.index = it.getIndex();
            return out;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Color getColor() {
            return RAINBOW[this.getIndex() % RAINBOW.length];
        }

        private void add(DSIterator it) {
            long time = it.next().time;
            it.previous();
            this.head.computeIfAbsent(time, t -> new LinkedList()).add(it);
        }

        private static class DSIterator {
            private final ListIterator<Item> it;
            private final int index;

            DSIterator(ListIterator<Item> it, int index) {
                this.it = it;
                this.index = index;
            }

            Item next() {
                return this.it.next();
            }

            Item previous() {
                return this.it.previous();
            }

            boolean hasNext() {
                return this.it.hasNext();
            }

            int getIndex() {
                return this.index;
            }
        }
    }

    private static interface DataIterator
    extends Iterator<Item> {
        public int getIndex();

        public Color getColor();
    }
}

