/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.IOException;
import org.lsst.ccs.daq.ims.channel.ReadableIntChannel;

public class MultiplexingIntChannel
implements ReadableIntChannel {
    private ReadableIntChannel[] input;
    private final int size;
    private int next;

    MultiplexingIntChannel(ReadableIntChannel ... input) {
        this.input = input;
        this.size = input.length;
        this.next = 0;
    }

    @Override
    public int read() throws IOException {
        int result = this.input[this.next].read();
        this.next = (this.next + 1) % this.size;
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.input != null) {
            for (ReadableIntChannel in : this.input) {
                in.close();
            }
            this.input = null;
        }
    }

    @Override
    public boolean isOpen() {
        return this.input != null;
    }
}

