/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;
import org.lsst.ccs.subsystem.rafts.fpga.main.BigDecimalOptionHandler;

public class Compiler {
    @Argument(required=true, usage="Input (.seq) File")
    private File file;
    @Argument(required=false, index=1, usage="Output (.compiled) file")
    private File outputFile;
    @Option(name="--noheader", usage="Suppress output file header")
    private boolean noHeader;
    @Option(name="-c", aliases={"--clockperiod"}, usage="Override the clockperiod specified in the .seq file", handler=BigDecimalOptionHandler.class)
    private BigDecimal clockPeriodOverride = null;

    public static void main(String[] args) throws FileNotFoundException, IOException {
        new Compiler().doMain(args);
    }

    private void doMain(String[] args) throws FileNotFoundException, IOException {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
            this.compile();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java Compiler [options...] arguments...");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
        }
    }

    private void compile() throws FileNotFoundException, IOException {
        String fileName = this.file.getName();
        if (this.outputFile == null) {
            String outputFileName = fileName.endsWith(".seq") ? fileName.replace(".seq", ".compiled") : fileName.concat(".compiled");
            this.outputFile = new File(outputFileName);
        }
        try (FileInputStream input = new FileInputStream(this.file);){
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model compiled = builder.compileFile(input, this.clockPeriodOverride);
            List<FPGA2Model.AddressAndValue> data = compiled.getMemoryMap();
            try (PrintWriter pw = new PrintWriter(this.outputFile);){
                if (!this.noHeader) {
                    this.printHeader(pw, fileName, compiled);
                }
                data.forEach(datum -> pw.printf("%08x: %08x\n", datum.getAddress(), datum.getValue()));
            }
        }
    }

    private void printHeader(PrintWriter pw, String fileName, FPGA2Model compiled) {
        pw.printf("# Compilation of %s at %s\n", fileName, new Date());
        pw.printf("# Checksum: %08x\n", compiled.computeCheckSum());
        pw.println("#---");
        pw.println("#--- POINTERS");
        pw.println("#---");
        compiled.getPointers().stream().forEach(i -> pw.printf("# %-20s  %03x  %s\n", new Object[]{i.getKind(), i.getOffset(), i.getName()}));
        pw.println("#---");
        pw.println("#--- MAINS");
        pw.println("#---");
        compiled.getMainAddresses().entrySet().stream().forEach(i -> pw.printf("# %-20s  %08x \n", i.getKey(), i.getValue()));
    }
}

