/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.data;

import java.io.Serializable;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.power.constants.ComCamQuadBoxSwitches;
import org.lsst.ccs.subsystem.power.constants.SwitchState;

@SkipEncoding
public class ComCamQuadBoxState
implements Serializable {
    public static final String KEY = "ComCamQuadBoxState";
    private int tickMillis;
    private final SwitchState[][] switchState = new SwitchState[5][];
    private static final long serialVersionUID = 7396502803894290440L;

    public ComCamQuadBoxState() {
        this.switchState[0] = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[0] + 1];
        this.switchState[1] = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[1] + 1];
        this.switchState[2] = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[2] + 1];
        this.switchState[3] = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[3] + 1];
        this.switchState[4] = new SwitchState[ComCamQuadBoxSwitches.NUM_SWITCHES[4] + 1];
    }

    public void setTickMillis(int tickMillis) {
        this.tickMillis = tickMillis;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setSwitchState(int devNum, int swNum, SwitchState st) {
        this.switchState[devNum][swNum + 1] = st;
    }

    public SwitchState getSwitchState(int devNum, int swNum) {
        return this.switchState[devNum][swNum + 1];
    }

    public void setSwitchState(int swId, SwitchState st) {
        this.switchState[swId >> 8][(byte)swId + 1] = st;
    }

    public SwitchState getSwitchState(int swId) {
        return this.switchState[swId >> 8][(byte)swId + 1];
    }
}

