/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.rest.file.server.client.implementation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.rest.file.server.client.RestFileSystemOptions;

class RestFileSystemOptionsHelper {
    private final Map<String, ?> env;
    private static final Logger LOG = Logger.getLogger(RestFileSystemOptionsHelper.class.getName());
    private static final URI defaultMountPoint = URI.create(".");

    RestFileSystemOptionsHelper(Map<String, ?> env) {
        this.env = env == null ? this.createDefaultOptions() : env;
    }

    RestFileSystemOptions.CacheOptions getCacheOptions() {
        return this.getOption("CacheOptions", RestFileSystemOptions.CacheOptions.class, RestFileSystemOptions.CacheOptions.NONE);
    }

    RestFileSystemOptions.SSLOptions isUseSSL() {
        return this.getOption("UseSSL", RestFileSystemOptions.SSLOptions.class, RestFileSystemOptions.SSLOptions.AUTO);
    }

    RestFileSystemOptions.CacheFallback getCacheFallback() {
        return this.getOption("CacheFallback", RestFileSystemOptions.CacheFallback.class, RestFileSystemOptions.CacheFallback.OFFLINE);
    }

    boolean isCacheLogging() {
        return this.getOption("CacheLogging", Boolean.class, Boolean.FALSE);
    }

    boolean allowAlternateCacheLoction() {
        return this.getOption("CacheFallbackLocation", Boolean.class, Boolean.FALSE);
    }

    Path getDiskCacheLocation() {
        Object result = this.env.get("CacheLocation");
        if (result == null) {
            return null;
        }
        if (result instanceof Path) {
            return (Path)result;
        }
        if (result instanceof File) {
            return ((File)result).toPath();
        }
        if (result instanceof String) {
            return Paths.get((String)result, new String[0]);
        }
        throw new IllegalArgumentException("Invalid value for option CacheLocation: " + result);
    }

    URI getMountPoint() {
        Object result = this.env.get("MountPoint");
        if (result == null) {
            return defaultMountPoint;
        }
        if (result instanceof URI) {
            return (URI)result;
        }
        if (result instanceof String) {
            return URI.create((String)result);
        }
        throw new IllegalArgumentException("Invalid value for option MountPoint: " + result);
    }

    private <T> T getOption(String optionName, Class<T> type, T defaultValue) {
        Object result = this.env.get(optionName);
        if (result == null) {
            result = defaultValue;
        }
        if (type.isInstance(result)) {
            return type.cast(result);
        }
        if (result instanceof String) {
            try {
                Method method = type.getMethod("valueOf", String.class);
                if (type.isAssignableFrom(method.getReturnType())) {
                    return type.cast(method.invoke(null, result));
                }
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid value for option " + optionName + ": " + result);
    }

    private Map<String, ?> createDefaultOptions() {
        String defaultOptions = System.getProperty("org.lsst.ccs.rest.file.client.defaultEnvironment");
        if (defaultOptions != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return (Map)objectMapper.readValue(defaultOptions, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (JsonProcessingException x) {
                LOG.log(Level.WARNING, "Unable to parse default rest server options: " + defaultOptions, x);
            }
        }
        return null;
    }
}

