/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.jgroups;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.plugins.jgroups.ProbePage;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;

@Plugin(name="LSST JGroups Plugin", id="jgroups", description="LSST CCS JGroups plugin provides tools for monitoring and directly interacting with the JGroups messaging system.", shortDescription="LSST JGroups Monitor")
public class LsstJGroupsPlugin
extends ConsolePlugin {
    private final ArrayList<ProbePage> probePages = new ArrayList(0);

    @Override
    public void initialize() {
        AbstractAction newDictionaryAction = new AbstractAction("Probe"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstJGroupsPlugin.this.createProbePage(null);
            }
        };
        this.getServices().addMenu(newDictionaryAction, "400: CCS Tools :-1:20", "JGroups:0");
    }

    private void createProbePage(ProbePage.Descriptor descriptor) {
        HashMap<String, Serializable> data;
        if (descriptor == null) {
            descriptor = new ProbePage.Descriptor();
        }
        ProbePage page = new ProbePage();
        page.restore(descriptor);
        HashMap<Object, Object> par = new HashMap<Object, Object>();
        DataPanelDescriptor panDesc = descriptor.getPage();
        if (panDesc != null && panDesc.isOpen() && (data = panDesc.getData()) != null) {
            par.putAll(data);
        }
        par.put(Panel.TITLE, "JGroups");
        Consumer<JComponent> onClose = c -> {
            this.probePages.remove(c);
            this.probePages.trimToSize();
        };
        par.put(Panel.ON_CLOSE, onClose);
        this.getConsole().getPanelManager().open((Component)page, par);
        this.probePages.add(page);
        this.probePages.trimToSize();
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        ProbePage.Descriptor[] dd;
        if (!(storageBean instanceof Descriptor)) {
            return true;
        }
        Descriptor desc = (Descriptor)storageBean;
        if (!this.probePages.isEmpty()) {
            ArrayList<ProbePage> copy = new ArrayList<ProbePage>(this.probePages);
            PanelManager panMan = this.getConsole().getPanelManager();
            copy.forEach(pp -> panMan.close((Component)pp));
            this.probePages.clear();
        }
        if ((dd = desc.getProbePages()) != null) {
            for (ProbePage.Descriptor d : dd) {
                this.createProbePage(d);
            }
        }
        return true;
    }

    @Override
    public Descriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        if (!this.probePages.isEmpty()) {
            ProbePage.Descriptor[] descriptors = new ProbePage.Descriptor[this.probePages.size()];
            for (int i = 0; i < descriptors.length; ++i) {
                descriptors[i] = this.probePages.get(i).save();
            }
            desc.setProbePages(descriptors);
        }
        return desc;
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private ProbePage.Descriptor[] probePages;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public ProbePage.Descriptor[] getProbePages() {
            return this.probePages;
        }

        public void setProbePages(ProbePage.Descriptor[] probePages) {
            this.probePages = probePages;
        }
    }
}

