/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.alert;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Objects;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.messages.BusMessage;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.gconsole.agent.command.CommandHandle;
import org.lsst.ccs.gconsole.agent.command.CommandSender;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.alert.AlertViewer;
import org.lsst.ccs.gconsole.plugins.tracer.LsstTracerPlugin;
import org.lsst.ccs.gconsole.plugins.tracer.Tracer;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.services.alert.AlertService;

@Plugin(name="LSST Alert Notification Plugin", id="alert", description="LSST CCS alert notification service.")
public class LsstAlertPlugin
extends ConsolePlugin {
    private static final String OPT_AUTO_START_VIEWER = "autoStartViewer";
    private static final String OPT_AUTO_START_TRACER = "autoStartTracer";
    static final String OPT_SOUND = "sound";
    static final String OPT_TOFRONT = "toFront";
    static final String OPT_SELECT = "selectLast";
    static final String OPT_IGNOREMUTED = "ignoreMuted";
    static final String OPT_IGNOREACK = "ignoreAck";
    public static final EnumMap<AlertState, Color> COLOR = new EnumMap(AlertState.class);
    private AlertService alertService;
    private CommandSender commandSender;
    private Action viewerAction;
    private volatile AlertViewer viewer;

    @Override
    public void initialize() {
        this.alertService = (AlertService)this.getConsole().getAgentService(AlertService.class);
        this.commandSender = CommandService.getService().getSender();
        this.commandSender.setCommandHandle(CommandHandle.NONE);
        this.getServices().addProperty(OPT_AUTO_START_VIEWER, false);
        this.getServices().addPreference(new String[]{"LSST", "Alerts"}, "Startup", "${autoStartViewer} Start viewer on console sturtup.");
        this.getServices().addProperty(OPT_AUTO_START_TRACER, false);
        this.getServices().addPreference(new String[]{"LSST", "Alerts"}, "Startup", "${autoStartTracer} Start message viewer on console sturtup.");
        this.getServices().addProperty(OPT_SOUND, true);
        this.getServices().addProperty(OPT_TOFRONT, true);
        this.getServices().addProperty(OPT_SELECT, true);
        this.getServices().addProperty(OPT_IGNOREACK, true);
        this.getServices().addProperty(OPT_IGNOREMUTED, true);
        this.viewerAction = new AbstractAction("Viewer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (((Boolean)this.getValue("SwingSelectedKey")).booleanValue()) {
                    LsstAlertPlugin.this.onNewAlertViewer(null);
                } else {
                    LsstAlertPlugin.this.stopAlertViewer();
                }
            }
        };
        this.viewerAction.putValue("SwingSelectedKey", false);
        this.getServices().addMenu(this.viewerAction, "400: CCS Tools :-1:4", "Alerts:1");
        AbstractAction act = new AbstractAction("Messages"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LsstAlertPlugin.this.onNewAlertTracer();
            }
        };
        this.getServices().addMenu(act, "400: CCS Tools :-1:4", "Alerts:2");
        ImageIcon icon = new ImageIcon(this.getClass().getResource("alert_16.png"));
        act = new AbstractAction("Alerts", icon){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LsstAlertPlugin.this.viewer == null) {
                    LsstAlertPlugin.this.onNewAlertViewer(null);
                } else {
                    LsstAlertPlugin.this.viewer.toFront();
                }
            }
        };
        act.putValue("ShortDescription", "Show alert viewer");
        this.getConsole().insertToolbarAction(act, 1);
    }

    @Override
    public void start() {
        if (((Boolean)this.getServices().getProperty(OPT_AUTO_START_VIEWER)).booleanValue()) {
            this.onNewAlertViewer(null);
        }
        if (((Boolean)this.getServices().getProperty(OPT_AUTO_START_TRACER)).booleanValue()) {
            this.onNewAlertTracer();
        }
    }

    @Override
    public void shutdown() {
    }

    public void onNewAlertViewer(AlertViewer.Descriptor config) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.viewer == null) {
                this.viewerAction.putValue("SwingSelectedKey", true);
                this.viewer = new AlertViewer(this, config);
                this.alertService.addListener((AlertListener)this.viewer);
            }
        } else {
            SwingUtilities.invokeLater(() -> this.onNewAlertViewer(config));
        }
    }

    public void stopAlertViewer() {
        if (SwingUtilities.isEventDispatchThread()) {
            if (this.viewer != null) {
                this.viewerAction.putValue("SwingSelectedKey", false);
                this.alertService.removeListener((AlertListener)this.viewer);
                this.viewer.destroy();
                this.viewer = null;
            }
        } else {
            SwingUtilities.invokeLater(this::stopAlertViewer);
        }
    }

    public void onNewAlertTracer() {
        Tracer tracer = new Tracer();
        tracer.getDescriptor().setName("Alerts");
        tracer.setFilter(filteredMessage -> {
            BusMessage bm = filteredMessage.getMessage();
            if (bm instanceof StatusRaisedAlert) {
                StatusRaisedAlert am = (StatusRaisedAlert)bm;
                Alert alert = am.getRaisedAlert();
                String id = alert.getAlertId();
                StringBuilder sb = new StringBuilder();
                sb.append(AlertViewer.formatTimeStamp(am.getCCSTimeStamp().getUTCInstant())).append(" : ");
                sb.append(am.getRaisedAlertState());
                sb.append(" from ").append(am.getOriginAgentInfo().getName()).append(".\n");
                sb.append("ID: ").append(id).append(".  Description:\n");
                sb.append(alert.getDescription()).append("\n");
                filteredMessage.setText(sb.toString());
                return filteredMessage;
            }
            if (bm instanceof StatusClearedAlert) {
                StatusClearedAlert am = (StatusClearedAlert)bm;
                StringBuilder sb = new StringBuilder();
                sb.append(AlertViewer.formatTimeStamp(am.getCCSTimeStamp().getUTCInstant())).append(" : ");
                sb.append(am.getOriginAgentInfo().getName()).append(" cleared alerts ");
                for (String id : am.getClearAlertIds()) {
                    sb.append(id).append(", ");
                }
                sb.delete(sb.length() - 2, sb.length()).append(".\n");
                filteredMessage.setText(sb.toString());
                return filteredMessage;
            }
            return null;
        });
        LsstTracerPlugin tracerPlugin = (LsstTracerPlugin)this.getConsole().getConsoleLookup().lookup(LsstTracerPlugin.class);
        tracerPlugin.openTracer(tracer);
    }

    public void clearAlerts(String subsystem, AlertState maxSeverity, String ... ids) {
        block18: {
            if (this.getConsole().getMessagingAccess().getAgentPresenceManager().agentExists(subsystem)) {
                CommandTask task;
                if (ids == null) {
                    task = maxSeverity == AlertState.ALARM ? this.commandSender.send(subsystem, "clearAllAlerts", "--" + AgentCommandDictionaryService.withLockOption.getName()) : this.commandSender.send(subsystem, "clearAllWarnings");
                } else if (maxSeverity == AlertState.ALARM) {
                    String[] args = new String[ids.length + 1];
                    System.arraycopy(ids, 0, args, 1, ids.length);
                    args[0] = "--" + AgentCommandDictionaryService.withLockOption.getName();
                    task = this.commandSender.sendEncoded(subsystem, "clearAlerts", args);
                } else {
                    task = this.commandSender.sendEncoded(subsystem, "clearWarnings", ids);
                }
                try {
                    Object result = task.getResult();
                    if (result instanceof Exception) {
                        Exception x = (Exception)result;
                        this.getConsole().error("Failed to clear alerts.", x);
                        break block18;
                    }
                    if (result instanceof String[]) {
                        String message;
                        String[] cleared = (String[])result;
                        if (cleared.length == 0) {
                            message = "No alerts have been cleared.";
                        } else if (ids == null) {
                            StringBuilder sb = new StringBuilder("<html><b>Cleared:</b>").append(System.lineSeparator());
                            sb.append(String.join((CharSequence)System.lineSeparator(), new TreeSet<String>(Arrays.asList(cleared))));
                            message = sb.toString();
                        } else if (cleared.length == ids.length) {
                            StringBuilder sb = new StringBuilder("All requested alerts have been cleared:").append(System.lineSeparator());
                            sb.append(String.join((CharSequence)System.lineSeparator(), new TreeSet<String>(Arrays.asList(ids))));
                            message = sb.toString();
                        } else {
                            TreeSet<String> yes = new TreeSet<String>(Arrays.asList(cleared));
                            TreeSet<String> no = new TreeSet<String>(Arrays.asList(ids));
                            no.removeAll(yes);
                            StringBuilder sb = new StringBuilder("<html><b>Cleared:</b>").append(System.lineSeparator());
                            yes.forEach(id -> sb.append((String)id).append(System.lineSeparator()));
                            sb.append("<html><p><b>Unable to clear:</b>").append(System.lineSeparator());
                            no.forEach(id -> sb.append((String)id).append(System.lineSeparator()));
                            message = sb.toString();
                        }
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.viewer == null ? null : this.viewer.getGUI(), message, subsystem, -1));
                        break block18;
                    }
                    this.getConsole().error("Failed to clear alerts: " + Objects.toString(result));
                }
                catch (InterruptedException interruptedException) {}
            } else if (ids == null) {
                this.alertService.clearAllAlertsForSource(subsystem);
            } else {
                this.alertService.clearAlertsForSource(subsystem, ids);
            }
        }
    }

    public void ackAlerts(String message, String subsystem, String[] toAck, String[] toNack) {
        if (this.getConsole().getMessagingAccess().getAgentPresenceManager().agentExists(subsystem)) {
            if (toAck.length != 0) {
                String[] args = new String[toAck.length + 1];
                System.arraycopy(toAck, 0, args, 1, toAck.length);
                args[0] = message;
                CommandTask task = this.commandSender.sendEncoded(subsystem, "acknowledgeAlerts", args);
                this.processAckCommand(task, "acknowledge", subsystem, toAck);
            }
            if (toNack.length != 0) {
                CommandTask task = this.commandSender.sendEncoded(subsystem, "unacknowledgeAlerts", toNack);
                this.processAckCommand(task, "unacknowledge", subsystem, toAck);
            }
        }
    }

    private void processAckCommand(CommandTask task, String command, String subsystem, String[] ids) {
        try {
            Object result = task.getResult();
            if (result instanceof Exception) {
                Exception x = (Exception)result;
                this.getConsole().error("Failed to " + command + " alerts. ", x);
            } else if (result instanceof String[]) {
                String[] acked = (String[])result;
                TreeSet<String> request = new TreeSet<String>(Arrays.asList(ids));
                request.removeAll(new TreeSet<String>(Arrays.asList(acked)));
                if (!request.isEmpty()) {
                    String out = "Failed to " + command + " alerts: " + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), request);
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.viewer == null ? null : this.viewer.getGUI(), out, subsystem, -1));
                }
            } else {
                this.getConsole().error("Failed to " + command + " alerts. " + Objects.toString(result));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public ComponentDescriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        desc.setMute((Boolean)this.getServices().getProperty(OPT_SOUND));
        desc.setToFront((Boolean)this.getServices().getProperty(OPT_TOFRONT));
        desc.setSelectLast((Boolean)this.getServices().getProperty(OPT_SELECT));
        desc.setIgnoreAck((Boolean)this.getServices().getProperty(OPT_IGNOREACK));
        desc.setIgnoreMuted((Boolean)this.getServices().getProperty(OPT_IGNOREMUTED));
        if (this.viewer != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                desc.setViewerConfig(this.viewer.save());
            } else {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        if (this.viewer != null) {
                            desc.setViewerConfig(this.viewer.save());
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        return desc;
    }

    @Override
    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        if (!(storageBean instanceof Descriptor)) {
            throw new IllegalArgumentException("Illegal descriptor type: " + storageBean.getClassName());
        }
        Descriptor desc = (Descriptor)storageBean;
        this.getServices().setProperty(OPT_SOUND, desc.isMute());
        this.getServices().setProperty(OPT_TOFRONT, desc.isToFront());
        this.getServices().setProperty(OPT_SELECT, desc.isSelectLast());
        this.getServices().setProperty(OPT_IGNOREACK, desc.isIgnoreAck());
        this.getServices().setProperty(OPT_IGNOREMUTED, desc.isIgnoreMuted());
        AlertViewer.Descriptor viewerConfig = desc.getViewerConfig();
        if (viewerConfig == null) {
            if (this.viewer != null) {
                this.stopAlertViewer();
            }
        } else {
            this.stopAlertViewer();
            this.onNewAlertViewer(viewerConfig);
        }
        return true;
    }

    static {
        COLOR.put(AlertState.NOMINAL, new Color(0, 170, 0));
        COLOR.put(AlertState.WARNING, new Color(0, 0, 170));
        COLOR.put(AlertState.ALARM, new Color(170, 0, 0));
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private boolean selectLast;
        private boolean toFront;
        private boolean mute;
        private boolean history;
        private boolean ignoreAck;
        private boolean ignoreMuted;
        private AlertViewer.Descriptor viewerConfig;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public boolean isSelectLast() {
            return this.selectLast;
        }

        public void setSelectLast(boolean selectLast) {
            this.selectLast = selectLast;
        }

        public boolean isToFront() {
            return this.toFront;
        }

        public void setToFront(boolean toFront) {
            this.toFront = toFront;
        }

        public boolean isMute() {
            return this.mute;
        }

        public void setMute(boolean mute) {
            this.mute = mute;
        }

        public boolean isHistory() {
            return this.history;
        }

        public void setHistory(boolean history) {
            this.history = history;
        }

        public boolean isIgnoreAck() {
            return this.ignoreAck;
        }

        public void setIgnoreAck(boolean ignoreAck) {
            this.ignoreAck = ignoreAck;
        }

        public boolean isIgnoreMuted() {
            return this.ignoreMuted;
        }

        public void setIgnoreMuted(boolean ignoreMuted) {
            this.ignoreMuted = ignoreMuted;
        }

        public AlertViewer.Descriptor getViewerConfig() {
            return this.viewerConfig;
        }

        public void setViewerConfig(AlertViewer.Descriptor viewerConfig) {
            this.viewerConfig = viewerConfig;
        }
    }
}

