/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.rules;

import com.fasterxml.jackson.databind.JsonNode;
import io.confluent.kafka.schemaregistry.rules.RuleAction;
import io.confluent.kafka.schemaregistry.rules.RuleContext;
import io.confluent.kafka.schemaregistry.rules.RuleException;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.DoubleSerializer;
import org.apache.kafka.common.serialization.FloatSerializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.ShortSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlqAction
implements RuleAction {
    private static final Logger log = LoggerFactory.getLogger(DlqAction.class);
    public static final String TYPE = "DLQ";
    public static final String DLQ_TOPIC = "dlq.topic";
    public static final String HEADER_PREFIX = "__rule.";
    public static final String RULE_NAME = "__rule.name";
    public static final String RULE_MODE = "__rule.mode";
    public static final String RULE_SUBJECT = "__rule.subject";
    public static final String RULE_TOPIC = "__rule.topic";
    public static final String RULE_EXCEPTION = "__rule.exception";
    public static final String TOPIC = "topic";
    public static final String AUTO_FLUSH = "auto.flush";
    public static final String PRODUCER = "producer";
    private static final LongSerializer LONG_SERIALIZER = new LongSerializer();
    private static final IntegerSerializer INT_SERIALIZER = new IntegerSerializer();
    private static final ShortSerializer SHORT_SERIALIZER = new ShortSerializer();
    private static final DoubleSerializer DOUBLE_SERIALIZER = new DoubleSerializer();
    private static final FloatSerializer FLOAT_SERIALIZER = new FloatSerializer();
    private Map<String, ?> configs;
    private String topic;
    private boolean autoFlush;
    private volatile KafkaProducer<byte[], byte[]> producer;

    @Override
    public boolean addOriginalConfigs() {
        return true;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        this.configs = configs;
        this.topic = (String)configs.get(TOPIC);
        Object autoFlushConfig = configs.get(AUTO_FLUSH);
        if (autoFlushConfig != null) {
            this.autoFlush = Boolean.parseBoolean(autoFlushConfig.toString());
        }
        this.producer = (KafkaProducer)configs.get(PRODUCER);
    }

    @Override
    public String type() {
        return TYPE;
    }

    public String topic() {
        return this.topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KafkaProducer<byte[], byte[]> producer() {
        if (this.producer == null) {
            Map<String, Object> producerConfigs = DlqAction.baseProducerConfigs();
            producerConfigs.putAll(this.configs);
            DlqAction dlqAction = this;
            synchronized (dlqAction) {
                if (this.producer == null) {
                    this.producer = new KafkaProducer(producerConfigs);
                }
            }
        }
        return this.producer;
    }

    @Override
    public void run(RuleContext ctx, Object message, RuleException ex) throws RuleException {
        String topic = this.topic();
        if (topic == null || topic.isEmpty()) {
            topic = ctx.getParameter(DLQ_TOPIC);
        }
        if (topic == null || topic.isEmpty()) {
            throw new SerializationException("Could not send to DLQ as no topic is configured");
        }
        String dlqTopic = topic;
        try {
            byte[] keyBytes = this.convertToBytes(ctx, ctx.originalKey());
            byte[] valueBytes = this.convertToBytes(ctx, ctx.originalValue());
            ProducerRecord producerRecord = new ProducerRecord(dlqTopic, null, (Object)keyBytes, (Object)valueBytes, (Iterable)ctx.headers());
            this.populateHeaders(ctx, (ProducerRecord<byte[], byte[]>)producerRecord, ex);
            this.producer().send(producerRecord, (metadata, exception) -> {
                if (exception != null) {
                    log.error("Could not produce message to DLQ topic {}", (Object)dlqTopic, (Object)exception);
                } else {
                    log.info("Sent message to DLQ topic {}", (Object)dlqTopic);
                }
            });
            if (this.autoFlush) {
                this.producer.flush();
            }
        }
        catch (IOException e) {
            log.error("Could not produce message to DLQ topic {}", (Object)dlqTopic, (Object)e);
        }
        String msg = "Rule failed: " + ctx.rule().getName();
        throw ex != null ? new SerializationException(msg, (Throwable)ex) : new SerializationException(msg);
    }

    private byte[] convertToBytes(RuleContext ctx, Object message) throws IOException {
        if (message == null) {
            return null;
        }
        if (message instanceof byte[]) {
            return (byte[])message;
        }
        if (message instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)message;
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return bytes;
        }
        if (message instanceof Bytes) {
            return ((Bytes)message).get();
        }
        if (message instanceof String || message instanceof UUID) {
            return message.toString().getBytes(StandardCharsets.UTF_8);
        }
        if (message instanceof Long) {
            return LONG_SERIALIZER.serialize(ctx.topic(), (Long)message);
        }
        if (message instanceof Integer) {
            return INT_SERIALIZER.serialize(ctx.topic(), (Integer)message);
        }
        if (message instanceof Short) {
            return SHORT_SERIALIZER.serialize(ctx.topic(), (Short)message);
        }
        if (message instanceof Double) {
            return DOUBLE_SERIALIZER.serialize(ctx.topic(), (Double)message);
        }
        if (message instanceof Float) {
            return FLOAT_SERIALIZER.serialize(ctx.topic(), (Float)message);
        }
        return this.convertToJsonBytes(ctx, message);
    }

    private byte[] convertToJsonBytes(RuleContext ctx, Object message) throws IOException {
        JsonNode json = ctx.target().toJson(message);
        return JacksonMapper.INSTANCE.writeValueAsBytes((Object)json);
    }

    private void populateHeaders(RuleContext ctx, ProducerRecord<byte[], byte[]> producerRecord, RuleException ex) {
        Headers headers = producerRecord.headers();
        headers.add(RULE_NAME, this.toBytes(ctx.rule().getName()));
        headers.add(RULE_MODE, this.toBytes(ctx.ruleMode().name()));
        headers.add(RULE_SUBJECT, this.toBytes(ctx.subject()));
        headers.add(RULE_TOPIC, this.toBytes(ctx.topic()));
        if (ex != null) {
            headers.add(RULE_EXCEPTION, this.toBytes(ex.getMessage()));
        }
    }

    private byte[] toBytes(String value) {
        if (value != null) {
            return value.getBytes(StandardCharsets.UTF_8);
        }
        return null;
    }

    static Map<String, Object> baseProducerConfigs() {
        HashMap<String, Object> producerProps = new HashMap<String, Object>();
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("max.block.ms", Long.toString(Long.MAX_VALUE));
        producerProps.put("enable.idempotence", "false");
        producerProps.put("acks", "all");
        producerProps.put("max.in.flight.requests.per.connection", "1");
        producerProps.put("delivery.timeout.ms", Integer.toString(Integer.MAX_VALUE));
        return producerProps;
    }

    @Override
    public void close() {
        if (this.producer != null) {
            this.producer.close();
        }
    }
}

