/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumMap;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.PluginMap;
import org.freehep.application.studio.pluginmanager.PluginManager;

public class PluginPreferences {
    protected PluginManager manager;
    protected String keyPrefix = "PluginManager.";
    protected String urlKey = "URL";
    protected String snapshotsKey = "snapshots";
    protected String checkAtStartKey = "checkForPluginsAtStart";
    protected String orphanActionKey = "orphanAction";
    protected String orphanPromptKey = "orphanPrompt";
    protected String notifyPluginUpdatesKey = "notifyPluginUpdates";
    protected String downloadMissingKey = "downloadMissing";
    protected URL urlDefault;
    protected boolean snapshotsDefault = false;
    protected boolean checkAtStartDefault = true;
    protected PluginMap.Orphan orphanActionDefault = PluginMap.Orphan.Ignore;
    protected boolean orphanPromptDefault = true;
    protected boolean notifyPluginUpdatesDefault = true;
    protected boolean downloadMissingDefault = true;
    protected URL url;
    protected boolean snapshots;
    protected boolean checkAtStart;
    protected PluginMap.Orphan orphanAction;
    protected boolean orphanPrompt;
    protected boolean notifyPluginUpdates;
    protected boolean downloadMissing;
    protected final int HSPACE = 10;
    protected final int VSPACE = 5;

    public PluginPreferences(PluginManager manager, boolean restore) {
        this.manager = manager;
        if (restore) {
            this.restore();
        }
    }

    protected final void restore() {
        Properties prop = this.manager.getApplication().getUserProperties();
        this.url = PropertyUtilities.getURL(prop, this.keyPrefix + this.urlKey, this.urlDefault);
        this.snapshots = PropertyUtilities.getBoolean(prop, this.keyPrefix + this.snapshotsKey, this.snapshotsDefault);
        this.checkAtStart = PropertyUtilities.getBoolean(prop, this.keyPrefix + this.checkAtStartKey, this.checkAtStartDefault);
        try {
            this.orphanAction = PluginMap.Orphan.valueOf(PropertyUtilities.getString(prop, this.keyPrefix + this.orphanActionKey, this.orphanActionDefault.name()));
        }
        catch (IllegalArgumentException x) {
            this.orphanAction = this.orphanActionDefault;
        }
        this.orphanPrompt = PropertyUtilities.getBoolean(prop, this.keyPrefix + this.orphanPromptKey, this.orphanPromptDefault);
        this.notifyPluginUpdates = PropertyUtilities.getBoolean(prop, this.keyPrefix + this.notifyPluginUpdatesKey, this.notifyPluginUpdatesDefault);
        this.downloadMissing = PropertyUtilities.getBoolean(prop, this.keyPrefix + this.downloadMissingKey, this.downloadMissingDefault);
    }

    protected void save() {
        Properties prop = this.manager.getApplication().getUserProperties();
        PropertyUtilities.setURL(prop, this.keyPrefix + this.urlKey, this.url);
        PropertyUtilities.setBoolean(prop, this.keyPrefix + this.snapshotsKey, this.snapshots == this.snapshotsDefault ? null : Boolean.valueOf(this.snapshots));
        PropertyUtilities.setBoolean(prop, this.keyPrefix + this.checkAtStartKey, this.checkAtStart == this.checkAtStartDefault ? null : Boolean.valueOf(this.checkAtStart));
        PropertyUtilities.setString(prop, this.keyPrefix + this.orphanActionKey, this.orphanAction == this.orphanActionDefault ? null : this.orphanAction.name());
        PropertyUtilities.setBoolean(prop, this.keyPrefix + this.orphanPromptKey, this.orphanPrompt == this.orphanPromptDefault ? null : Boolean.valueOf(this.orphanPrompt));
        PropertyUtilities.setBoolean(prop, this.keyPrefix + this.notifyPluginUpdatesKey, this.notifyPluginUpdates == this.notifyPluginUpdatesDefault ? null : Boolean.valueOf(this.notifyPluginUpdates));
        PropertyUtilities.setBoolean(prop, this.keyPrefix + this.downloadMissingKey, this.downloadMissing == this.downloadMissingDefault ? null : Boolean.valueOf(this.downloadMissing));
    }

    public URL getUrl() {
        if (this.snapshots && this.urlDefault.equals(this.url)) {
            try {
                return new URL(this.urlDefault.toString() + "?snapshots=true");
            }
            catch (MalformedURLException x) {
                return this.url;
            }
        }
        return this.url;
    }

    public boolean isSnapshots() {
        return this.snapshots;
    }

    public boolean isCheckAtStart() {
        return this.checkAtStart;
    }

    public PluginMap.Orphan getOrphanAction() {
        return this.orphanAction;
    }

    public boolean isOrphanPrompt() {
        return this.orphanPrompt;
    }

    public boolean isNotifyPluginUpdates() {
        return this.isCheckAtStart();
    }

    public boolean isDownloadMissing() {
        return this.downloadMissing;
    }

    public void setUrl(URL url, boolean save) {
        this.url = url;
        if (save) {
            PropertyUtilities.setURL(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.urlKey, url);
        }
    }

    public void setSnapshots(boolean snapshots, boolean save) {
        this.snapshots = snapshots;
        if (save) {
            PropertyUtilities.setBoolean(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.snapshotsKey, snapshots == this.snapshotsDefault ? null : Boolean.valueOf(snapshots));
        }
    }

    public void setCheckAtStart(boolean checkAtStart, boolean save) {
        this.checkAtStart = checkAtStart;
        if (save) {
            PropertyUtilities.setBoolean(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.checkAtStartKey, checkAtStart == this.checkAtStartDefault ? null : Boolean.valueOf(checkAtStart));
        }
    }

    public void setOrphanAction(PluginMap.Orphan orphanAction, boolean save) {
        this.orphanAction = orphanAction;
        if (save) {
            PropertyUtilities.setString(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.orphanActionKey, orphanAction == this.orphanActionDefault ? null : orphanAction.name());
        }
    }

    public void setOrphanPrompt(boolean orphanPrompt, boolean save) {
        this.orphanPrompt = orphanPrompt;
        if (save) {
            PropertyUtilities.setBoolean(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.orphanPromptKey, orphanPrompt == this.orphanPromptDefault ? null : Boolean.valueOf(orphanPrompt));
        }
    }

    public void setNotifyPluginUpdates(boolean notifyPluginUpdates, boolean save) {
        this.notifyPluginUpdates = notifyPluginUpdates;
        if (save) {
            PropertyUtilities.setBoolean(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.notifyPluginUpdatesKey, notifyPluginUpdates == this.notifyPluginUpdatesDefault ? null : Boolean.valueOf(notifyPluginUpdates));
        }
    }

    public void setDownloadMissing(boolean downloadMissing, boolean save) {
        this.downloadMissing = downloadMissing;
        if (save) {
            PropertyUtilities.setBoolean(this.manager.getApplication().getUserProperties(), this.keyPrefix + this.downloadMissingKey, downloadMissing == this.downloadMissingDefault ? null : Boolean.valueOf(downloadMissing));
        }
    }

    protected String getDescription(PluginMap.Orphan action) {
        if (action == null) {
            return "<html>Prompt me every time unclaimed libraries are detected.</html>";
        }
        switch (action) {
            case Remove: {
                return "<html>Recommended. Unclaimed library files will be deleted.</html>";
            }
            case Ignore: {
                return "<html>Unclaimed library files will not be deleted but classes <br>they contain will remain inaccessible to the application. <br>It will be possible to load or delete these libraries later through <br>the plugin manager.</html>";
            }
            case Load: {
                return "<html>Libraries found in the extensions directories will be added to <br>the classpath whether or not they are claimed by any installed plugins. <br>This can be convenient when developing new plugins, <br>but it may affect application performance and result in unpredictable behavior, <br>depending on the content of the loaded libraries.</html>";
            }
        }
        return "<html>Prompt me every time unclaimed libraries are detected.</html>";
    }

    public JComponent getPreferencesPanel() {
        return new GUI();
    }

    public boolean apply(JComponent gui) {
        try {
            URL oldURL = this.url;
            boolean oldSnap = this.snapshots;
            boolean out = ((GUI)gui).get();
            if (out && this.url != null && (!this.url.equals(oldURL) || oldSnap != this.snapshots)) {
                this.manager.startPluginListDownload();
            }
            this.save();
            return out;
        }
        catch (ClassCastException x) {
            return false;
        }
    }

    public void showUnclaimedLibrariesWarning() {
        Box panel = Box.createVerticalBox();
        panel.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>Some of the libraries found in application extension directories are not required by any installed plugins.<p>");
        sb.append("Based on your current settings, unclaimed libraries ");
        switch (this.orphanAction) {
            case Remove: {
                sb.append("have been deleted");
                break;
            }
            case Ignore: {
                sb.append("are ignored. You can inspect, load, or delete these libraries through the Plugin Manager");
                break;
            }
            case Load: {
                sb.append("have been loaded on the application classpath");
            }
        }
        sb.append(".<p>");
        sb.append("Settings that affect treatment of unclaimed libraries can be modified through the application preferences dialog.</body></html>");
        JEditorPane textPane = new JEditorPane();
        textPane.setOpaque(false);
        textPane.setContentType("text/html");
        textPane.setText(sb.toString());
        textPane.setPreferredSize(new Dimension(520, 200));
        textPane.setEditable(false);
        textPane.setAlignmentX(0.0f);
        panel.add(textPane);
        panel.add(Box.createRigidArea(new Dimension(0, 10)));
        final JCheckBox checkBox = new JCheckBox("Don't show this again");
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginPreferences.this.setOrphanPrompt(!checkBox.isSelected(), true);
            }
        });
        checkBox.setAlignmentX(0.0f);
        panel.add(checkBox);
        panel.add(Box.createVerticalGlue());
        JOptionPane.showMessageDialog(this.manager.getApplication(), new JScrollPane(panel), "Unclaimed Libraries Found", -1);
    }

    protected class GUI
    extends JPanel {
        protected JCheckBox _snapshotsBox;
        protected JCheckBox _checkAtStartBox;
        protected JCheckBox _downloadMissingBox;
        protected JTextField _urlField;
        protected JButton _urlButton;
        protected ButtonGroup _orphanGroup;
        protected EnumMap<PluginMap.Orphan, JRadioButton> _orphanButtons;
        protected JCheckBox _promptBox;
        protected boolean _checkAtStartBoxState;

        GUI() {
            this.setLayout(new BoxLayout(this, 1));
            Box panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Plugin catalog"));
            panel.setAlignmentX(0.0f);
            Box row = Box.createHorizontalBox();
            row.setAlignmentX(0.0f);
            row.add(new JLabel("URL: "));
            this._urlField = new JTextField(8);
            this._urlField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this._urlField.getPreferredSize().height));
            this._urlField.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent fe) {
                    String text = GUI.this._urlField.getText().trim();
                    if (text.isEmpty()) {
                        GUI.this._checkAtStartBox.setEnabled(false);
                        GUI.this._checkAtStartBox.setSelected(false);
                        GUI.this._snapshotsBox.setEnabled(false);
                    } else {
                        GUI.this._checkAtStartBox.setEnabled(true);
                        GUI.this._checkAtStartBox.setSelected(GUI.this._checkAtStartBoxState);
                        GUI.this._snapshotsBox.setEnabled(true);
                    }
                }
            });
            row.add(this._urlField);
            row.add(Box.createRigidArea(new Dimension(10, 0)));
            this._urlButton = new JButton("Default");
            this._urlButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    GUI.this._urlField.setText(PluginPreferences.this.urlDefault == null ? "" : PluginPreferences.this.urlDefault.toString());
                }
            });
            row.add(this._urlButton);
            row.add(Box.createHorizontalGlue());
            panel.add(row);
            this._snapshotsBox = new JCheckBox("Include snapshot versions of plugins");
            this._snapshotsBox.setAlignmentX(0.0f);
            this._snapshotsBox.setToolTipText("Uncheck to ignore snapshots.");
            panel.add(this._snapshotsBox);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
            this._checkAtStartBox = new JCheckBox("Check for updated plugins at startup");
            this._checkAtStartBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GUI.this._checkAtStartBoxState = GUI.this._checkAtStartBox.isSelected();
                }
            });
            this._checkAtStartBox.setAlignmentX(0.0f);
            this._checkAtStartBox.setToolTipText("<html>Check to download the list of available plugins at startup.<br> The list will be used to offer updates and download missing plugin dependencies.</html>");
            panel.add(this._checkAtStartBox);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
            this._downloadMissingBox = new JCheckBox("Download missing libraries");
            this._downloadMissingBox.setAlignmentX(0.0f);
            this._downloadMissingBox.setToolTipText("<html>Check to attempt downloading any missing libraries referenced by installed plugins when the application starts.</html>");
            panel.add(this._downloadMissingBox);
            panel.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(panel);
            panel = Box.createVerticalBox();
            panel.setBorder(BorderFactory.createTitledBorder("Handling of unclaimed libraries"));
            panel.setAlignmentX(0.0f);
            panel.setMaximumSize(new Dimension(Integer.MAX_VALUE, panel.getMaximumSize().height));
            panel.setToolTipText("<html>Choose how to handle libraries found in the application extensions<br> directories if they are not referenced by any installed plugins.</html>");
            this._orphanGroup = new ButtonGroup();
            this._orphanButtons = new EnumMap(PluginMap.Orphan.class);
            JRadioButton radio = new JRadioButton("Remove  (recommended)");
            radio.setActionCommand(PluginMap.Orphan.Remove.name());
            radio.setToolTipText(PluginPreferences.this.getDescription(PluginMap.Orphan.Remove));
            this._orphanButtons.put(PluginMap.Orphan.Remove, radio);
            this._orphanGroup.add(radio);
            panel.add(radio);
            radio = new JRadioButton(PluginMap.Orphan.Ignore.name());
            radio.setActionCommand(PluginMap.Orphan.Ignore.name());
            radio.setToolTipText(PluginPreferences.this.getDescription(PluginMap.Orphan.Ignore));
            this._orphanButtons.put(PluginMap.Orphan.Ignore, radio);
            this._orphanGroup.add(radio);
            panel.add(radio);
            radio = new JRadioButton("Load  (dangerous, use at your own risk) ");
            radio.setActionCommand(PluginMap.Orphan.Load.name());
            radio.setToolTipText(PluginPreferences.this.getDescription(PluginMap.Orphan.Load));
            this._orphanButtons.put(PluginMap.Orphan.Load, radio);
            this._orphanGroup.add(radio);
            panel.add(radio);
            this._promptBox = new JCheckBox("Warn when unclaimed libraries are found");
            this._promptBox.setToolTipText(PluginPreferences.this.getDescription(null));
            panel.add(this._promptBox);
            this.add(panel);
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(Box.createVerticalGlue());
            this.set();
        }

        final boolean get() {
            PluginPreferences.this.snapshots = this._snapshotsBox.isSelected();
            String urlText = this._urlField.getText().trim();
            if (urlText.isEmpty()) {
                PluginPreferences.this.url = null;
            } else {
                try {
                    PluginPreferences.this.url = new URL(urlText);
                }
                catch (MalformedURLException x) {
                    if (PluginPreferences.this.url == null) {
                        this._urlField.setText("");
                        this._snapshotsBox.setEnabled(false);
                        this._checkAtStartBox.setSelected(false);
                        this._checkAtStartBox.setEnabled(false);
                    } else {
                        this._urlField.setText(PluginPreferences.this.url.toString());
                        this._snapshotsBox.setEnabled(true);
                        this._checkAtStartBox.setSelected(this._checkAtStartBoxState);
                        this._checkAtStartBox.setEnabled(true);
                    }
                    return false;
                }
            }
            PluginPreferences.this.checkAtStart = this._checkAtStartBoxState;
            PluginPreferences.this.downloadMissing = this._downloadMissingBox.isSelected();
            try {
                PluginPreferences.this.orphanAction = PluginMap.Orphan.valueOf(this._orphanGroup.getSelection().getActionCommand());
            }
            catch (NullPointerException x) {
                PluginPreferences.this.orphanAction = PluginPreferences.this.orphanActionDefault;
            }
            PluginPreferences.this.orphanPrompt = this._promptBox.isSelected();
            return true;
        }

        final void set() {
            this._snapshotsBox.setSelected(PluginPreferences.this.snapshots);
            this._checkAtStartBoxState = PluginPreferences.this.checkAtStart;
            this._downloadMissingBox.setSelected(PluginPreferences.this.downloadMissing);
            if (PluginPreferences.this.url == null) {
                this._snapshotsBox.setEnabled(false);
                this._checkAtStartBox.setSelected(false);
                this._checkAtStartBox.setEnabled(false);
                this._urlField.setText("");
            } else {
                this._snapshotsBox.setEnabled(true);
                this._checkAtStartBox.setSelected(PluginPreferences.this.checkAtStart);
                this._checkAtStartBox.setEnabled(true);
                this._urlField.setText(PluginPreferences.this.url.toString());
            }
            this._orphanButtons.get((Object)PluginPreferences.this.orphanAction).setSelected(true);
            this._promptBox.setSelected(PluginPreferences.this.orphanPrompt);
        }
    }
}

