/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.IntBuffer;
import org.lsst.ccs.daq.ims.channel.ReadableIntChannel;

public class IntBufferReader
implements ReadableIntChannel {
    private IntBuffer input;

    IntBufferReader(IntBuffer buffer) {
        this.input = buffer;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.input.get();
        }
        catch (BufferUnderflowException x) {
            throw new EOFException();
        }
    }

    @Override
    public int read(IntBuffer buffer) throws IOException {
        int remaining = this.input.remaining();
        if (remaining == 0) {
            return -1;
        }
        if (remaining > buffer.remaining()) {
            int oldLimit = this.input.limit();
            this.input.limit(this.input.position() + buffer.remaining());
            buffer.put(this.input);
            this.input.limit(oldLimit);
        } else {
            buffer.put(this.input);
        }
        return remaining - this.input.remaining();
    }

    @Override
    public boolean isOpen() {
        return this.input != null;
    }

    @Override
    public void close() throws IOException {
        this.input = null;
    }
}

