/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.logredactor.internal;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;

public class MetricsTagBuilder {
    private static final String POLICY_LOCATION = "policy_location";
    private static final String POLICY_HASH = "policy_hash";
    private static final String ERROR_CODE = "error_code";
    private static final String RULE = "rule";
    private Map<String, String> map = new HashMap<String, String>();

    public MetricsTagBuilder policyLocation(String policyLocation) {
        this.map.put(POLICY_LOCATION, policyLocation == null ? "" : policyLocation);
        return this;
    }

    public MetricsTagBuilder policyContent(String content) {
        this.map.put(POLICY_HASH, content == null || content.isEmpty() ? "" : MetricsTagBuilder.hashString(content));
        return this;
    }

    public MetricsTagBuilder policyHash(String hash) {
        this.map.put(POLICY_HASH, hash == null ? "" : hash);
        return this;
    }

    public MetricsTagBuilder errorCode(ErrorCode errorCode) {
        this.map.put(ERROR_CODE, errorCode.name().toLowerCase());
        return this;
    }

    public MetricsTagBuilder rule(String ruleId) {
        this.map.put(RULE, ruleId == null ? "" : ruleId);
        return this;
    }

    public Map<String, String> build() {
        return this.map;
    }

    private static String hashString(String input) {
        byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
        try {
            byte[] hashed = MessageDigest.getInstance("SHA-256").digest(bytes);
            StringBuilder sb = new StringBuilder(hashed.length * 2);
            for (byte b : hashed) {
                sb.append(String.format("%02x", b));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            CRC32 checksum = new CRC32();
            checksum.update(bytes, 0, bytes.length);
            return Long.toHexString(checksum.getValue());
        }
    }

    public static enum ErrorCode {
        READ_ERROR,
        PARSE_ERROR;

    }
}

