/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.web;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.astrogrid.samp.httpd.HttpServer;
import org.astrogrid.samp.web.ClientAuthorizer;

public class ClientAuthorizers {
    public static final ClientAuthorizer FALSE = ClientAuthorizers.createLoggingClientAuthorizer(ClientAuthorizers.createFixedClientAuthorizer(false), Level.INFO, Level.INFO);
    public static final ClientAuthorizer TRUE = ClientAuthorizers.createLoggingClientAuthorizer(ClientAuthorizers.createFixedClientAuthorizer(true), Level.WARNING, Level.WARNING);
    private static ClientAuthorizer swingAuth_;
    private static final Logger logger_;

    private ClientAuthorizers() {
    }

    public static ClientAuthorizer createFixedClientAuthorizer(final boolean policy) {
        return new ClientAuthorizer(){

            public boolean authorize(HttpServer.Request request, String appName) {
                return policy;
            }
        };
    }

    public static ClientAuthorizer createLoggingClientAuthorizer(final ClientAuthorizer auth, final Level acceptLevel, final Level refuseLevel) {
        return new ClientAuthorizer(){

            public synchronized boolean authorize(HttpServer.Request request, String appName) {
                boolean accept = auth.authorize(request, appName);
                this.log(accept, "\"" + appName + "\"");
                return accept;
            }

            private void log(boolean accept, String appName) {
                if (accept) {
                    logger_.log(acceptLevel, "Accepted registration for client " + appName);
                } else {
                    logger_.log(refuseLevel, "Rejected registration for client " + appName);
                }
            }
        };
    }

    static {
        logger_ = Logger.getLogger(ClientAuthorizers.class.getName());
    }
}

