/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.timeselection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Studio;
import org.lsst.ccs.gconsole.plugins.trending.timeselection.TimeWindow;

public class PresetList
extends AbstractTableModel {
    private final String KEY = "org.lsst.trending.timewindows";
    private final Studio app;
    private ArrayList<TimeWindow> data;

    public PresetList(Studio application) {
        this.app = application;
        this.restore();
    }

    public List<TimeWindow> getRecent(int maxSize) {
        List<TimeWindow> out = new ArrayList<TimeWindow>(this.data);
        Collections.sort(out, TimeWindow.compareByTime());
        if (maxSize < out.size()) {
            out = out.subList(0, maxSize);
        }
        Collections.sort(out, TimeWindow.compareByName());
        return out;
    }

    public TimeWindow get(int index) {
        return this.data.get(index);
    }

    public int indexOf(TimeWindow timeWindow) {
        return this.data.indexOf(timeWindow);
    }

    public TimeWindow get(String name) {
        for (TimeWindow tw : this.data) {
            if (!name.equals(tw.getName())) continue;
            return tw;
        }
        return null;
    }

    public TimeWindow insert(TimeWindow timeWindow) {
        if (timeWindow.isReplaceableBy(TimeWindow.LAST_HOUR)) {
            return TimeWindow.LAST_HOUR;
        }
        if (timeWindow.isReplaceableBy(TimeWindow.LAST_6_HOURS)) {
            return TimeWindow.LAST_6_HOURS;
        }
        if (timeWindow.isReplaceableBy(TimeWindow.LAST_24_HOURS)) {
            return TimeWindow.LAST_24_HOURS;
        }
        String name = timeWindow.getName();
        if (name.isEmpty()) {
            for (TimeWindow tw : this.data) {
                if (!timeWindow.isReplaceableBy(tw)) continue;
                return tw.touch();
            }
            return timeWindow;
        }
        for (int i = 0; i < this.data.size(); ++i) {
            TimeWindow e = this.data.get(i);
            int out = name.compareTo(e.getName());
            if (out == 0) {
                if (timeWindow.isReplaceableBy(e)) {
                    return e.touch();
                }
                this.data.set(i, timeWindow);
                if (e.isPersistent() || timeWindow.isPersistent()) {
                    this.save();
                }
                this.fireTableRowsUpdated(i, i);
                return timeWindow;
            }
            if (out >= 0) continue;
            this.data.add(i, timeWindow);
            if (timeWindow.isPersistent()) {
                this.save();
            }
            this.fireTableRowsInserted(i, i);
            return timeWindow;
        }
        int row = this.data.size();
        this.data.add(timeWindow);
        if (timeWindow.isPersistent()) {
            this.save();
        }
        timeWindow.touch();
        this.fireTableRowsInserted(row, row);
        return timeWindow;
    }

    public void delete(TimeWindow timeWindow) {
        if (this.data.remove(timeWindow) && timeWindow.isPersistent()) {
            this.save();
        }
        this.fireTableStructureChanged();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex).getName();
            }
            case 1: {
                return this.data.get(rowIndex).getLowerEdgeString();
            }
            case 2: {
                return this.data.get(rowIndex).getUpperEdgeString();
            }
            case 3: {
                return this.data.get(rowIndex).isPersistent();
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Start";
            }
            case 2: {
                return "End";
            }
            case 3: {
                return "Saved";
            }
        }
        throw new IllegalArgumentException();
    }

    private void save() {
        Properties prop = this.app.getUserProperties();
        if (prop != null) {
            int n = this.data.size();
            ArrayList<String> savedData = null;
            if (n != 0) {
                savedData = new ArrayList<String>(n);
                for (int i = 0; i < n; ++i) {
                    TimeWindow tw = this.data.get(i);
                    if (tw.isPersistent()) {
                        savedData.add(tw.toNamedCompressedString());
                    }
                    savedData.add(tw.toNamedCompressedString());
                }
            }
            PropertyUtilities.setStringCollection((Properties)prop, (String)"org.lsst.trending.timewindows", savedData);
        }
    }

    private void restore() {
        Properties prop = this.app.getUserProperties();
        if (prop == null) {
            this.data = new ArrayList(0);
        } else {
            String[] savedData = PropertyUtilities.getStringArray((Properties)prop, (String)"org.lsst.trending.timewindows", (String[])new String[0]);
            this.data = new ArrayList(savedData.length);
            TreeMap<String, TimeWindow> windows = new TreeMap<String, TimeWindow>();
            for (String s : savedData) {
                try {
                    TimeWindow tw = TimeWindow.parseCompressedString(s);
                    windows.put(tw.getName(), tw);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            windows.remove("");
            this.data = new ArrayList(windows.values());
        }
    }
}

