/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.sal.camera.event;

import java.util.Arrays;
import org.lsst.sal.camera.CameraEvent;

public class AvailableFiltersEvent
extends CameraEvent {
    private final String filterNames;
    private final String filterTypes;
    private final double maxChangeAngle;
    private final double maxFastChangeAngle;
    private final double[] maxSlowChangeTime;
    private final double[] maxFastChangeTime;

    public AvailableFiltersEvent(String filterNames, String filterTypes, double maxChangeAngle, double maxFastChangeAngle, double[] maxSlowChangeTime, double[] maxFastChangeTime) {
        this.filterNames = filterNames;
        this.filterTypes = filterTypes;
        this.maxChangeAngle = maxChangeAngle;
        this.maxFastChangeAngle = maxFastChangeAngle;
        this.maxSlowChangeTime = maxSlowChangeTime;
        this.maxFastChangeTime = maxFastChangeTime;
    }

    public String getFilterNames() {
        return this.filterNames;
    }

    public String getFilterTypes() {
        return this.filterTypes;
    }

    public double getMaxChangeAngle() {
        return this.maxChangeAngle;
    }

    public double getMaxFastChangeAngle() {
        return this.maxFastChangeAngle;
    }

    public double[] getMaxSlowChangeTime() {
        return this.maxSlowChangeTime;
    }

    public double[] getMaxFastChangeTime() {
        return this.maxFastChangeTime;
    }

    public String toString() {
        return "AvailableFiltersEvent{filterNames=" + this.filterNames + ", filterTypes=" + this.filterTypes + ", maxChangeAngle=" + this.maxChangeAngle + ", maxFastChangeAngle=" + this.maxFastChangeAngle + ", maxSlowChangeTime=" + Arrays.toString(this.maxSlowChangeTime) + ", maxFastChangeTime=" + Arrays.toString(this.maxFastChangeTime) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String filterNames;
        private String filterTypes;
        private double maxChangeAngle;
        private double maxFastChangeAngle;
        private double[] maxSlowChangeTime;
        private double[] maxFastChangeTime;

        private Builder() {
        }

        public Builder filterNames(String filterNames) {
            this.filterNames = filterNames;
            return this;
        }

        public Builder filterTypes(String filterTypes) {
            this.filterTypes = filterTypes;
            return this;
        }

        public Builder maxChangeAngle(double maxChangeAngle) {
            this.maxChangeAngle = maxChangeAngle;
            return this;
        }

        public Builder maxFastChangeAngle(double maxFastChangeAngle) {
            this.maxFastChangeAngle = maxFastChangeAngle;
            return this;
        }

        public Builder maxSlowChangeTime(double[] maxSlowChangeTime) {
            this.maxSlowChangeTime = maxSlowChangeTime;
            return this;
        }

        public Builder maxFastChangeTime(double[] maxFastChangeTime) {
            this.maxFastChangeTime = maxFastChangeTime;
            return this;
        }

        public AvailableFiltersEvent build() {
            return new AvailableFiltersEvent(this.filterNames, this.filterTypes, this.maxChangeAngle, this.maxFastChangeAngle, this.maxSlowChangeTime, this.maxFastChangeTime);
        }
    }
}

