/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.common.ui.SystemStatusPanel;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.power.data.ATSPowerState;

public class ATSPowerControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    private static final String CMND_GET_STATE = "getFullState";
    private static final Map<Integer, String> chanNames = new HashMap<Integer, String>();
    private static final String SOLID_BAR = "\u2588\u2588\u2588\u2588";
    private final CommandSender sender;
    private final UiUtilities uiUtils;
    private SystemStatusPanel sysStatusPnl;
    private JButton btnPowerOn;
    private JButton btnPowerOff;
    private JButton btnDphiOn;
    private JButton btnDphiOff;
    private JButton btnBiasOn;
    private JButton btnBiasOff;
    private JButton btnOtmOn;
    private JButton btnOtmOff;
    private JButton btnFanOn;
    private JButton btnFanOff;
    private JButton btnAuxOn;
    private JButton btnAuxOff;
    private JRadioButton rbTempOn;
    private JRadioButton rbTempOff;
    private ButtonGroup bgTempCtrl;
    private TextFieldX tfDphiVal;
    private TextFieldX tfBiasVal;
    private TextFieldX tfTempLimit;
    private final JLabel[] lblChanStatus = new JLabel[7];
    private JLabel lblOtmStatus;
    private JLabel lblFanStatus;
    private JLabel lblAuxStatus;
    private JLabel lblTempChannel;
    private JLabel lblTempValue;
    private String tempChannel = "";
    private static final long serialVersionUID = 1L;

    public ATSPowerControlPanel(String agent) {
        this.sender = new CommandSender(agent, (CommandSender.ReplyHandler)this);
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((ATSPowerState)reply);
    }

    public void onCommandReject(String path, String command, Object[] args) {
        if (!command.equals(CMND_GET_STATE)) {
            this.sender.sendCommand(true, null, CMND_GET_STATE, new Object[0]);
        }
    }

    public void updatePanel(ATSPowerState rs) {
        SwingUtilities.invokeLater(new UpdatePowerStatus(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    private void initComponents() {
        this.btnPowerOn = this.newButton("On", UiConstants.GREEN, "powerOn");
        this.btnPowerOff = this.newButton("Off", UiConstants.RED, "powerOff");
        this.btnDphiOn = this.newButton("On", UiConstants.GREEN, "dphiOn");
        this.btnDphiOff = this.newButton("Off", UiConstants.RED, "dphiOff");
        this.btnBiasOn = this.newButton("On", UiConstants.GREEN, "hvBiasOn");
        this.btnBiasOff = this.newButton("Off", UiConstants.RED, "hvBiasOff");
        this.btnOtmOn = this.newButton("On", UiConstants.GREEN, "otmOn");
        this.btnOtmOff = this.newButton("Off", UiConstants.RED, "otmOff");
        this.btnFanOn = this.newButton("On", UiConstants.GREEN, "fanOn");
        this.btnFanOff = this.newButton("Off", UiConstants.RED, "fanOff");
        this.btnAuxOn = this.newButton("On", UiConstants.GREEN, "auxOn");
        this.btnAuxOff = this.newButton("Off", UiConstants.RED, "auxOff");
        this.tfDphiVal = this.uiUtils.newTextFieldX("00000.0", "setDphi", 2, true);
        this.tfBiasVal = this.uiUtils.newTextFieldX("00000.0", "setHvBias", 2, true);
        for (int cs = 0; cs < this.lblChanStatus.length; ++cs) {
            this.lblChanStatus[cs] = UiUtilities.newLabel((String)SOLID_BAR, (int)0);
        }
        this.lblOtmStatus = UiUtilities.newLabel((String)SOLID_BAR, (int)0);
        this.lblFanStatus = UiUtilities.newLabel((String)SOLID_BAR, (int)0);
        this.lblAuxStatus = UiUtilities.newLabel((String)SOLID_BAR, (int)0);
        this.rbTempOn = this.uiUtils.newRadioButton("On", "N");
        this.rbTempOff = this.uiUtils.newRadioButton("Off", "F");
        this.bgTempCtrl = new ButtonGroup();
        this.bgTempCtrl.add(this.rbTempOn);
        this.bgTempCtrl.add(this.rbTempOff);
        this.tfTempLimit = this.uiUtils.newTextFieldX("0000.0", "setTempLimit", 2, true);
        this.lblTempChannel = UiUtilities.newLabel((String)this.tempChannel, (int)0);
        this.lblTempValue = UiUtilities.newLabel((String)"99.99", (int)0);
        this.sysStatusPnl = new SystemStatusPanel(this.sender, "MonitorControl", true);
        JPanel pnlPowerControl = new JPanel();
        pnlPowerControl.setLayout(new GridBagLayout());
        GridBagConstraints gbp = new GridBagConstraints();
        gbp.insets = new Insets(4, 6, 4, 6);
        gbp.gridx = 0;
        gbp.gridy = 0;
        gbp.gridwidth = 2;
        pnlPowerControl.add((Component)UiUtilities.newLabel((String)"Seq. Power", (int)0), gbp);
        gbp.gridy = 1;
        gbp.gridwidth = 1;
        gbp.insets.right = 2;
        pnlPowerControl.add((Component)this.btnPowerOn, gbp);
        ++gbp.gridx;
        gbp.insets.left = 2;
        gbp.insets.right = 6;
        pnlPowerControl.add((Component)this.btnPowerOff, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        gbp.gridwidth = 2;
        gbp.insets.left = 6;
        pnlPowerControl.add((Component)UiUtilities.newLabel((String)"DPHI", (int)0), gbp);
        gbp.gridy = 1;
        gbp.gridwidth = 1;
        gbp.insets.right = 2;
        pnlPowerControl.add((Component)this.btnDphiOn, gbp);
        ++gbp.gridx;
        gbp.insets.left = 2;
        gbp.insets.right = 6;
        pnlPowerControl.add((Component)this.btnDphiOff, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        pnlPowerControl.add((Component)UiUtilities.newLabel((String)"DPHI Volts", (int)0), gbp);
        gbp.gridy = 1;
        pnlPowerControl.add((Component)this.tfDphiVal, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        gbp.gridwidth = 2;
        gbp.insets.left = 6;
        pnlPowerControl.add((Component)UiUtilities.newLabel((String)"HV Bias", (int)0), gbp);
        gbp.gridy = 1;
        gbp.gridwidth = 1;
        gbp.insets.right = 2;
        pnlPowerControl.add((Component)this.btnBiasOn, gbp);
        ++gbp.gridx;
        gbp.insets.left = 2;
        gbp.insets.right = 6;
        pnlPowerControl.add((Component)this.btnBiasOff, gbp);
        ++gbp.gridx;
        gbp.gridy = 0;
        gbp.insets.left = 6;
        pnlPowerControl.add((Component)UiUtilities.newLabel((String)"Bias Volts", (int)0), gbp);
        gbp.gridy = 1;
        pnlPowerControl.add((Component)this.tfBiasVal, gbp);
        JPanel pnlChanStatus = new JPanel();
        pnlChanStatus.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.insets = new Insets(2, 6, 2, 6);
        gbs.gridx = 0;
        for (int j = 0; j < this.lblChanStatus.length; ++j) {
            gbs.gridy = 0;
            pnlChanStatus.add((Component)UiUtilities.newLabel((String)chanNames.get(j), (int)0), gbs);
            gbs.gridy = 1;
            pnlChanStatus.add((Component)this.lblChanStatus[j], gbs);
            ++gbs.gridx;
        }
        JPanel pnlREBPower = UiUtilities.newBorderedPanel((String)"REB Power");
        pnlREBPower.setLayout(new GridBagLayout());
        GridBagConstraints gbrp = new GridBagConstraints();
        gbrp.insets = new Insets(0, 4, 4, 4);
        gbrp.gridx = 0;
        gbrp.gridy = 0;
        pnlREBPower.add((Component)pnlPowerControl, gbrp);
        ++gbrp.gridy;
        pnlREBPower.add((Component)pnlChanStatus, gbrp);
        JPanel pnlAncPower = UiUtilities.newBorderedPanel((String)"Ancillary Power");
        GridBagConstraints gbap = new GridBagConstraints();
        gbap.insets = new Insets(0, 6, 4, 6);
        gbap.gridx = 0;
        gbap.gridy = 0;
        gbap.gridwidth = 2;
        pnlAncPower.add((Component)UiUtilities.newLabel((String)"OTM", (int)0), gbap);
        ++gbap.gridy;
        gbap.gridwidth = 1;
        gbap.insets.right = 2;
        pnlAncPower.add((Component)this.btnOtmOn, gbap);
        ++gbap.gridx;
        gbap.insets.left = 2;
        gbap.insets.right = 6;
        pnlAncPower.add((Component)this.btnOtmOff, gbap);
        --gbap.gridx;
        ++gbap.gridy;
        gbap.gridwidth = 2;
        gbap.insets.left = 6;
        pnlAncPower.add((Component)this.lblOtmStatus, gbap);
        gbap.gridx = 2;
        gbap.gridy = 0;
        pnlAncPower.add((Component)UiUtilities.newLabel((String)"Fan", (int)0), gbap);
        ++gbap.gridy;
        gbap.gridwidth = 1;
        gbap.insets.right = 2;
        pnlAncPower.add((Component)this.btnFanOn, gbap);
        ++gbap.gridx;
        gbap.insets.left = 2;
        gbap.insets.right = 6;
        pnlAncPower.add((Component)this.btnFanOff, gbap);
        --gbap.gridx;
        ++gbap.gridy;
        gbap.gridwidth = 2;
        gbap.insets.left = 6;
        pnlAncPower.add((Component)this.lblFanStatus, gbap);
        gbap.gridx = 4;
        gbap.gridy = 0;
        gbap.gridwidth = 2;
        pnlAncPower.add((Component)UiUtilities.newLabel((String)"Aux", (int)0), gbap);
        ++gbap.gridy;
        gbap.gridwidth = 1;
        gbap.insets.right = 2;
        pnlAncPower.add((Component)this.btnAuxOn, gbap);
        ++gbap.gridx;
        gbap.insets.left = 2;
        gbap.insets.right = 6;
        pnlAncPower.add((Component)this.btnAuxOff, gbap);
        --gbap.gridx;
        ++gbap.gridy;
        gbap.gridwidth = 2;
        gbap.insets.left = 6;
        pnlAncPower.add((Component)this.lblAuxStatus, gbap);
        JPanel pnlTempCtrlLine = new JPanel();
        pnlTempCtrlLine.setLayout(new GridBagLayout());
        GridBagConstraints gbtcl = new GridBagConstraints();
        gbtcl.insets = new Insets(0, 6, 0, 0);
        gbtcl.gridx = 0;
        gbtcl.gridy = 0;
        pnlTempCtrlLine.add((Component)this.rbTempOn, gbtcl);
        ++gbtcl.gridx;
        gbtcl.insets.right = 6;
        pnlTempCtrlLine.add((Component)this.rbTempOff, gbtcl);
        ++gbtcl.gridx;
        gbtcl.insets.right = 0;
        pnlTempCtrlLine.add((Component)UiUtilities.newLabel((String)"Limit:", (int)0), gbtcl);
        ++gbtcl.gridx;
        pnlTempCtrlLine.add((Component)this.tfTempLimit, gbtcl);
        ++gbtcl.gridx;
        gbtcl.insets.right = 6;
        pnlTempCtrlLine.add((Component)UiUtilities.newLabel((String)"C", (int)0), gbtcl);
        JPanel pnlTempChannel = new JPanel();
        pnlTempChannel.setLayout(new GridBagLayout());
        GridBagConstraints gbtnl = new GridBagConstraints();
        gbtnl.insets = new Insets(0, 6, 0, 0);
        gbtnl.gridx = 0;
        gbtnl.gridy = 0;
        pnlTempChannel.add((Component)UiUtilities.newLabel((String)"Channel:", (int)0), gbtnl);
        ++gbtnl.gridx;
        this.lblTempChannel = UiUtilities.newLabel((String)this.tempChannel, (int)0);
        pnlTempChannel.add((Component)this.lblTempChannel, gbtnl);
        ++gbtnl.gridx;
        gbtnl.insets.left = 20;
        pnlTempChannel.add((Component)UiUtilities.newLabel((String)"Value:", (int)0), gbtnl);
        ++gbtnl.gridx;
        gbtnl.insets.left = 6;
        gbtnl.insets.right = 6;
        pnlTempChannel.add((Component)this.lblTempValue, gbtnl);
        JPanel pnlTempCtrl = UiUtilities.newBorderedPanel((String)"Temperature Control");
        pnlTempCtrl.setLayout(new GridBagLayout());
        GridBagConstraints gbtc = new GridBagConstraints();
        gbtc.insets = new Insets(4, 0, 4, 0);
        gbtc.gridx = 0;
        gbtc.gridy = 0;
        pnlTempCtrl.add((Component)pnlTempCtrlLine, gbtc);
        ++gbtc.gridy;
        gbtc.insets.top = 0;
        pnlTempCtrl.add((Component)pnlTempChannel, gbtc);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 0, 4, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.sysStatusPnl, gbc);
        ++gbc.gridy;
        this.add((Component)pnlREBPower, gbc);
        ++gbc.gridy;
        this.add((Component)pnlAncPower, gbc);
        ++gbc.gridy;
        this.add((Component)pnlTempCtrl, gbc);
    }

    private void updateTempChannel(String name) {
        if (name.equals(this.tempChannel)) {
            return;
        }
        this.tempChannel = name;
        this.lblTempChannel.setText(this.tempChannel);
        Dimension d = UiUtilities.getLabelSize((String)this.tempChannel);
        this.lblTempChannel.setMinimumSize(d);
        this.lblTempChannel.setPreferredSize(d);
    }

    private JButton newButton(String text, Color color, String command) {
        JButton btn = this.uiUtils.newButton(text, command, true);
        btn.setForeground(color);
        return btn;
    }

    public void handleButton(String command) {
        this.sender.sendCommand(null, command, new Object[0]);
    }

    public void handleTextFieldX(String name, Object value) {
        this.sender.sendCommand(null, name, new Object[]{(Double)value});
    }

    public void handleRadioButton(String name) {
        boolean on = name.charAt(0) == 'N';
        this.sender.sendCommand(null, "setTempFanControl", new Object[]{on});
    }

    static {
        chanNames.put(0, "Dig");
        chanNames.put(1, "Ana");
        chanNames.put(2, "ClkH");
        chanNames.put(3, "ClkL");
        chanNames.put(4, "OD");
        chanNames.put(5, "DPHI");
        chanNames.put(6, "HVbias");
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            ATSPowerControlPanel.this.sysStatusPnl.disablePanel();
            ATSPowerControlPanel.this.btnPowerOn.setEnabled(false);
            ATSPowerControlPanel.this.btnPowerOff.setEnabled(false);
            ATSPowerControlPanel.this.btnDphiOn.setEnabled(false);
            ATSPowerControlPanel.this.btnDphiOff.setEnabled(false);
            ATSPowerControlPanel.this.btnBiasOn.setEnabled(false);
            ATSPowerControlPanel.this.btnBiasOff.setEnabled(false);
            ATSPowerControlPanel.this.tfBiasVal.setDisabled();
            ATSPowerControlPanel.this.tfDphiVal.setDisabled();
            for (JLabel lbl : ATSPowerControlPanel.this.lblChanStatus) {
                lbl.setEnabled(false);
            }
            ATSPowerControlPanel.this.btnOtmOn.setEnabled(false);
            ATSPowerControlPanel.this.btnOtmOff.setEnabled(false);
            ATSPowerControlPanel.this.btnFanOn.setEnabled(false);
            ATSPowerControlPanel.this.btnFanOff.setEnabled(false);
            ATSPowerControlPanel.this.btnAuxOn.setEnabled(false);
            ATSPowerControlPanel.this.btnAuxOff.setEnabled(false);
            ATSPowerControlPanel.this.lblOtmStatus.setEnabled(false);
            ATSPowerControlPanel.this.lblFanStatus.setEnabled(false);
            ATSPowerControlPanel.this.lblAuxStatus.setEnabled(false);
            ATSPowerControlPanel.this.rbTempOn.setEnabled(false);
            ATSPowerControlPanel.this.rbTempOff.setEnabled(false);
            ATSPowerControlPanel.this.tfTempLimit.setDisabled();
            ATSPowerControlPanel.this.lblTempChannel.setEnabled(false);
            ATSPowerControlPanel.this.lblTempValue.setEnabled(false);
            ATSPowerControlPanel.this.repaint();
        }
    }

    class UpdatePowerStatus
    implements Runnable {
        private final ATSPowerState rs;

        UpdatePowerStatus(ATSPowerState rs) {
            this.rs = rs;
        }

        @Override
        public void run() {
            ATSPowerControlPanel.this.sysStatusPnl.updatePanel(this.rs.getTickMillis());
            ATSPowerControlPanel.this.btnPowerOn.setEnabled(true);
            ATSPowerControlPanel.this.btnPowerOff.setEnabled(true);
            ATSPowerControlPanel.this.btnDphiOn.setEnabled(true);
            ATSPowerControlPanel.this.btnDphiOff.setEnabled(true);
            ATSPowerControlPanel.this.btnBiasOn.setEnabled(true);
            ATSPowerControlPanel.this.btnBiasOff.setEnabled(true);
            ATSPowerControlPanel.this.tfBiasVal.update((Object)this.rs.getHvBias(), true);
            ATSPowerControlPanel.this.tfDphiVal.update((Object)this.rs.getDphi(), true);
            Boolean[] state = this.rs.getPowerState();
            for (int j = 0; j < ATSPowerControlPanel.this.lblChanStatus.length; ++j) {
                ATSPowerControlPanel.this.lblChanStatus[j].setForeground(state[j] == null ? UiConstants.BLUE : (state[j] != false ? UiConstants.GREEN : UiConstants.RED));
                ATSPowerControlPanel.this.lblChanStatus[j].setEnabled(true);
            }
            ATSPowerControlPanel.this.btnOtmOn.setEnabled(true);
            ATSPowerControlPanel.this.btnOtmOff.setEnabled(true);
            ATSPowerControlPanel.this.btnFanOn.setEnabled(true);
            ATSPowerControlPanel.this.btnFanOff.setEnabled(true);
            ATSPowerControlPanel.this.btnAuxOn.setEnabled(true);
            ATSPowerControlPanel.this.btnAuxOff.setEnabled(true);
            ATSPowerControlPanel.this.lblOtmStatus.setForeground(state[7] == null ? UiConstants.BLUE : (state[7] != false ? UiConstants.GREEN : UiConstants.RED));
            ATSPowerControlPanel.this.lblOtmStatus.setEnabled(true);
            ATSPowerControlPanel.this.lblFanStatus.setForeground(state[8] == null ? UiConstants.BLUE : (state[8] != false ? UiConstants.GREEN : UiConstants.RED));
            ATSPowerControlPanel.this.lblFanStatus.setEnabled(true);
            ATSPowerControlPanel.this.lblAuxStatus.setForeground(state[9] == null ? UiConstants.BLUE : (state[9] != false ? UiConstants.GREEN : UiConstants.RED));
            ATSPowerControlPanel.this.lblAuxStatus.setEnabled(true);
            ATSPowerControlPanel.this.rbTempOn.setEnabled(true);
            ATSPowerControlPanel.this.rbTempOff.setEnabled(true);
            JRadioButton selButton = this.rs.getTempFanControl() ? ATSPowerControlPanel.this.rbTempOn : ATSPowerControlPanel.this.rbTempOff;
            selButton.setSelected(true);
            ATSPowerControlPanel.this.tfTempLimit.update((Object)this.rs.getTempLimit(), true);
            ATSPowerControlPanel.this.updateTempChannel(this.rs.getTempChannel());
            ATSPowerControlPanel.this.lblTempValue.setText(String.format("%.1f", this.rs.getTempValue()));
            ATSPowerControlPanel.this.lblTempChannel.setEnabled(true);
            ATSPowerControlPanel.this.lblTempValue.setEnabled(true);
            ATSPowerControlPanel.this.repaint();
        }
    }
}

