/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.pluto;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.modbus.Modbus;

public class Pluto
extends Modbus {
    public static final int NUM_MODULES = 32;
    public static final int NUM_ADD_AREAS = 32;
    public static final int NUM_DTP_AREAS = 4;
    public static final int DATA_TYPE_GLOBAL = 0;
    public static final int DATA_TYPE_LOCAL_MEMORY = 1;
    public static final int DATA_TYPE_LOCAL_REGISTER = 2;
    public static final int DATA_TYPE_LOCAL_PARAMETER = 3;
    private static final short ZERO = 0;
    private static final short ONE = 1;
    private static final short TWO = 2;
    private static final short SA_DATA_TO_PLUTO = 1;
    private static final short SA_LOCAL_DATA_RQST = 2;
    private static final short SA_PASS_THRU_RQST = 3;
    private static final short SA_GATEWAY_CONFIG = 4;
    private static final short SA_DATA_FROM_PLUTO = 33;
    private static final short SA_LOCAL_DATA_RESP = 34;
    private static final short SA_PASS_THRU_RESP = 35;
    private static final short DFP_STATUS_ADDR = 1;
    private static final short DFP_DATA_ADDR = 3;
    private static final short DFP_ADDL_DATA_ADDR = 67;
    private static final short CFG_LENG_ADDR = 0;
    private static final short CFG_ENAB_DTP_ADDR = 1;
    private static final short CFG_DTP_TMO_ADDR = 2;
    private static final short CFG_EXP_NODES_ADDR = 3;
    private static final short CFG_ADDL_DATA_ADDR = 5;
    private static final short CFG_DTP_CYCLE_TIME = 37;
    private static final short CFG_DATA_LENG = 38;
    private static final short DTP_LENG_ADDR = 0;
    private static final short DTP_VALID_ADDR = 1;
    private static final short DTP_BITS_ADDR = 2;
    private static final short DTP_REGS_ADDR = 3;
    private static final short DTP_AREA_LENG = 3;
    private static final short LDRQ_LENG_ADDR = 0;
    private static final short LDRQ_PLUTO_ADDR = 1;
    private static final short LDRQ_TYPE_ADDR = 2;
    private static final short LDRQ_ADDR_ADDR = 3;
    private static final short LD_REQUEST_LENG = 4;
    private static final short LDRP_LENG_ADDR = 0;
    private static final short LDRP_PLUTO_ADDR = 1;
    private static final short LDRP_TYPE_ADDR = 2;
    private static final short LDRP_ADDR_ADDR = 3;
    private static final short LDRP_ERROR_ADDR = 4;
    private static final short LDRP_DATA_ADDR = 5;
    private static final short LD_RESPONSE_LENG = 7;
    private static final short LDRP_ERROR_OK = 1;
    private static final short LDRP_ERROR_TIMEOUT = 2;
    private static final short LDRP_ERROR_BAD_DATA = 4;
    private static final short LDRP_ERROR_UNKNOWN = 8;
    private static final Map<Short, String> ldErrorMap = new HashMap<Short, String>();
    private final short[] configData = new short[38];

    public Pluto() {
        this.setOptions(Ascii.Option.KEEP_ALIVE_NO_SERIAL);
    }

    @Override
    public void open(Modbus.ConnType type, String ident, int parm1, int parm2) throws DriverException {
        super.open(type, ident, parm1, parm2);
        super.setAddressMode(true);
    }

    public void open(String ident) throws DriverException {
        this.open(Modbus.ConnType.NET, ident);
    }

    public void open(String ident, int parm) throws DriverException {
        this.open(Modbus.ConnType.NET, ident, parm);
    }

    @Override
    public void setAddressMode(boolean mode) {
    }

    public int readModuleStatus() throws DriverException {
        return Pluto.toInteger(this.readRegisters((short)33, (short)1, (short)2));
    }

    public int readGlobalData(int pluto) throws DriverException {
        return Pluto.toInteger(this.readRegisters((short)33, (short)(3 + 2 * pluto), (short)2));
    }

    public int readAdditionalData(int area) throws DriverException {
        return Pluto.toInteger(this.readRegisters((short)33, (short)(67 + 2 * area), (short)2));
    }

    public void configStart(int nodeMask, int areaMask, int timeout, int cycleTime) {
        this.configData[0] = 37;
        this.configData[3] = (short)(nodeMask & 0xFFFF);
        this.configData[4] = (short)(nodeMask >> 16);
        this.configData[1] = (short)areaMask;
        this.configData[2] = (short)timeout;
        this.configData[37] = (short)cycleTime;
    }

    public void configDataArea(int area, int pluto, int dataId) {
        this.configData[5 + (area & 0x1F)] = (short)(pluto << 8 | dataId & 0xFF);
    }

    public void configWrite() throws DriverException {
        this.writeRegisters((short)4, (short)0, this.configData);
    }

    public void writeAreaBit(int area, int bit, int value) throws DriverException {
        short addr = (short)(2 + 3 * (area &= 3));
        short bitVal = this.readRegisters((short)1, addr, (short)1)[0];
        bitVal = (value & 1) != 0 ? (short)(bitVal | 1 << bit) : (short)(bitVal & ~(1 << (bit &= 0xF)));
        this.writeRegister((short)1, addr, bitVal);
        this.writeRegisters((short)1, (short)0, new short[]{1, (short)(1 << area)});
    }

    public void writeAreaBits(int area, int value) throws DriverException {
        short addr = (short)(2 + 3 * (area &= 3));
        this.writeRegister((short)1, addr, (short)value);
        this.writeRegisters((short)1, (short)0, new short[]{1, (short)(1 << area)});
    }

    public int readAreaBit(int area, int bit) throws DriverException {
        short addr = (short)(2 + 3 * (area &= 3));
        short value = this.readRegisters((short)1, addr, (short)1)[0];
        return value >> (bit &= 0xF) & 1;
    }

    public int readAreaBits(int area) throws DriverException {
        short addr = (short)(2 + 3 * (area &= 3));
        return this.readRegisters((short)1, addr, (short)1)[0];
    }

    public void writeAreaRegister(int area, int reg, int value) throws DriverException {
        short addr = (short)(3 + 3 * (area &= 3) + (reg & 1));
        this.writeRegister((short)1, addr, (short)value);
        this.writeRegisters((short)1, (short)0, new short[]{1, (short)(1 << area)});
    }

    public int readAreaRegister(int area, int reg) throws DriverException {
        short addr = (short)(3 + 3 * (area & 3) + (reg & 1));
        return this.readRegisters((short)1, addr, (short)1)[0];
    }

    public int readLocalData(int pluto, int type, int addr) throws DriverException {
        short value = this.readRegisters((short)2, (short)0, (short)1)[0];
        if (value != 0) {
            throw new DriverException("Gateway busy");
        }
        short[] rqst = new short[]{3, (short)pluto, (short)type, (short)addr};
        this.writeRegister((short)34, (short)0, (short)0);
        this.writeRegisters((short)2, (short)0, rqst);
        short[] reply = null;
        for (int j = 1; j <= 100 && (reply = this.readRegisters((short)34, (short)0, (short)7))[0] == 0; ++j) {
        }
        if (reply[0] == false) {
            throw new DriverException("No response received");
        }
        if (reply[1] != rqst[1]) {
            throw new DriverException("Incorrect Pluto ID in response");
        }
        if (reply[2] != rqst[2]) {
            throw new DriverException("Incorrect data type in response");
        }
        if (reply[3] != rqst[3]) {
            throw new DriverException("Incorrect data address in response");
        }
        short code = reply[4];
        if (code != 1) {
            String desc = ldErrorMap.get(code);
            String text = "Response error: " + (desc != null ? desc : "unrecognized (" + code + ")");
            throw new DriverException(text);
        }
        return Pluto.toInteger(reply, 5);
    }

    private static int toInteger(short[] value) {
        return Pluto.toInteger(value, 0);
    }

    private static int toInteger(short[] value, int offset) {
        return value[offset] << 16 | value[offset + 1] & 0xFFFF;
    }

    static {
        ldErrorMap.put((short)2, "timeout");
        ldErrorMap.put((short)4, "bad data");
        ldErrorMap.put((short)8, "unknown");
    }
}

