/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.XmlElement;
import org.jgroups.annotations.XmlInclude;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.XmlNode;
import org.jgroups.fork.ForkConfig;
import org.jgroups.fork.ForkProtocol;
import org.jgroups.fork.ForkProtocolStack;
import org.jgroups.fork.UnknownForkHandler;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Bits;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.OutputStreamAdapter;
import org.jgroups.util.Util;

@XmlInclude(schema={"fork-stacks.xsd"}, type=XmlInclude.Type.EMBED, namespace="fork", alias="fork")
@XmlElement(name="fork-stacks", type="tns:ForkStacksType")
@MBean(description="Implementation of FORK protocol")
public class FORK
extends Protocol {
    public static short ID = ClassConfigurator.getProtocolId(FORK.class);
    @Property(description="Points to an XML file defining the fork-stacks, which will be created at initialization. Ignored if null")
    protected String config;
    @Property(description="If enabled, state transfer events will be processed, else they will be passed up")
    protected boolean process_state_events = true;
    private UnknownForkHandler unknownForkHandler = new UnknownForkHandler(){

        @Override
        public Object handleUnknownForkStack(Message message, String forkStackId) {
            FORK.this.log.warn("%s: fork-stack for id=%s not found; discarding message", FORK.this.local_addr, forkStackId);
            return null;
        }

        @Override
        public Object handleUnknownForkChannel(Message message, String forkChannelId) {
            FORK.this.log.warn("%s: fork-channel for id=%s not found; discarding message", FORK.this.local_addr, forkChannelId);
            return null;
        }
    };
    protected final ConcurrentMap<String, Protocol> fork_stacks = new ConcurrentHashMap<String, Protocol>();

    public FORK setUnknownForkHandler(UnknownForkHandler unknownForkHandler) {
        this.unknownForkHandler = unknownForkHandler;
        this.fork_stacks.values().forEach(p -> {
            ForkProtocolStack st;
            if (p instanceof ForkProtocol && (st = FORK.getForkStack(p)) != null) {
                st.setUnknownForkHandler(unknownForkHandler);
            }
        });
        return this;
    }

    public UnknownForkHandler getUnknownForkHandler() {
        return this.unknownForkHandler;
    }

    public String getConfig() {
        return this.config;
    }

    public FORK setConfig(String c) {
        this.config = c;
        return this;
    }

    public boolean processStateEvents() {
        return this.process_state_events;
    }

    public FORK processStateEvents(boolean p) {
        this.process_state_events = p;
        return this;
    }

    public Protocol get(String fork_stack_id) {
        return (Protocol)this.fork_stacks.get(fork_stack_id);
    }

    public Protocol putIfAbsent(String fork_stack_id, Protocol p) {
        return this.fork_stacks.put(fork_stack_id, p);
    }

    public void remove(String fork_stack_id) {
        this.fork_stacks.remove(fork_stack_id);
    }

    @ManagedAttribute(description="Number of fork-stacks")
    public int getForkStacks() {
        return this.fork_stacks.size();
    }

    public static ForkProtocolStack getForkStack(Protocol prot) {
        while (prot != null && !(prot instanceof ForkProtocolStack)) {
            prot = prot.getUpProtocol();
        }
        return prot instanceof ForkProtocolStack ? (ForkProtocolStack)prot : null;
    }

    @Override
    public <T extends Protocol> T setAddress(Address addr) {
        super.setAddress(addr);
        for (Protocol prot : this.fork_stacks.values()) {
            if (!(prot instanceof ForkProtocol)) continue;
            ForkProtocol fp = (ForkProtocol)prot;
            ProtocolStack st = fp.getProtocolStack();
            for (Protocol p : st.getProtocols()) {
                p.setAddress(this.local_addr);
            }
        }
        return (T)this;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.config != null) {
            this.createForkStacks(this.config);
        }
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 104: 
            case 105: {
                for (Protocol bottom : this.fork_stacks.values()) {
                    bottom.up(evt);
                }
                break;
            }
            case 72: {
                if (!this.process_state_events) break;
                this.getStateFromMainAndForkChannels(evt);
                return null;
            }
            case 71: {
                if (!this.process_state_events) break;
                this.setStateInMainAndForkChannels((InputStream)evt.getArg());
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        ForkHeader hdr = (ForkHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        if (hdr.fork_stack_id == null) {
            throw new IllegalArgumentException("header has a null fork_stack_id");
        }
        Protocol bottom_prot = this.get(hdr.fork_stack_id);
        return bottom_prot != null ? bottom_prot.up(msg) : this.unknownForkHandler.handleUnknownForkStack(msg, hdr.fork_stack_id);
    }

    @Override
    public void up(MessageBatch batch) {
        HashMap<String, List> map = new HashMap<String, List>();
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            ForkHeader hdr = (ForkHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            it.remove();
            List list = map.computeIfAbsent(hdr.fork_stack_id, k -> new ArrayList());
            list.add(msg);
        }
        for (Map.Entry entry : map.entrySet()) {
            String fork_stack_id = (String)entry.getKey();
            List list = (List)entry.getValue();
            Protocol bottom_prot = this.get(fork_stack_id);
            if (bottom_prot == null) {
                for (Message m : list) {
                    this.unknownForkHandler.handleUnknownForkStack(m, fork_stack_id);
                }
                continue;
            }
            MessageBatch mb = new MessageBatch(batch.dest(), batch.sender(), batch.clusterName(), batch.multicast(), list);
            try {
                bottom_prot.up(mb);
            }
            catch (Throwable t) {
                this.log.error(Util.getMessage("FailedPassingUpBatch"), t);
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void getStateFromMainAndForkChannels(Event evt) {
        OutputStream out = (OutputStream)evt.getArg();
        try (DataOutputStream dos = new DataOutputStream(out);){
            this.getStateFrom(null, this.up_prot, null, null, dos);
            for (Map.Entry entry : this.fork_stacks.entrySet()) {
                String stack_name = (String)entry.getKey();
                Protocol prot = (Protocol)entry.getValue();
                ForkProtocolStack fork_stack = FORK.getForkStack(prot);
                for (Map.Entry en : fork_stack.getForkChannels().entrySet()) {
                    String fc_name = (String)en.getKey();
                    JChannel fc = (JChannel)en.getValue();
                    this.getStateFrom(fc, null, stack_name, fc_name, dos);
                }
            }
        }
        catch (Throwable ex) {
            this.log.error("%s: failed fetching state from main channel", this.local_addr, ex);
        }
    }

    protected void getStateFrom(JChannel channel, Protocol prot, String stack, String ch, DataOutputStream out) throws Exception {
        ByteArrayDataOutputStream output = new ByteArrayDataOutputStream(1024, true);
        OutputStreamAdapter out_ad = new OutputStreamAdapter(output);
        Event evt = new Event(72, out_ad);
        if (channel != null) {
            channel.up(evt);
        } else {
            prot.up(evt);
        }
        int len = output.position();
        if (len > 0) {
            Bits.writeString(stack, out);
            Bits.writeString(ch, out);
            out.writeInt(len);
            out.write(output.buffer(), 0, len);
            this.log.trace("%s: fetched %d bytes from %s:%s", this.local_addr, len, stack, ch);
        }
    }

    protected void setStateInMainAndForkChannels(InputStream in) {
        try {
            DataInputStream input = new DataInputStream(in);
            try {
                while (true) {
                    String stack_name = Bits.readString(input);
                    String ch_name = Bits.readString(input);
                    int len = input.readInt();
                    if (len <= 0) continue;
                    byte[] data = new byte[len];
                    in.read(data, 0, len);
                    ByteArrayInputStream tmp = new ByteArrayInputStream(data, 0, len);
                    if (stack_name == null && ch_name == null) {
                        this.up_prot.up(new Event(71, tmp));
                        continue;
                    }
                    Protocol prot = (Protocol)this.fork_stacks.get(stack_name);
                    if (prot == null) {
                        this.log.warn("%s: fork stack %s not found, dropping state for %s:%s", this.local_addr, stack_name, stack_name, ch_name);
                        continue;
                    }
                    ForkProtocolStack fork_stack = FORK.getForkStack(prot);
                    JChannel fork_ch = fork_stack.get(ch_name);
                    if (fork_ch == null) {
                        this.log.warn("%s: fork channel %s not found, dropping state for %s:%s", this.local_addr, ch_name, stack_name, ch_name);
                        continue;
                    }
                    fork_ch.up(new Event(71, tmp));
                }
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (EOFException input) {
        }
        catch (Throwable ex) {
            this.log.error("%s: failed setting state in main channel", this.local_addr, ex);
        }
    }

    protected void createForkStacks(String config) throws Exception {
        InputStream in = FORK.getForkStream(config);
        if (in == null) {
            throw new FileNotFoundException("fork stacks config " + config + " not found");
        }
        Map<String, List<ProtocolConfiguration>> protocols = ForkConfig.parse(in);
        this.createForkStacks(protocols);
    }

    protected void createForkStacks(Map<String, List<ProtocolConfiguration>> protocols) throws Exception {
        for (Map.Entry<String, List<ProtocolConfiguration>> entry : protocols.entrySet()) {
            String fork_stack_id = entry.getKey();
            if (this.get(fork_stack_id) != null) continue;
            List<Protocol> prots = Configurator.createProtocolsAndInitializeAttrs(entry.getValue(), null);
            this.createForkStack(fork_stack_id, prots, false);
        }
    }

    @Override
    public void parse(XmlNode node) throws Exception {
        Map<String, List<ProtocolConfiguration>> protocols = ForkConfig.parse(node);
        this.createForkStacks(protocols);
    }

    public synchronized ProtocolStack createForkStack(String fork_stack_id, List<Protocol> protocols, boolean initialize) throws Exception {
        Protocol bottom = this.get(fork_stack_id);
        if (bottom != null) {
            ForkProtocolStack retval = FORK.getForkStack(bottom);
            return initialize ? retval.incrInits() : retval;
        }
        ArrayList<Protocol> prots = new ArrayList<Protocol>();
        bottom = new ForkProtocol(fork_stack_id).setDownProtocol(this);
        prots.add(bottom);
        if (protocols != null) {
            prots.addAll(protocols);
        }
        ForkProtocolStack fork_stack = (ForkProtocolStack)new ForkProtocolStack(this.getUnknownForkHandler(), prots, fork_stack_id).setChannel(this.stack.getChannel());
        fork_stack.init();
        if (initialize) {
            fork_stack.incrInits();
        }
        this.fork_stacks.put(fork_stack_id, bottom);
        return fork_stack;
    }

    public static InputStream getForkStream(String config) throws IOException {
        InputStream configStream = null;
        try {
            configStream = new FileInputStream(config);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (configStream == null) {
            try {
                configStream = new URL(config).openStream();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (configStream == null) {
            configStream = Util.getResourceAsStream(config, ConfiguratorFactory.class);
        }
        return configStream;
    }

    public static class ForkHeader
    extends Header {
        protected String fork_stack_id;
        protected String fork_channel_id;

        public ForkHeader() {
        }

        public ForkHeader(String fork_stack_id, String fork_channel_id) {
            this.fork_stack_id = fork_stack_id;
            this.fork_channel_id = fork_channel_id;
        }

        @Override
        public short getMagicId() {
            return 83;
        }

        @Override
        public Supplier<? extends Header> create() {
            return ForkHeader::new;
        }

        public String getForkStackId() {
            return this.fork_stack_id;
        }

        public void setForkStackId(String fork_stack_id) {
            this.fork_stack_id = fork_stack_id;
        }

        public String getForkChannelId() {
            return this.fork_channel_id;
        }

        public void setForkChannelId(String fork_channel_id) {
            this.fork_channel_id = fork_channel_id;
        }

        @Override
        public int serializedSize() {
            return Util.size(this.fork_stack_id) + Util.size(this.fork_channel_id);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeString(this.fork_stack_id, out);
            Bits.writeString(this.fork_channel_id, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException {
            this.fork_stack_id = Bits.readString(in);
            this.fork_channel_id = Bits.readString(in);
        }

        @Override
        public String toString() {
            return this.fork_stack_id + ":" + this.fork_channel_id;
        }
    }
}

