/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.pathfinder.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.common.ui.TextFieldX;
import org.lsst.ccs.subsystem.common.ui.UiConstants;
import org.lsst.ccs.subsystem.common.ui.UiUtilities;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.pathfinder.constants.ConditionState;
import org.lsst.ccs.subsystem.pathfinder.constants.DeviceState;
import org.lsst.ccs.subsystem.pathfinder.constants.FanState;
import org.lsst.ccs.subsystem.pathfinder.constants.LatchState;
import org.lsst.ccs.subsystem.pathfinder.constants.PLCState;
import org.lsst.ccs.subsystem.pathfinder.constants.SwitchEnable;
import org.lsst.ccs.subsystem.pathfinder.constants.SwitchState;
import org.lsst.ccs.subsystem.pathfinder.constants.TrimHeaterOpState;
import org.lsst.ccs.subsystem.pathfinder.constants.UtilTrunkFans;
import org.lsst.ccs.subsystem.pathfinder.data.VacSysState;

public class PathfinderControlPanel
extends JPanel
implements UiUtilities.ActionHandler,
CommandSender.ReplyHandler {
    static final Font FONT = new Font("Tahoma", 1, 12);
    static final Color RED = new Color(175, 0, 0);
    static final Color GREEN = new Color(0, 175, 0);
    static final Color BLUE = new Color(0, 75, 175);
    static final Color PURPLE = new Color(175, 0, 175);
    static final int SWTP_PUMP = 0;
    static final int SWTP_VALVE = 1;
    static final String[] switchNames = new String[5];
    static final int[] switchTypes;
    private static final String[] latchNames;
    private static final String[] conditionNames;
    private static final int sysStateWidth;
    private static final int plcStateWidth;
    private static final int pfCCStateWidth;
    private static final int turboCCStateWidth;
    private static final int switchStatusWidth;
    private static final int latchStatusWidth;
    private static final int condStatusWidth;
    private static final int FAN_STATE_WIDTH;
    private static final int HEATER_STATE_WIDTH;
    private final CommandSender sender;
    private String subsys;
    private double mainPeriod = 5.0;
    private int switchMask = 0;
    private int latchMask = 0;
    private int conditionMask = 0;
    private final UiUtilities uiUtils;
    private final JPanel mainPanel = new JPanel();
    private final JPanel headPanel = new JPanel();
    private JLabel sysStateValue;
    private JLabel plcStateValue;
    private JLabel pfCCStateValue;
    private JLabel turboCCStateValue;
    private TextFieldX periodTextField;
    private final JLabel[] fanState = new JLabel[1];
    private final ButtonGroup[] fanBG = new ButtonGroup[1];
    private final JRadioButton[] fanOffRB = new JRadioButton[1];
    private final JRadioButton[] fanSpeedRB = new JRadioButton[1];
    private final TextFieldX[] fanSpeedTF = new TextFieldX[1];
    private final JRadioButton[] fanTempRB = new JRadioButton[1];
    private final TextFieldX[] fanTempTF = new TextFieldX[1];
    private final JLabel[] heaterState = new JLabel[2];
    private final ButtonGroup[] heaterBG = new ButtonGroup[2];
    private final JRadioButton[] heaterOffRB = new JRadioButton[2];
    private final JRadioButton[] heaterPowerRB = new JRadioButton[2];
    private final TextFieldX[] heaterPowerTF = new TextFieldX[2];
    private final JRadioButton[] heaterTempRB = new JRadioButton[2];
    private final TextFieldX[] heaterTempTF = new TextFieldX[2];
    private final JLabel stateLabel = new JLabel("System State:  ");
    private final JLabel stateStatus = new JLabel("STOPPED");
    private final JPanel periodPanel = new JPanel();
    private final JLabel periodLabel = new JLabel("Update Period: ");
    private final JLabel periodUnitsLabel = new JLabel("sec");
    private final JPanel switchPanel = new JPanel();
    private final JLabel[] switchLabel = new JLabel[5];
    private final JLabel[] switchStatus = new JLabel[5];
    private final ButtonGroup[] switchBG = new ButtonGroup[5];
    private final JRadioButton[] switchOffRB = new JRadioButton[5];
    private final JRadioButton[] switchOnRB = new JRadioButton[5];
    private JPanel latchPanel;
    private final JLabel[] latchLabel = new JLabel[8];
    private final JLabel[] latchStatus = new JLabel[8];
    private final JButton[] latchResetBtn = new JButton[8];
    private JPanel conditionPanel;
    private final JLabel[] conditionLabel = new JLabel[16];
    private final JLabel[] conditionStatus = new JLabel[16];
    private final JButton[] conditionResetBtn = new JButton[16];
    private JPanel utPanel;
    private static final long serialVersionUID = 1L;

    public PathfinderControlPanel(String subsys) {
        this.uiUtils = new UiUtilities((UiUtilities.ActionHandler)this);
        this.sender = new CommandSender(subsys, (CommandSender.ReplyHandler)this);
        this.initComponents();
        new DisablePanel().run();
    }

    public void setSubsystem(String name) {
        this.subsys = name;
    }

    private void initComponents() {
        int cond;
        ButtonGroup bg;
        this.sysStateValue = UiUtilities.newLabel((String)"X", (int)sysStateWidth);
        this.plcStateValue = UiUtilities.newLabel((String)"X", (int)plcStateWidth);
        this.pfCCStateValue = UiUtilities.newLabel((String)"X", (int)pfCCStateWidth);
        this.turboCCStateValue = UiUtilities.newLabel((String)"X", (int)turboCCStateWidth);
        this.periodTextField = this.uiUtils.newTextFieldX("00000.0", "U", 2);
        this.stateLabel.setFont(FONT);
        this.stateStatus.setFont(FONT);
        Dimension d = this.stateStatus.getPreferredSize();
        d.width = 150;
        this.stateStatus.setMinimumSize(d);
        this.stateStatus.setPreferredSize(d);
        this.periodLabel.setFont(FONT);
        d = this.periodTextField.getPreferredSize();
        d.width = 45;
        this.periodTextField.setMinimumSize(d);
        this.periodTextField.setPreferredSize(d);
        this.periodTextField.setHorizontalAlignment(0);
        this.periodTextField.setText("...");
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PathfinderControlPanel.this.setUpdatePeriod();
            }
        });
        this.periodUnitsLabel.setFont(FONT);
        for (int fanId = 0; fanId < 1; ++fanId) {
            this.fanState[fanId] = UiUtilities.newLabel((String)"XXX", (int)FAN_STATE_WIDTH);
            this.fanOffRB[fanId] = this.uiUtils.newRadioButton("Off", "FF" + fanId);
            this.fanSpeedRB[fanId] = this.uiUtils.newRadioButton("Speed", "FS" + fanId);
            this.fanTempRB[fanId] = this.uiUtils.newRadioButton("Delta Temp", "FT" + fanId);
            bg = this.fanBG[fanId] = new ButtonGroup();
            bg.add(this.fanOffRB[fanId]);
            bg.add(this.fanSpeedRB[fanId]);
            bg.add(this.fanTempRB[fanId]);
            this.fanSpeedTF[fanId] = this.uiUtils.newTextFieldX("0000.00", "S" + fanId, 2, true);
            this.fanTempTF[fanId] = this.uiUtils.newTextFieldX("0000.00", "T" + fanId, 2, true);
        }
        for (int heaterId = 0; heaterId < 2; ++heaterId) {
            this.heaterState[heaterId] = UiUtilities.newLabel((String)"XXX", (int)HEATER_STATE_WIDTH);
            this.heaterOffRB[heaterId] = this.uiUtils.newRadioButton("Off", "HH" + heaterId);
            this.heaterTempRB[heaterId] = this.uiUtils.newRadioButton("Temp", "HT" + heaterId);
            this.heaterPowerRB[heaterId] = this.uiUtils.newRadioButton("Power", "HP" + heaterId);
            bg = this.heaterBG[heaterId] = new ButtonGroup();
            bg.add(this.heaterOffRB[heaterId]);
            bg.add(this.heaterTempRB[heaterId]);
            bg.add(this.heaterPowerRB[heaterId]);
            this.heaterTempTF[heaterId] = this.uiUtils.newTextFieldX("0000.00", "K" + heaterId, 2, true);
            this.heaterPowerTF[heaterId] = this.uiUtils.newTextFieldX("0000.00", "P" + heaterId, 2, true);
        }
        for (int sw = 0; sw < 5; ++sw) {
            JLabel label = this.switchLabel[sw] = new JLabel(switchNames[sw]);
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 130;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            label = this.switchStatus[sw] = new JLabel("XXX");
            label.setFont(FONT);
            d = label.getPreferredSize();
            d.width = 80;
            label.setMinimumSize(d);
            label.setPreferredSize(d);
            int swType = switchTypes[sw];
            JRadioButton buttonOff = this.switchOffRB[sw] = new JRadioButton(swType == 0 ? "Off" : "Shut");
            buttonOff.setFont(FONT);
            buttonOff.setFocusable(false);
            buttonOff.setName(Integer.toString(sw));
            buttonOff.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    PathfinderControlPanel.this.setSwitchOn(Integer.valueOf(name), false);
                }
            });
            JRadioButton buttonOn = this.switchOnRB[sw] = new JRadioButton(swType == 0 ? "On" : "Open");
            buttonOn.setFont(FONT);
            buttonOn.setFocusable(false);
            buttonOn.setName(Integer.toString(sw));
            buttonOn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JRadioButton)evt.getSource()).getName();
                    PathfinderControlPanel.this.setSwitchOn(Integer.valueOf(name), true);
                }
            });
            ButtonGroup bg2 = this.switchBG[sw] = new ButtonGroup();
            bg2.add(buttonOff);
            bg2.add(buttonOn);
        }
        for (cond = 0; cond < 8; ++cond) {
            this.latchLabel[cond] = UiUtilities.newLabel((String)(latchNames[cond] + ":"), (int)0);
            this.latchStatus[cond] = UiUtilities.newLabel((String)"X", (int)latchStatusWidth);
            this.latchResetBtn[cond] = this.uiUtils.newButton("Reset", "R" + cond, true);
            JButton button = this.latchResetBtn[cond];
            Insets i = button.getMargin();
            i.left -= 3;
            i.right -= 3;
            button.setMargin(i);
            d = button.getPreferredSize();
            button.setPreferredSize(d);
            button.setFont(UiConstants.FONT);
            button.setFocusable(false);
            button.setName(Integer.toString(cond));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String name = ((JButton)evt.getSource()).getName();
                    PathfinderControlPanel.this.clearLatch(Integer.valueOf(name));
                }
            });
        }
        for (cond = 0; cond < 16; ++cond) {
            this.conditionLabel[cond] = UiUtilities.newLabel((String)(conditionNames[cond] + ":"), (int)0);
            this.conditionStatus[cond] = UiUtilities.newLabel((String)"X", (int)condStatusWidth);
        }
        this.periodPanel.add((Component)this.periodTextField);
        this.periodPanel.add(this.periodUnitsLabel);
        this.headPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbh = new GridBagConstraints();
        gbh.insets = new Insets(5, 0, 5, 0);
        gbh.gridx = 0;
        gbh.gridy = 0;
        gbh.anchor = 17;
        gbh.insets.left = 5;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"System State: ", (int)0), gbh);
        ++gbh.gridx;
        this.headPanel.add((Component)this.sysStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"PLC State: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.plcStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"PF CC: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.pfCCStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"Turbo CC: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.turboCCStateValue, gbh);
        ++gbh.gridx;
        gbh.insets.left = 25;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"Update Period: ", (int)0), gbh);
        ++gbh.gridx;
        gbh.insets.left = 5;
        this.headPanel.add((Component)this.periodTextField, gbh);
        ++gbh.gridx;
        gbh.insets.right = 5;
        this.headPanel.add((Component)UiUtilities.newLabel((String)"sec", (int)0), gbh);
        TitledBorder border = BorderFactory.createTitledBorder("Switches");
        border.setTitleJustification(2);
        this.switchPanel.setBorder(border);
        this.switchPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.gridx = 0;
        gbs.gridy = 0;
        gbs.insets.bottom = -8;
        this.switchPanel.add((Component)new JLabel(" "), gbs);
        this.latchPanel = UiUtilities.newBorderedPanel((String)"PLC Error Conditions");
        GridBagConstraints gbl = new GridBagConstraints();
        gbl.gridx = 0;
        gbl.gridy = 0;
        gbl.insets.bottom = -8;
        this.latchPanel.add((Component)new JLabel(" "), gbl);
        this.conditionPanel = UiUtilities.newBorderedPanel((String)"PLC Running Conditions");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets.bottom = -8;
        this.conditionPanel.add((Component)new JLabel(" "), gbc);
        this.utPanel = UiUtilities.newBorderedPanel((String)"UT Cooling Control");
        GridBagConstraints gbu = new GridBagConstraints();
        gbu.anchor = 17;
        gbl.insets.bottom = -8;
        gbu.gridx = 0;
        gbu.gridy = 0;
        this.addFanLine(0, this.utPanel, gbu);
        gbu.gridx = 0;
        ++gbu.gridy;
        this.addHeaterLine(0, this.utPanel, gbu);
        gbu.gridx = 0;
        ++gbu.gridy;
        this.addHeaterLine(1, this.utPanel, gbu);
        this.utPanel.setMinimumSize(this.utPanel.getPreferredSize());
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbm = new GridBagConstraints();
        gbm.insets = new Insets(0, 0, 0, 0);
        gbm.anchor = 11;
        gbm.gridx = 0;
        gbm.gridy = 0;
        this.mainPanel.add((Component)this.headPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.switchPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.latchPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.conditionPanel, gbm);
        ++gbm.gridy;
        this.mainPanel.add((Component)this.utPanel, gbm);
        this.add(this.mainPanel);
    }

    private void updateSwitchLayout(int switches) {
        for (int sw = 0; sw < 5; ++sw) {
            if ((this.switchMask & 1 << sw) == 0) continue;
            this.switchPanel.remove(this.switchLabel[sw]);
            this.switchPanel.remove(this.switchStatus[sw]);
            this.switchPanel.remove(this.switchOffRB[sw]);
            this.switchPanel.remove(this.switchOnRB[sw]);
        }
        GridBagConstraints gbs = new GridBagConstraints();
        gbs.anchor = 18;
        gbs.gridy = 0;
        int colm = 0;
        for (int sw = 0; sw < 5; ++sw) {
            if ((switches & 1 << sw) == 0) continue;
            if (colm == 0) {
                gbs.gridx = 0;
                ++gbs.gridy;
            }
            gbs.insets.top = 0;
            gbs.insets.left = colm == 0 ? 4 : 50;
            this.switchPanel.add((Component)this.switchLabel[sw], gbs);
            gbs.insets.left = 0;
            ++gbs.gridx;
            this.switchPanel.add((Component)this.switchStatus[sw], gbs);
            ++gbs.gridx;
            gbs.insets.top = -4;
            this.switchPanel.add((Component)this.switchOffRB[sw], gbs);
            ++gbs.gridx;
            gbs.insets.left = 6;
            gbs.insets.right = 3;
            this.switchPanel.add((Component)this.switchOnRB[sw], gbs);
            gbs.insets.right = 0;
            ++gbs.gridx;
            colm = (colm + 1) % 2;
        }
        this.switchMask = switches;
    }

    private void updateLatchLayout(int conditions) {
        for (int cond = 0; cond < 8; ++cond) {
            if ((this.latchMask & 1 << cond) == 0) continue;
            this.latchPanel.remove(this.latchLabel[cond]);
            this.latchPanel.remove(this.latchStatus[cond]);
            this.latchPanel.remove(this.latchResetBtn[cond]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        int colm = 0;
        for (int cond = 0; cond < 8; ++cond) {
            if ((conditions & 1 << cond) == 0) continue;
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 40;
            this.latchPanel.add((Component)this.latchLabel[cond], gbc);
            gbc.insets.left = 4;
            ++gbc.gridx;
            this.latchPanel.add((Component)this.latchStatus[cond], gbc);
            ++gbc.gridx;
            this.latchPanel.add((Component)this.latchResetBtn[cond], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % 2;
        }
        this.latchMask = conditions;
    }

    private void updateConditionLayout(int conditions) {
        for (int cond = 0; cond < 8; ++cond) {
            if ((this.conditionMask & 1 << cond) == 0) continue;
            this.conditionPanel.remove(this.conditionLabel[cond]);
            this.conditionPanel.remove(this.conditionStatus[cond]);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 4, 4);
        gbc.gridy = -1;
        int colm = 0;
        for (int cond = 0; cond < 16; ++cond) {
            if ((conditions & 1 << cond) == 0) continue;
            if (colm == 0) {
                gbc.gridx = 0;
                ++gbc.gridy;
            }
            gbc.insets.top = gbc.gridy == 0 ? 4 : 0;
            gbc.insets.left = colm == 0 ? 4 : 40;
            this.conditionPanel.add((Component)this.conditionLabel[cond], gbc);
            ++gbc.gridx;
            gbc.insets.left = 4;
            this.conditionPanel.add((Component)this.conditionStatus[cond], gbc);
            ++gbc.gridx;
            colm = (colm + 1) % 2;
        }
        this.conditionMask = conditions;
    }

    private void setUpdatePeriod() {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.sender.sendCommand(this.subsys, "setUpdatePeriod", new Object[]{(int)(1000.0 * value)});
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException nfe) {
            this.periodTextField.setText(String.valueOf(this.mainPeriod));
        }
    }

    private void setSwitchOn(int sw, boolean value) {
        this.switchOffRB[sw].setEnabled(false);
        this.switchOnRB[sw].setEnabled(false);
        this.sender.sendCommand(this.subsys, "setSwitchOn", new Object[]{sw, value});
    }

    public void handleRadioButton(String name) {
        char type = name.charAt(0);
        char action = name.charAt(1);
        int id = Integer.valueOf(name.substring(2));
        switch (type) {
            case 'F': {
                FanState fState = action == 'T' ? FanState.TEMP : (action == 'S' ? FanState.SPEED : FanState.OFF);
                this.sender.sendCommand(null, "setFanState", new Object[]{UtilTrunkFans.getName(id), fState});
                break;
            }
            case 'H': {
                TrimHeaterOpState hState = action == 'T' ? TrimHeaterOpState.TEMP : (action == 'P' ? TrimHeaterOpState.POWER : TrimHeaterOpState.OFF);
                this.sender.sendCommand(null, "setTrimHeaterState", new Object[]{id, hState});
            }
        }
    }

    public void handleTextFieldX(String name, Object value) {
        char type = name.charAt(0);
        int id = Integer.valueOf(name.substring(1));
        switch (type) {
            case 'S': {
                this.sender.sendCommand(null, "setFanSpeed", new Object[]{UtilTrunkFans.getName(id), (Double)value});
                break;
            }
            case 'T': {
                this.sender.sendCommand(null, "setFanDeltaTemp", new Object[]{UtilTrunkFans.getName(id), (Double)value});
                break;
            }
            case 'K': {
                this.sender.sendCommand(null, "setTemperature", new Object[]{id, (Double)value});
                break;
            }
            case 'P': {
                this.sender.sendCommand(null, "setPower", new Object[]{id, (Double)value});
            }
        }
    }

    public void clearLatch(int cond) {
        this.latchResetBtn[cond].setEnabled(false);
        this.sender.sendCommand(null, "clearLatch", new Object[]{cond});
    }

    private void clearCondition(int cond) {
        this.conditionResetBtn[cond].setEnabled(false);
        this.sender.sendCommand(this.subsys, "clearCondition", new Object[]{cond});
    }

    private void addFanLine(int fanId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)"Fan:", (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.fanState[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanOffRB[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanSpeedRB[fanId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.fanSpeedTF[fanId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        panel.add((Component)UiUtilities.newLabel((String)"D/C", (int)0), gbc);
        gbc.insets.left = 4;
        ++gbc.gridx;
        if (UtilTrunkFans.hasTempState(fanId)) {
            panel.add((Component)this.fanTempRB[fanId], gbc);
            ++gbc.gridx;
            panel.add((Component)this.fanTempTF[fanId], gbc);
            ++gbc.gridx;
            gbc.insets.left = 0;
            panel.add((Component)UiUtilities.newLabel((String)"\u00b0C", (int)0), gbc);
            gbc.insets.left = 4;
            ++gbc.gridx;
        }
    }

    private void addHeaterLine(int heaterId, JPanel panel, GridBagConstraints gbc) {
        panel.add((Component)UiUtilities.newLabel((String)("Heater" + heaterId + ":"), (int)0), gbc);
        ++gbc.gridx;
        gbc.insets.left = 4;
        panel.add((Component)this.heaterState[heaterId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterOffRB[heaterId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterTempRB[heaterId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterTempTF[heaterId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        panel.add((Component)UiUtilities.newLabel((String)"\u00b0C", (int)0), gbc);
        gbc.insets.left = 4;
        ++gbc.gridx;
        panel.add((Component)this.heaterPowerRB[heaterId], gbc);
        ++gbc.gridx;
        panel.add((Component)this.heaterPowerTF[heaterId], gbc);
        ++gbc.gridx;
        gbc.insets.left = 0;
        panel.add((Component)UiUtilities.newLabel((String)"(0 to 1)", (int)0), gbc);
        gbc.insets.left = 4;
        ++gbc.gridx;
    }

    public void initPanel() {
        this.sender.sendCommand(true, null, "getVacuumState", new Object[0]);
    }

    public void onCommandReply(Object reply, String path, String command, Object[] args) {
        this.updatePanel((VacSysState)reply);
    }

    public void updatePanel(VacSysState rs) {
        SwingUtilities.invokeLater(new UpdateVacStatus(rs));
    }

    public void disablePanel() {
        SwingUtilities.invokeLater(new DisablePanel());
    }

    static {
        PathfinderControlPanel.switchNames[1] = "Hx Turbo Pump";
        PathfinderControlPanel.switchNames[2] = "Hx Ion Pump";
        PathfinderControlPanel.switchNames[3] = "Hx Gate Valve";
        switchTypes = new int[5];
        PathfinderControlPanel.switchTypes[1] = 0;
        PathfinderControlPanel.switchTypes[2] = 0;
        PathfinderControlPanel.switchTypes[3] = 1;
        latchNames = new String[8];
        PathfinderControlPanel.latchNames[2] = "Cryo Gate Can't Open";
        PathfinderControlPanel.latchNames[1] = "Cryo Gate Forced Shut";
        PathfinderControlPanel.latchNames[0] = "Cryo Vacuum Bad";
        PathfinderControlPanel.latchNames[3] = "Cryo Turbo Pump Bad";
        PathfinderControlPanel.latchNames[6] = "Hx Gate Can't Open";
        PathfinderControlPanel.latchNames[5] = "Hx Gate Forced Shut";
        PathfinderControlPanel.latchNames[4] = "Hx Vacuum Bad";
        PathfinderControlPanel.latchNames[7] = "Hx Turbo Pump Bad";
        conditionNames = new String[16];
        PathfinderControlPanel.conditionNames[0] = "Cryo Foreline OK";
        PathfinderControlPanel.conditionNames[2] = "Cryo Turbo Pr < 10";
        PathfinderControlPanel.conditionNames[1] = "Cryo Turbo Pump Off";
        PathfinderControlPanel.conditionNames[4] = "Cryo Vacuum < 0.001";
        PathfinderControlPanel.conditionNames[3] = "Cryo Vacuum < 0.1";
        PathfinderControlPanel.conditionNames[5] = "HX Foreline OK";
        PathfinderControlPanel.conditionNames[7] = "HX Turbo Pr < 10";
        PathfinderControlPanel.conditionNames[6] = "HX Turbo Pump On";
        PathfinderControlPanel.conditionNames[9] = "HX Vacuum < 0.001";
        PathfinderControlPanel.conditionNames[8] = "HX Vacuum < 0.1";
        PathfinderControlPanel.conditionNames[14] = "HX Gate Valve Open";
        PathfinderControlPanel.conditionNames[15] = "HX Gate Valve Closed";
        sysStateWidth = UiUtilities.maxLabelWidth((String[])new String[]{"RUNNING", "STOPPED"}, (String)"");
        plcStateWidth = UiUtilities.maxEnumLabelWidth(PLCState.class);
        pfCCStateWidth = UiUtilities.maxEnumLabelWidth(SwitchState.class);
        turboCCStateWidth = UiUtilities.maxEnumLabelWidth(SwitchState.class);
        switchStatusWidth = Math.max(UiUtilities.maxEnumLabelWidth(SwitchState.class), UiUtilities.maxEnumLabelWidth(DeviceState.class));
        latchStatusWidth = UiUtilities.maxEnumLabelWidth(LatchState.class);
        condStatusWidth = UiUtilities.maxEnumLabelWidth(ConditionState.class);
        FAN_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(FanState.class);
        HEATER_STATE_WIDTH = UiUtilities.maxEnumLabelWidth(TrimHeaterOpState.class);
    }

    class DisablePanel
    implements Runnable {
        DisablePanel() {
        }

        @Override
        public void run() {
            int cond;
            PathfinderControlPanel.this.sysStateValue.setText("STOPPED");
            PathfinderControlPanel.this.sysStateValue.setForeground(UiConstants.RED);
            PathfinderControlPanel.this.plcStateValue.setEnabled(false);
            PathfinderControlPanel.this.pfCCStateValue.setEnabled(false);
            PathfinderControlPanel.this.turboCCStateValue.setEnabled(false);
            PathfinderControlPanel.this.periodTextField.setDisabled();
            for (int fanId = 0; fanId < 1; ++fanId) {
                PathfinderControlPanel.this.fanState[fanId].setEnabled(false);
                PathfinderControlPanel.this.fanOffRB[fanId].setEnabled(false);
                PathfinderControlPanel.this.fanSpeedRB[fanId].setEnabled(false);
                PathfinderControlPanel.this.fanTempRB[fanId].setEnabled(false);
                PathfinderControlPanel.this.fanSpeedTF[fanId].setDisabled();
                PathfinderControlPanel.this.fanTempTF[fanId].setDisabled();
            }
            for (int heaterId = 0; heaterId < 2; ++heaterId) {
                PathfinderControlPanel.this.heaterState[heaterId].setEnabled(false);
                PathfinderControlPanel.this.heaterOffRB[heaterId].setEnabled(false);
                PathfinderControlPanel.this.heaterPowerRB[heaterId].setEnabled(false);
                PathfinderControlPanel.this.heaterTempRB[heaterId].setEnabled(false);
                PathfinderControlPanel.this.heaterPowerTF[heaterId].setDisabled();
                PathfinderControlPanel.this.heaterTempTF[heaterId].setDisabled();
            }
            for (int sw = 0; sw < 5; ++sw) {
                PathfinderControlPanel.this.switchStatus[sw].setEnabled(false);
                PathfinderControlPanel.this.switchOffRB[sw].setEnabled(false);
                PathfinderControlPanel.this.switchOnRB[sw].setEnabled(false);
            }
            for (cond = 0; cond < 8; ++cond) {
                try {
                    PathfinderControlPanel.this.latchStatus[cond].setEnabled(false);
                    PathfinderControlPanel.this.latchResetBtn[cond].setEnabled(false);
                    continue;
                }
                catch (NullPointerException npe) {
                    break;
                }
            }
            for (cond = 0; cond < 16; ++cond) {
                try {
                    PathfinderControlPanel.this.conditionStatus[cond].setEnabled(false);
                    continue;
                }
                catch (NullPointerException npe) {
                    break;
                }
            }
        }
    }

    class UpdateVacStatus
    implements Runnable {
        private final VacSysState vs;
        private final Logger sLog = Logger.getLogger("org.lsst.ccs.subsystem.pathfinder.ui.PathfinderControlPanel");

        UpdateVacStatus(VacSysState vs) {
            this.vs = vs;
        }

        @Override
        public void run() {
            Enum state;
            int cond;
            JRadioButton selButton;
            JLabel label;
            Enum st;
            this.sLog.info("VacStatus update");
            PathfinderControlPanel.this.sysStateValue.setText("RUNNING");
            PathfinderControlPanel.this.sysStateValue.setForeground(UiConstants.GREEN);
            PLCState plcState = this.vs.getPlcState();
            PathfinderControlPanel.this.plcStateValue.setText(plcState.name());
            PathfinderControlPanel.this.plcStateValue.setForeground(plcState == PLCState.ALIVE ? UiConstants.GREEN : (plcState == PLCState.OFFLINE ? UiConstants.BLUE : UiConstants.RED));
            PathfinderControlPanel.this.plcStateValue.setEnabled(true);
            if (this.vs.isPFCCon() != null) {
                PathfinderControlPanel.this.pfCCStateValue.setText(this.vs.isPFCCon() != false ? "on" : "off");
            } else {
                PathfinderControlPanel.this.pfCCStateValue.setText("unset");
            }
            PathfinderControlPanel.this.pfCCStateValue.setForeground(Color.BLACK);
            PathfinderControlPanel.this.pfCCStateValue.setEnabled(true);
            if (this.vs.isTURBOCCon() != null) {
                PathfinderControlPanel.this.turboCCStateValue.setText(this.vs.isTURBOCCon() != false ? "on" : "off");
            } else {
                PathfinderControlPanel.this.turboCCStateValue.setText("unset");
            }
            PathfinderControlPanel.this.turboCCStateValue.setForeground(Color.BLACK);
            PathfinderControlPanel.this.turboCCStateValue.setEnabled(true);
            PathfinderControlPanel.this.periodTextField.update((Object)((double)this.vs.getTickMillis() / 1000.0), true);
            for (int fanId = 0; fanId < 1; ++fanId) {
                st = this.vs.getFanState(fanId);
                st = st == null ? FanState.OFFLINE : st;
                label = PathfinderControlPanel.this.fanState[fanId];
                label.setText(st.toString());
                label.setForeground(st == FanState.TEMP ? UiConstants.GREEN : (st == FanState.SPEED ? UiConstants.YELLOW : (st == FanState.OFF ? Color.BLACK : UiConstants.BLUE)));
                st = this.vs.getFanBaseState(fanId);
                selButton = st == FanState.TEMP ? PathfinderControlPanel.this.fanTempRB[fanId] : (st == FanState.SPEED ? PathfinderControlPanel.this.fanSpeedRB[fanId] : PathfinderControlPanel.this.fanOffRB[fanId]);
                selButton.setSelected(true);
                PathfinderControlPanel.this.fanSpeedTF[fanId].update((Object)this.vs.getFanSpeed(fanId), true);
                PathfinderControlPanel.this.fanTempTF[fanId].update((Object)this.vs.getDeltaTemp(fanId), true);
                PathfinderControlPanel.this.fanState[fanId].setEnabled(true);
                PathfinderControlPanel.this.fanOffRB[fanId].setEnabled(true);
                PathfinderControlPanel.this.fanSpeedRB[fanId].setEnabled(true);
                PathfinderControlPanel.this.fanTempRB[fanId].setEnabled(true);
            }
            this.sLog.info("heater update");
            for (int heaterId = 0; heaterId < 2; ++heaterId) {
                this.sLog.info("updating heater infor for heater ID - " + heaterId);
                st = this.vs.getHeaterState(heaterId);
                st = st == null ? TrimHeaterOpState.OFF : st;
                label = PathfinderControlPanel.this.heaterState[heaterId];
                label.setText(st.toString());
                label.setForeground(st == TrimHeaterOpState.TEMP ? UiConstants.GREEN : (st == TrimHeaterOpState.POWER ? UiConstants.YELLOW : (st == TrimHeaterOpState.OFF ? Color.BLACK : UiConstants.BLUE)));
                st = this.vs.getHeaterState(heaterId);
                selButton = st == TrimHeaterOpState.TEMP ? PathfinderControlPanel.this.heaterTempRB[heaterId] : (st == TrimHeaterOpState.POWER ? PathfinderControlPanel.this.heaterPowerRB[heaterId] : PathfinderControlPanel.this.heaterOffRB[heaterId]);
                selButton.setSelected(true);
                this.sLog.info("heater temp - " + this.vs.getHeaterTemp(heaterId));
                PathfinderControlPanel.this.heaterTempTF[heaterId].update((Object)this.vs.getHeaterTemp(heaterId), true);
                PathfinderControlPanel.this.heaterPowerTF[heaterId].update((Object)this.vs.getHeaterPower(heaterId), true);
                PathfinderControlPanel.this.heaterState[heaterId].setEnabled(true);
                PathfinderControlPanel.this.heaterOffRB[heaterId].setEnabled(true);
                PathfinderControlPanel.this.heaterPowerRB[heaterId].setEnabled(true);
                PathfinderControlPanel.this.heaterTempRB[heaterId].setEnabled(true);
            }
            int switches = 0;
            for (int sw = 0; sw < 5; ++sw) {
                Color color;
                String text;
                if (!this.vs.hasSwitch(sw)) continue;
                switches |= 1 << sw;
                SwitchState state2 = this.vs.getSwitchState(sw);
                SwitchEnable enable = this.vs.getSwitchEnable(sw);
                if (enable == SwitchEnable.OFF || enable == SwitchEnable.WAS_OFF) {
                    text = "DISABLED";
                    color = RED;
                    if (sw == 3) {
                        text = "DIS ";
                        if (this.vs.getCondition(14) == ConditionState.YES && this.vs.getCondition(15) == ConditionState.YES) {
                            text = text + "BOTH";
                            color = PURPLE;
                        } else if (this.vs.getCondition(14) != ConditionState.YES && this.vs.getCondition(15) != ConditionState.YES) {
                            text = text + "NONE";
                            color = PURPLE;
                        } else {
                            text = this.vs.getCondition(14) == ConditionState.YES ? text + "OPEN" : text + "SHUT";
                        }
                    }
                } else {
                    DeviceState devState;
                    text = state2.name();
                    Color color2 = state2 == SwitchState.OFF ? Color.black : (color = state2 == SwitchState.ON ? GREEN : BLUE);
                    if (switchTypes[sw] == 1) {
                        if (sw == 3) {
                            if (this.vs.getCondition(14) == ConditionState.YES && this.vs.getCondition(15) == ConditionState.YES) {
                                text = "BOTH";
                                color = PURPLE;
                            } else if (this.vs.getCondition(14) != ConditionState.YES && this.vs.getCondition(15) != ConditionState.YES) {
                                text = "NONE";
                                color = PURPLE;
                            } else {
                                text = this.vs.getCondition(14) == ConditionState.YES ? "OPEN" : "SHUT";
                            }
                        } else {
                            String string = state2 == SwitchState.OFF ? "SHUT" : (text = state2 == SwitchState.ON ? "OPEN" : text);
                        }
                    }
                    if ((devState = this.vs.getDeviceState(sw)) != null && state2 != SwitchState.OFFLINE) {
                        text = devState.name();
                        if (devState == DeviceState.FAILED) {
                            color = RED;
                        }
                    }
                    if (sw == 3) {
                        if (this.vs.getCondition(14) == ConditionState.YES && this.vs.getCondition(15) == ConditionState.YES) {
                            text = text + "BOTH";
                            color = PURPLE;
                        } else if (this.vs.getCondition(14) != ConditionState.YES && this.vs.getCondition(15) != ConditionState.YES) {
                            text = text + "NONE";
                            color = PURPLE;
                        }
                    }
                }
                PathfinderControlPanel.this.switchStatus[sw].setText(text);
                PathfinderControlPanel.this.switchStatus[sw].setForeground(color);
                JRadioButton selButton2 = state2 == SwitchState.ON ? PathfinderControlPanel.this.switchOnRB[sw] : PathfinderControlPanel.this.switchOffRB[sw];
                selButton2.setSelected(true);
                PathfinderControlPanel.this.switchStatus[sw].setEnabled(true);
                PathfinderControlPanel.this.switchOffRB[sw].setEnabled(true);
                PathfinderControlPanel.this.switchOnRB[sw].setEnabled(true);
            }
            if (switches != PathfinderControlPanel.this.switchMask) {
                PathfinderControlPanel.this.updateSwitchLayout(switches);
            }
            int conditions = 0;
            for (cond = 0; cond < 8; ++cond) {
                if (!this.vs.hasLatch(cond)) continue;
                conditions |= 1 << cond;
                state = this.vs.getLatch(cond);
                this.sLog.info("PathfinderControlPanel: cond = " + cond + " name = " + state.name() + " length of latchStatus is " + PathfinderControlPanel.this.latchStatus.length);
                this.sLog.info("PathfinderControlPanel: latchStatus = " + PathfinderControlPanel.this.latchStatus);
                PathfinderControlPanel.this.latchStatus[cond].setText(state.name());
                PathfinderControlPanel.this.latchStatus[cond].setForeground(state == LatchState.OFFLINE ? UiConstants.BLUE : (state == LatchState.CLEAR ? UiConstants.GREEN : (state == LatchState.ACTIVE ? UiConstants.RED : UiConstants.PURPLE)));
                PathfinderControlPanel.this.latchStatus[cond].setEnabled(true);
                PathfinderControlPanel.this.latchResetBtn[cond].setEnabled(true);
            }
            if (conditions != PathfinderControlPanel.this.latchMask) {
                PathfinderControlPanel.this.updateLatchLayout(conditions);
            }
            conditions = 0;
            for (cond = 0; cond < 16; ++cond) {
                if (!this.vs.hasCondition(cond)) continue;
                conditions |= 1 << cond;
                state = this.vs.getCondition(cond);
                PathfinderControlPanel.this.conditionStatus[cond].setText(state.name());
                PathfinderControlPanel.this.conditionStatus[cond].setForeground(state == ConditionState.OFF ? UiConstants.BLUE : (state == ConditionState.NO ? Color.BLACK : UiConstants.GREEN));
                PathfinderControlPanel.this.conditionStatus[cond].setEnabled(true);
            }
            if (conditions != PathfinderControlPanel.this.conditionMask) {
                PathfinderControlPanel.this.updateConditionLayout(conditions);
            }
            this.sLog.info("end VacStatus update");
        }
    }
}

