/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.fpga.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.AbstractVisitor;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Call;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Callable;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Channel;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Clock;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Constant;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Function;
import org.lsst.ccs.subsystem.rafts.fpga.xml.FunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Main;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Parameter;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatFunctionPointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.RepeatSubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Sequencer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Subroutine;
import org.lsst.ccs.subsystem.rafts.fpga.xml.SubroutinePointer;
import org.lsst.ccs.subsystem.rafts.fpga.xml.Timeslice;

class ModelBuilderVisitor
extends AbstractVisitor {
    private final Map<String, String> parms = new HashMap<String, String>();
    private final Map<String, Channel> channels = new HashMap<String, Channel>();
    private final Map<String, Function> functions = new HashMap<String, Function>();
    private final Map<String, Subroutine> subs = new HashMap<String, Subroutine>();
    private final Map<String, Main> mains = new HashMap<String, Main>();
    private final Set<String> used = new HashSet<String>();
    Callable current = null;
    private int nanos;
    int sliceIndex;

    ModelBuilderVisitor() {
    }

    @Override
    public void visit(Sequencer s) {
        super.visit(s);
    }

    @Override
    public void visit(Parameter s) {
        this.parms.put(s.getId(), s.getValue());
    }

    @Override
    public void visit(Channel c) {
        this.channels.put(c.getId(), c);
    }

    @Override
    public void visit(Function f) {
        this.current = f;
        this.used.clear();
        this.nanos = 0;
        this.sliceIndex = 0;
        super.visit(f);
        if (this.channels.size() != this.used.size()) {
            for (Channel c : this.channels.values()) {
                if (this.used.contains(c.getId())) continue;
                Constant cc = new Constant(c, "0");
                f.getConstants().add(cc);
            }
        }
        if (!"Default".equals(f.getId())) {
            List<Timeslice> slices = f.getTimeslices();
            if (slices.size() < 2) {
                throw new RuntimeException("All functions except the default function must have at least two time slices");
            }
            Timeslice firstSlice = slices.get(0);
            if (firstSlice.getDurationNanos() < 10) {
                throw new RuntimeException("First slice in function must be >= 10nS");
            }
            firstSlice.setDurationNanos(firstSlice.getDurationNanos() - 10);
            Timeslice lastSlice = slices.get(slices.size() - 1);
            if (lastSlice.getDurationNanos() < 20) {
                throw new RuntimeException("Last timeslice of a function must be >= 20nS");
            }
            lastSlice.setDurationNanos(lastSlice.getDurationNanos() - 20);
        }
        this.functions.put(f.getId(), f);
        this.current = null;
    }

    @Override
    public void visit(Clock c) {
        if (c.getChannel() == null) {
            throw new RuntimeException("Unknown clock reference in function " + this.current.getId());
        }
        String chanId = c.getChannel().getId();
        if (this.used.contains(chanId)) {
            throw new RuntimeException("Channel " + chanId + " reused for clock in function " + this.current.getId());
        }
        this.used.add(chanId);
    }

    @Override
    public void visit(Constant c) {
        if (c.getChannel() == null) {
            throw new RuntimeException("Unknown constant reference in function " + this.current.getId());
        }
        String chanId = c.getChannel().getId();
        if (this.used.contains(chanId)) {
            throw new RuntimeException("Channel " + chanId + " reused for constant in function " + this.current.getId());
        }
        String value = c.getValue();
        if (!value.equals("0") && !value.equals("1")) {
            throw new RuntimeException("Constant " + chanId + " value (" + value + ") is not 0 or 1 in function " + this.current.getId());
        }
        this.used.add(chanId);
    }

    private static int parseNanos(String s) {
        Pattern p = Pattern.compile("([0-9\\.]+) *([a-z]+)");
        Matcher m = p.matcher(s);
        if (m.matches()) {
            String unit;
            float value = Float.valueOf(m.group(1)).floatValue();
            switch (unit = m.group(2)) {
                case "ns": {
                    return (int)value;
                }
                case "us": 
                case "\u00b5s": {
                    return (int)(value * 1000.0f);
                }
            }
            throw new RuntimeException("Unknown unit " + unit);
        }
        return -1;
    }

    @Override
    public void visit(Timeslice s) {
        if (this.sliceIndex > 15) {
            throw new RuntimeException("Too many time slices, max=16");
        }
        String d = s.getDuration();
        int n = ModelBuilderVisitor.parseNanos(d);
        if (n > 0) {
            s.setDurationNanos(n);
        } else {
            String x = this.parms.get(d);
            if (x != null) {
                n = ModelBuilderVisitor.parseNanos(x);
                if (n >= 0) {
                    s.setDurationNanos(n);
                }
            } else {
                throw new RuntimeException("Cannot interpret duration " + d);
            }
        }
        s.setStartNanos(this.nanos);
        s.setIndex(this.sliceIndex);
        this.nanos += s.getDurationNanos();
        ++this.sliceIndex;
        String pat = s.getValue();
        Function f = (Function)this.current;
        if (pat.length() != f.getClocks().size()) {
            throw new RuntimeException("Bad length for pattern " + pat + " in function " + f.getId());
        }
        for (int i = 0; i < pat.length(); ++i) {
            String digit = pat.substring(i, i + 1);
            if (!digit.equals("0") && !digit.equals("1")) {
                throw new RuntimeException("Pattern digit must be 0 or 1 in function " + f.getId());
            }
            if (!digit.equals("1")) continue;
            s.addUpChannel(f.getClocks().get(i).getChannel());
        }
    }

    @Override
    public void visit(Subroutine s) {
        this.current = s;
        super.visit(s);
        this.subs.put(s.getId(), s);
        this.current = null;
    }

    @Override
    public void visit(Main m) {
        this.current = m;
        super.visit(m);
        this.mains.put(m.getId(), m);
        this.current = null;
    }

    @Override
    public void visit(Call c) {
        super.visit(c);
        String rep = c.getRepeat();
        if (rep == null && c.getRepeatFcnPtr() == null && c.getRepeatSubPtr() == null) {
            c.setInfinity(false);
            c.setRepeatValue(1);
        } else if (rep != null && rep.equals("infinity")) {
            c.setInfinity(true);
            c.setRepeatValue(0x800001);
        } else if (rep != null && rep.matches("[0-9]+")) {
            int n = Integer.parseInt(rep);
            c.setInfinity(false);
            c.setRepeatValue(n);
        } else if (rep != null) {
            String p = this.parms.get(rep);
            if (p == null) {
                throw new RuntimeException("Undefined property " + rep);
            }
            if (!p.matches("[0-9]+")) {
                throw new RuntimeException("Property " + rep + " is not a number: " + p);
            }
            int n = Integer.parseInt(p);
            c.setInfinity(false);
            c.setRepeatValue(n);
        }
    }

    @Override
    public void visit(FunctionPointer fp) {
    }

    @Override
    public void visit(RepeatFunctionPointer rfp) {
    }

    @Override
    public void visit(SubroutinePointer sp) {
    }

    @Override
    public void visit(RepeatSubroutinePointer rsp) {
    }
}

