/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;
import org.lsst.ccs.config.SingleCategoryTag;

public class CategoryDescription
implements Serializable {
    private static final long serialVersionUID = 740497758514140401L;
    private static final Logger LOG = Logger.getLogger(CategoryDescription.class.getName());
    private final String categoryName;
    private final List<SingleCategoryTag> singleTags = new ArrayList<SingleCategoryTag>();
    volatile boolean hasChanges = false;
    @Deprecated
    public static final String DEFAULT_CONFIG_NAME = "";
    public static final String DEFAULT_INITIAL_CONFIG_NAME = "defaultInitial";
    @Deprecated
    public static final String DEFAULT_CAT = "";
    public static final String DEFAULT_V_STRING = "d";
    public static final int DEFAULT_VERSION = -1;
    public static final int LATEST_VERSION = -2;
    public static final int UNDEF_VERSION = -3;
    private static final Pattern CATEGORY_TAG_PATTERN = Pattern.compile("((?<category>[a-zA-Z0-9]+)[:]?)(?<tags>.*?)(?<hasChanged>\\*?)");
    private static final Pattern TAG_PATTERN = Pattern.compile("((?<source>.*?)[/]{1})?(?<tag>[a-zA-Z0-9-]+)([(]{1}?(((?<version>[a-zA-Z0-9]*))[=]?(?<resolvedVersion>.*))[)]{1})?");
    private static final Pattern TAG_SYNTAX = Pattern.compile("^[a-zA-Z0-9-]+$");

    public CategoryDescription(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    @Deprecated
    public boolean containsSingleTag(String tag, String source) {
        return this.containsSingleTag(new SingleCategoryTag(source, tag, this.categoryName));
    }

    public boolean containsSingleTag(SingleCategoryTag singleCategoryTag) {
        return this.singleTags.contains(singleCategoryTag);
    }

    public SingleCategoryTag getSingleTag(SingleCategoryTag singleCategoryTag) {
        if (!this.containsSingleTag(singleCategoryTag)) {
            throw new IllegalArgumentException("Tag " + singleCategoryTag + " does not belong to " + this);
        }
        return this.singleTags.get(this.singleTags.indexOf(singleCategoryTag));
    }

    public String getSingleTagVersion(SingleCategoryTag singleCategoryTag) {
        if (!this.singleTags.contains(singleCategoryTag)) {
            throw new IllegalArgumentException("Sourced tag \"" + singleCategoryTag + "\" does not exist for this CategoryTag");
        }
        return this.singleTags.get(this.singleTags.indexOf(singleCategoryTag)).getVersion();
    }

    public String toString() {
        return this.convertToString(false);
    }

    public int hashCode() {
        int hash = 23;
        hash = 33 * hash + Objects.hashCode(this.singleTags) + 45 * this.categoryName.hashCode() + Objects.hashCode(this.hasChanges);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CategoryDescription other = (CategoryDescription)obj;
        if (this.hasChanges != other.hasChanges) {
            return false;
        }
        if (!this.categoryName.equals(other.categoryName)) {
            return false;
        }
        return this.singleTags.equals(other.singleTags);
    }

    public String convertToString(boolean showDefaultSource) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCategoryName()).append(":");
        int nTags = this.getNumberOfTags();
        for (SingleCategoryTag sourcedTag : this.getSingleCategoryTags()) {
            sb.append(sourcedTag.convertToString(false, showDefaultSource));
            if (--nTags <= 0) continue;
            sb.append("|");
        }
        if (this.hasChanges) {
            sb.append("*");
        }
        return sb.toString();
    }

    public void setHasChanges(boolean hasChanges) {
        this.hasChanges = hasChanges;
    }

    public boolean hasChanges() {
        return this.hasChanges;
    }

    public List<SingleCategoryTag> getSingleCategoryTags() {
        return new ArrayList<SingleCategoryTag>(this.singleTags);
    }

    public SingleCategoryTag getTopMostTag() {
        return this.singleTags.get(this.singleTags.size() - 1);
    }

    public void addOrUpdadateSingleTagVersion(String source, String tag, String version) {
        SingleCategoryTag singleTag = new SingleCategoryTag(source, tag, this.categoryName, version);
        this.addSingleTagVersion(singleTag, version, true);
    }

    public void addOrUpdadateSingleTag(SingleCategoryTag singleCategoryTag) {
        SingleCategoryTag singleTag = new SingleCategoryTag(singleCategoryTag);
        this.addSingleTagVersion(singleTag, singleTag.getResolvedVersion(), true);
    }

    public void addSingleTagVersion(SingleCategoryTag singleTag, String version, boolean update) {
        if (this.singleTags.contains(singleTag) && !update) {
            throw new RuntimeException("Tag: " + singleTag.getTag() + " for source: " + singleTag.getSource() + " already exists for this CategoryTag");
        }
        SingleCategoryTag newTag = new SingleCategoryTag(singleTag, version);
        int ind = this.singleTags.indexOf(newTag);
        if (ind < 0) {
            this.singleTags.add(newTag);
        } else {
            this.singleTags.remove(ind);
            this.singleTags.add(ind, newTag);
        }
    }

    int getNumberOfTags() {
        return this.singleTags.size();
    }

    public CategoryDescription merge(CategoryDescription categoryTag) {
        for (SingleCategoryTag singleTag : categoryTag.getSingleCategoryTags()) {
            this.addSingleTagVersion(singleTag, singleTag.getResolvedVersion(), true);
        }
        return this;
    }

    public static final CategoryDescription parseCategoryTagInput(String categoryTagInput) {
        Matcher m = CATEGORY_TAG_PATTERN.matcher(categoryTagInput = SubstitutionTokenUtils.resolveSubstitutionTokens((String)categoryTagInput));
        if (m.matches()) {
            String cat = m.group("category");
            if (cat == null) {
                throw new IllegalArgumentException("A Catogory must be specified. It cannot be empty.");
            }
            CategoryDescription categoryTag = new CategoryDescription(cat);
            String allTags = m.group("tags");
            if (allTags != null && allTags.endsWith("|")) {
                throw new IllegalArgumentException("Tags cannot be empty, so a list of tags cannot end with \"|\".");
            }
            if (allTags != null) {
                String[] tags = allTags.split("\\|");
                boolean hasChanged = "*".equals(m.group("hasChanged"));
                categoryTag.setHasChanges(hasChanged);
                for (String t : tags) {
                    String resolvedVersion;
                    String ver;
                    String source;
                    String tag;
                    Matcher tagMatcher = TAG_PATTERN.matcher(t);
                    if (tagMatcher.matches()) {
                        String v;
                        tag = tagMatcher.group("tag");
                        if (tag == null) {
                            throw new IllegalArgumentException("A tag cannot be empty: it must be specified.");
                        }
                        if (!tag.isEmpty() && !TAG_SYNTAX.matcher(tag).matches()) {
                            throw new IllegalArgumentException("Illegal syntax for tag: \"" + tag + "\". Only letters and digits are allowed for tag names.");
                        }
                        source = tagMatcher.group("source");
                        if (source == null || source.isEmpty()) {
                            source = SingleCategoryTag.getDefaultSourceForCategory(cat);
                        }
                        ver = v = tagMatcher.group("version");
                        if (v == null || v.isEmpty()) {
                            ver = "";
                        }
                        if ((resolvedVersion = tagMatcher.group("resolvedVersion")) == null || resolvedVersion.isEmpty()) {
                            resolvedVersion = ver;
                        }
                    } else {
                        throw new IllegalArgumentException("Could not match tag: " + t);
                    }
                    categoryTag.addSingleTagVersion(new SingleCategoryTag(source, tag, cat, ver), resolvedVersion, false);
                }
            }
            return categoryTag;
        }
        throw new IllegalArgumentException("Could not parse a CategoryTag from input string: \"" + categoryTagInput + "\"");
    }
}

