/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.MapKey;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataPath;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"agentName", "groupName"})})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="org.lsst.ccs.localdb.statusdb.model.DataGroup")
@NamedQueries(value={@NamedQuery(name="findDataGroup", query="from DataGroup dg where dg.agentName=:agentName and dg.groupName=:groupName", hints={@QueryHint(name="org.hibernate.cacheable", value="true")})})
public class DataGroup
implements Serializable {
    private static final long serialVersionUID = -963831608204511397L;
    private long id;
    private String agentName;
    private String groupName;
    private Map<DataPath, DataDesc> members = new HashMap<DataPath, DataDesc>();

    public DataGroup() {
    }

    public DataGroup(String agentName, String groupName) {
        this.agentName = agentName;
        this.groupName = groupName;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    public long getId() {
        return this.id;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    @ManyToMany(fetch=FetchType.EAGER)
    @MapKey(name="dataPath")
    public Map<DataPath, DataDesc> getMembers() {
        return this.members;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setMembers(Map<DataPath, DataDesc> members) {
        this.members = members;
    }

    public void addMember(DataDesc dd) {
        this.members.put(dd.getDataPath(), dd);
    }
}

