/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.zip.CRC32;
import org.lsst.ccs.drivers.reb.sim.AutoCloseableReentrantLock;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulation;

public class SequencerListener
implements SequencerSimulation.SubroutineListener,
SequencerSimulation.FunctionListener,
SequencerSimulation.WaveformListener,
SequencerSimulation.StateListener {
    private final CountMap subroutineCounts = new CountMap();
    private final CountMap functionCounts = new CountMap();
    private final CountMap subroutineReturns = new CountMap();
    private long accumulatedNanos;
    private final CRC32 checksum = new CRC32();
    private final AutoCloseableReentrantLock stateLock = new AutoCloseableReentrantLock();
    private final Condition stateChanged = this.stateLock.newCondition();
    private volatile SequencerSimulation.State currentState;

    @Override
    public void subroutineCalled(int address, int repetitions) {
        this.subroutineCounts.get(address).add(repetitions);
    }

    @Override
    public void subroutineReturned(int address) {
        this.subroutineReturns.get(address).increment();
    }

    @Override
    public void functionCalled(int function, boolean infiniteLoop, int repetitions) {
        this.functionCounts.get(function).add(repetitions);
    }

    /*
     * Exception decompiling
     */
    public void waitForState(SequencerSimulation.State state, Duration timeout) throws InterruptedException, TimeoutException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void stateChanged(SequencerSimulation.State oldState, SequencerSimulation.State newState) {
        try (AutoCloseableReentrantLock lock = this.stateLock.open();){
            this.currentState = newState;
            this.stateChanged.signalAll();
        }
    }

    public Map<? extends Number, ? extends Number> getSubroutineCounts() {
        return this.subroutineCounts;
    }

    public Map<? extends Number, ? extends Number> getFunctionCounts() {
        return this.functionCounts;
    }

    public Map<? extends Number, ? extends Number> getSubroutineReturns() {
        return this.subroutineReturns;
    }

    @Override
    public void transition(int oldState, int newState, int nanos) {
        this.accumulatedNanos += (long)nanos;
        this.checksum.update(newState);
    }

    public long getAccumulatedNanos() {
        return this.accumulatedNanos;
    }

    public long getChecksum() {
        return this.checksum.getValue();
    }

    public void clear() {
        this.subroutineCounts.clear();
        this.functionCounts.clear();
        this.subroutineReturns.clear();
        this.accumulatedNanos = 0L;
        this.checksum.reset();
    }

    private static class CountMap
    extends ConcurrentHashMap<Integer, Count> {
        private CountMap() {
        }

        @Override
        public Count get(Object key) {
            Count result = (Count)super.get(key);
            if (result == null && key instanceof Integer) {
                result = new Count();
                this.put((Integer)key, result);
            }
            return result;
        }
    }

    private static class Count
    extends Number {
        private int count;

        private Count() {
        }

        void add(int n) {
            this.count += n;
        }

        void increment() {
            ++this.count;
        }

        public String toString() {
            return String.valueOf(this.count);
        }

        @Override
        public int intValue() {
            return this.count;
        }

        @Override
        public long longValue() {
            return this.count;
        }

        @Override
        public float floatValue() {
            return this.count;
        }

        @Override
        public double doubleValue() {
            return this.count;
        }
    }
}

