/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.ClientFactorySimulation;

class HandleAndIdManager {
    private static final BitSet HANDLES_IN_USE = new BitSet();
    private static final Map<Integer, AddressSpace> ID_TO_REGISTER_SET;
    private static final Map<Long, AddressSpace> HANDLE_TO_REGISTER_SET;
    private final ClientFactorySimulation factory;

    HandleAndIdManager(ClientFactorySimulation factory) {
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AddressSpace getAddressSpaceForId(int id) {
        Map<Integer, AddressSpace> map = ID_TO_REGISTER_SET;
        synchronized (map) {
            AddressSpace rs = ID_TO_REGISTER_SET.get(id);
            if (rs == null) {
                rs = this.factory.createREBSimulation(id);
                ID_TO_REGISTER_SET.put(id, rs);
            }
            return rs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AddressSpace getAddressSpaceForHandle(long handle) {
        Map<Long, AddressSpace> map = HANDLE_TO_REGISTER_SET;
        synchronized (map) {
            return HANDLE_TO_REGISTER_SET.get(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long allocateHandle(AddressSpace rs) {
        BitSet bitSet = HANDLES_IN_USE;
        synchronized (bitSet) {
            long handle = HANDLES_IN_USE.nextClearBit(0);
            HANDLES_IN_USE.set((int)handle);
            HANDLE_TO_REGISTER_SET.put(handle, rs);
            return handle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeHandle(long handle) {
        BitSet bitSet = HANDLES_IN_USE;
        synchronized (bitSet) {
            HANDLES_IN_USE.clear((int)handle);
            HANDLE_TO_REGISTER_SET.remove(handle);
        }
    }

    static {
        HANDLES_IN_USE.set(0);
        ID_TO_REGISTER_SET = new HashMap<Integer, AddressSpace>();
        HANDLE_TO_REGISTER_SET = Collections.synchronizedMap(new HashMap());
    }
}

