/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.extensions.jconsole;

import java.awt.Component;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageEvent;
import org.freehep.application.mdi.PageListener;
import org.freehep.application.studio.Plugin;
import org.freehep.jas.extensions.jconsole.JConsole;
import org.freehep.jas.extensions.jconsole.JConsoleProvider;
import org.freehep.jas.extensions.jconsole.JConsoleService;
import org.freehep.jas.extensions.jconsole.JLineConsole;
import org.freehep.jas.extensions.jconsole.JLineConsoleProvider;
import org.freehep.jas.extensions.jconsole.SwingConsole;
import org.freehep.jas.extensions.jconsole.SwingConsoleProvider;
import org.freehep.jas.plugin.console.Console;
import org.freehep.swing.popup.HasPopupItems;

public class JConsolePlugin
extends Plugin
implements JConsoleService,
PageListener {
    private final Map<Class, JConsoleProvider> _providers = Collections.synchronizedMap(new HashMap(3));
    private final ConcurrentHashMap<String, JConsole> _name2console = new ConcurrentHashMap();
    private final Map<PageContext, JConsole> _context2console = Collections.synchronizedMap(new IdentityHashMap(4));

    protected void init() throws Throwable {
        this.getApplication().getLookup().add((Object)this);
        this.getApplication().getConsoleManager().addPageListener((PageListener)this);
    }

    protected void postInit() {
        this.addConsoleProvider(SwingConsole.class, new SwingConsoleProvider());
        this.addConsoleProvider(JLineConsole.class, new JLineConsoleProvider());
    }

    @Override
    public void addConsoleProvider(Class consoleType, JConsoleProvider provider) {
        this._providers.put(consoleType, provider);
    }

    @Override
    public JConsole getConsole(String name) {
        return this._name2console.get(name);
    }

    @Override
    public JConsole createConsole(Class type, String name, Icon icon, HasPopupItems popupItems) {
        JConsoleProvider provider = this._providers.get(type);
        if (provider == null) {
            throw new IllegalArgumentException("No console provider for type " + type.getName());
        }
        JConsole console = provider.createConsole(name, popupItems);
        this._name2console.putIfAbsent(name, console);
        int vPolicy = console.getVerticalScrollBarPolicy();
        int hPolicy = console.getHorizontalScrollBarPolicy();
        Component panel = vPolicy == 21 && hPolicy == 31 ? console.getView() : new JScrollPane(console.getView(), vPolicy, hPolicy);
        PageContext context = this.getApplication().getConsoleManager().openPage(panel, name, icon, name, false);
        this._context2console.put(context, console);
        return console;
    }

    @Override
    public void showConsole(Console console) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PageContext getPageContextForConsole(JConsole console) {
        Map<PageContext, JConsole> map = this._context2console;
        synchronized (map) {
            for (Map.Entry<PageContext, JConsole> e : this._context2console.entrySet()) {
                if (console != e.getValue()) continue;
                return e.getKey();
            }
        }
        return null;
    }

    public void pageChanged(PageEvent e) {
        JConsole console;
        if (e.getID() == 4001 && (console = this._context2console.remove(e.getPageContext())) != null) {
            this._name2console.remove(console.getName(), console);
            console.dispose();
        }
    }
}

