/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannelMulti;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.persist.Persistable;

public abstract class AbstractMonitorView
implements PersistableMonitorView {
    protected PersistableAgentChannelsFilter filter;
    protected MonitorFormat formatter;
    protected List<MonitorField> fields;
    protected List<MonitorField> compactFields;
    protected final LinkedHashMap<String, DisplayChannel> data = new LinkedHashMap();
    private volatile boolean discardRemovedChannels = false;
    private ArrayList<String> disconnectedAgents;

    public void setDiscardRemovedChannels(boolean discardRemovedChannels) {
        this.discardRemovedChannels = discardRemovedChannels;
    }

    @Override
    public void connect(AgentStatusEvent event) {
    }

    @Override
    public void configure(AgentStatusEvent event) {
        if (!event.isEmpty()) {
            SwingUtilities.invokeLater(() -> this.onConnect(event));
        }
    }

    @Override
    public void statusChanged(AgentStatusEvent event) {
        if (!event.isEmpty()) {
            SwingUtilities.invokeLater(() -> this.onChange(event));
        }
    }

    @Override
    public void disconnect(AgentStatusEvent event) {
        if (!event.isEmpty()) {
            SwingUtilities.invokeLater(() -> this.onDisconnect(event));
        }
    }

    private void onConnect(AgentStatusEvent event) {
        List<AgentInfo> agents = event.getAgents();
        List<Map.Entry<String, AgentChannel>> channels = event.getAddedChannels().stream().flatMap(channel -> this.filter.getDisplayPaths((AgentChannel)channel).stream().map(displayPath -> new AbstractMap.SimpleEntry<String, AgentChannel>((String)displayPath, (AgentChannel)channel))).collect(Collectors.toList());
        this.addChannels(agents, channels);
    }

    private void onChange(AgentStatusEvent event) {
        List<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>> channels = event.getStatusChanges().entrySet().stream().flatMap(e -> this.filter.getDisplayPaths((AgentChannel)e.getKey()).stream().map(displayPath -> new AbstractMap.SimpleEntry<String, Map.Entry>((String)displayPath, (Map.Entry)e))).collect(Collectors.toList());
        this.updateChannels(channels);
    }

    private void onDisconnect(AgentStatusEvent event) {
        List<AgentInfo> agents = event.getAgents();
        List<Map.Entry<String, AgentChannel>> channels = event.getRemovedChannels().stream().flatMap(channel -> this.filter.getDisplayPaths((AgentChannel)channel).stream().map(displayPath -> new AbstractMap.SimpleEntry<String, AgentChannel>((String)displayPath, (AgentChannel)channel))).collect(Collectors.toList());
        this.removeChannels(agents, channels);
    }

    public void addChannels(List<AgentInfo> agents, List<Map.Entry<String, AgentChannel>> channels) {
        boolean needReset = false;
        LinkedHashSet<Object> updatedChannels = new LinkedHashSet();
        if (!this.discardRemovedChannels) {
            updatedChannels = this.doRemove(agents.stream().map(a -> a.getName()).collect(Collectors.toList()), false);
        }
        for (Map.Entry<String, AgentChannel> e : channels) {
            String string = e.getKey();
            AgentChannel c = e.getValue();
            DisplayChannel dc = this.data.get(string);
            if (dc == null) {
                dc = this.createChannel(string);
                this.data.put(string, dc);
                needReset = true;
            } else {
                updatedChannels.add(dc);
            }
            dc.appendChannel(c);
        }
        Iterator it = updatedChannels.iterator();
        while (it.hasNext()) {
            DisplayChannel dc = (DisplayChannel)it.next();
            if (!dc.getChannels().isEmpty()) continue;
            this.data.remove(dc.getPath());
            it.remove();
            needReset = true;
        }
        if (needReset) {
            this.resetChannels();
        } else {
            for (DisplayChannel displayChannel : updatedChannels) {
                displayChannel.update(null);
            }
            this.update();
        }
    }

    public void updateChannels(List<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>> channels) {
        this.doUpdate(channels);
    }

    public void removeChannels(List<AgentInfo> agents, List<Map.Entry<String, AgentChannel>> channels) {
        List<String> agentNames = agents.stream().map(a -> a.getName()).collect(Collectors.toList());
        if (this.discardRemovedChannels) {
            if (!this.doRemove(agentNames, true).isEmpty()) {
                this.resetChannels();
            } else {
                this.update();
            }
        } else {
            if (this.disconnectedAgents == null) {
                this.disconnectedAgents = new ArrayList<String>(agentNames);
            } else {
                this.disconnectedAgents.addAll(agentNames);
            }
            this.doUpdate(channels.stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), new AbstractMap.SimpleEntry(e.getValue(), null))).collect(Collectors.toList()));
        }
    }

    private LinkedHashSet<DisplayChannel> doRemove(List<String> agents, boolean purge) {
        LinkedHashSet<DisplayChannel> out = new LinkedHashSet<DisplayChannel>(this.data.size() * 2);
        Iterator<Map.Entry<String, DisplayChannel>> it = this.data.entrySet().iterator();
        while (it.hasNext()) {
            DisplayChannel dc = it.next().getValue();
            List<AgentChannel> oldChannels = dc.getChannels();
            if (!oldChannels.stream().anyMatch(a -> agents.contains(a.getAgentName()))) continue;
            ArrayList<AgentChannel> newChannels = new ArrayList<AgentChannel>(oldChannels.size());
            for (AgentChannel c : oldChannels) {
                if (agents.contains(c.getAgentName())) continue;
                newChannels.add(c);
            }
            dc.setChannels(newChannels);
            if (newChannels.isEmpty()) {
                out.add(dc);
                if (!purge) continue;
                it.remove();
                continue;
            }
            if (!purge) continue;
            dc.update(null);
        }
        return out;
    }

    private void doUpdate(List<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>> channels) {
        if (channels == null) {
            this.data.values().forEach(dc -> dc.update(null));
        } else {
            for (Map.Entry<String, Map.Entry<AgentChannel, List<String>>> e : channels) {
                String displayPath = e.getKey();
                DisplayChannel dc2 = this.data.get(displayPath);
                List<String> attributes = e.getValue().getValue();
                if (dc2 == null) continue;
                dc2.update(attributes);
            }
        }
        this.update();
    }

    protected void resetChannels() {
    }

    protected void update() {
    }

    protected DisplayChannel createChannel(String displayPath) {
        return new DisplayChannelMulti(displayPath);
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public String getGroup(String displayPath) {
        int i = displayPath.lastIndexOf("/");
        return displayPath.substring(i + 1);
    }

    public List<String> getGroups() {
        List<String> channels;
        ArrayList out = null;
        PersistableAgentChannelsFilter f = this.getFilter();
        if (f != null && (channels = f.getDisplayChannels()) != null) {
            LinkedHashSet groups = new LinkedHashSet();
            channels.forEach(displayPath -> {
                String group = this.getGroup((String)displayPath);
                if (group != null) {
                    groups.add(group);
                }
            });
            out = new ArrayList(groups);
        }
        if (out == null) {
            LinkedHashSet groups = new LinkedHashSet();
            this.data.keySet().forEach(displayPath -> {
                String group = this.getGroup((String)displayPath);
                if (group != null) {
                    groups.add(group);
                }
            });
            return new ArrayList<String>(groups);
        }
        return out;
    }

    @Override
    public PersistableAgentChannelsFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(AgentChannelsFilter filter) {
        if (!(filter instanceof PersistableAgentChannelsFilter)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only accepts AbstractChannelsFilter filters");
        }
        this.filter = (PersistableAgentChannelsFilter)filter;
        Descriptor desc = this.getDescriptor();
        String[] ss = desc == null ? null : desc.getCompactFields();
        List<String> ff = ss == null ? filter.getFields(true) : Arrays.asList(ss);
        this.compactFields = ff == null ? MonitorTable.DEFAULT_COMPACT_FIELDS : ff.stream().map(f -> MonitorField.getInstance(f)).filter(mf -> mf != null).collect(Collectors.toList());
        ss = desc == null ? null : desc.getFields();
        ff = ss == null ? filter.getFields(false) : Arrays.asList(ss);
        this.fields = ff == null ? MonitorTable.DEFAULT_FIELDS : ff.stream().map(f -> MonitorField.getInstance(f)).filter(mf -> mf != null).collect(Collectors.toList());
    }

    @Override
    public MonitorFormat getFormater() {
        return this.formatter;
    }

    @Override
    public void setFormatter(MonitorFormat formatter) {
        this.formatter = formatter;
    }

    public List<MonitorField> getGroupFields() {
        PersistableAgentChannelsFilter f = this.getFilter();
        if (f == null) {
            return null;
        }
        List<String> channels = f.getDisplayChannels();
        if (channels == null) {
            return null;
        }
        List<String> fields = f.getFields(true);
        if (fields == null || fields.size() != channels.size()) {
            return null;
        }
        return fields.stream().map(s -> MonitorField.stringToField(s)).collect(Collectors.toList());
    }

    @Override
    public abstract Descriptor getDescriptor();

    @Override
    public Descriptor save() {
        return (Descriptor)PersistableMonitorView.super.save();
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private String[] fields;
        private String[] compactFields;

        public String[] getCompactFields() {
            return this.compactFields;
        }

        public void setCompactFields(String[] compactFields) {
            this.compactFields = compactFields;
        }

        public String[] getFields() {
            return this.fields;
        }

        public void setFields(String[] fields) {
            this.fields = fields;
        }

        @Override
        public Descriptor clone() {
            return (Descriptor)super.clone();
        }
    }
}

