/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.Set;
import org.lsst.ccs.Agent;
import org.lsst.ccs.BootUtils;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bootstrap.SubstitutionTokenUtils;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.SignalHandler;

public class ScanGroovyFiles {
    public static void main(String[] args) throws Exception {
        Set groovyFiles = BootstrapResourceUtils.findMatchingResources((String)".*.groovy");
        int total = groovyFiles.size();
        int counter = 0;
        for (String groovyFile : groovyFiles) {
            ++counter;
            SingleCategoryTag.resetDefaultSources();
            SubstitutionTokenUtils.resetSubstitutionTokens();
            try {
                boolean isSignalHandler;
                boolean isAgentOrSubsystem;
                System.out.println("WORKING ON " + groovyFile + " " + counter + "/" + total);
                ComponentLookup lookup = BootUtils.buildComponentLookupFromDescription(groovyFile.replace(".groovy", ""), null, null);
                ComponentNode top = lookup.getTopComponentNode();
                String nodeKey = top.getKey();
                Object obj = top.getComponent();
                boolean bl = isAgentOrSubsystem = obj instanceof Agent || obj instanceof Subsystem;
                if (nodeKey.equals("main") && !isAgentOrSubsystem) {
                    System.out.println("******* PROBLEM FOR  key: " + nodeKey + " " + isAgentOrSubsystem + " " + obj);
                }
                if (isSignalHandler = obj instanceof SignalHandler) {
                    System.out.println("***** SIGNAL HANDLER: " + nodeKey + " " + obj + " " + isAgentOrSubsystem);
                }
                Subsystem s = BootUtils.getSubsystemFromLookup(lookup, "abc");
                s.shutdownAgent();
            }
            catch (Error | Exception e) {
                System.out.println("Problem building " + groovyFile + "\n" + e.getMessage());
                e.printStackTrace();
            }
        }
        System.exit(0);
    }
}

