/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.stat.EntityStatistics;
import org.hibernate.stat.NaturalIdCacheStatistics;
import org.hibernate.stat.QueryStatistics;
import org.hibernate.stat.SecondLevelCacheStatistics;
import org.hibernate.stat.Statistics;
import org.influxdb.dto.Point;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.services.InfluxDbClientService;

public class CacheStatistics {
    private static final Logger LOG = Logger.getLogger(CacheStatistics.class.getName());
    private final KeyValueDataList dataList = new KeyValueDataList("statistics");
    private static final String[] NAMED_QUERIES = new String[]{"findAlertDesc", "findInnerStateDesc", "findDataDesc", "findStatData", "findStatDesc", "findDataGroup", "findStateBundleDesc"};

    public CacheStatistics(SessionFactory fac) {
        this(fac, null);
    }

    public CacheStatistics(SessionFactory fac, InfluxDbClientService influxDb) {
        Statistics stats = fac.getStatistics();
        try (Session sess = fac.openSession();){
            String entitiesPath;
            String shortName;
            Point point;
            for (String query : NAMED_QUERIES) {
                QueryStatistics queryStats = stats.getQueryStatistics(sess.getNamedQuery(query).getQueryString());
                if (influxDb != null) {
                    Point.Builder namedQueriesPointBuilder = Point.measurement((String)"db_named_queries").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    namedQueriesPointBuilder = namedQueriesPointBuilder.addField("cache_hit", queryStats.getCacheHitCount()).addField("cache_miss", queryStats.getCacheMissCount()).addField("cache_put", queryStats.getCachePutCount()).addField("exec_time_avg", queryStats.getExecutionAvgTime()).addField("exec_time_max", queryStats.getExecutionMaxTime()).addField("exec_time_min", queryStats.getExecutionMinTime()).addField("exec_count", queryStats.getExecutionCount()).addField("exec_row_count", queryStats.getExecutionRowCount());
                    Point point2 = namedQueriesPointBuilder.tag("query_name", query).tag(influxDb.getGlobalTags()).build();
                    influxDb.getInfluxDbClient().write(point2);
                    continue;
                }
                String queryPath = "statistics/queries/" + query + "/";
                this.dataList.addData(queryPath + "hit", (Serializable)Long.valueOf(queryStats.getCacheHitCount()));
                this.dataList.addData(queryPath + "miss", (Serializable)Long.valueOf(queryStats.getCacheMissCount()));
                this.dataList.addData(queryPath + "put", (Serializable)Long.valueOf(queryStats.getCachePutCount()));
                this.dataList.addData(queryPath + "avgExec", (Serializable)Long.valueOf(queryStats.getExecutionAvgTime()));
            }
            for (String slcName : stats.getSecondLevelCacheRegionNames()) {
                if (!slcName.startsWith("org.lsst.ccs")) continue;
                SecondLevelCacheStatistics slcStats = stats.getSecondLevelCacheStatistics(slcName);
                String shortName2 = slcName.substring(slcName.lastIndexOf(".") + 1);
                if (influxDb != null) {
                    Point.Builder secondLevelCachePointBuilder = Point.measurement((String)"db_second_level_cache").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    secondLevelCachePointBuilder = secondLevelCachePointBuilder.addField("cache_hit", slcStats.getHitCount()).addField("cache_miss", slcStats.getMissCount()).addField("cache_put", slcStats.getPutCount());
                    point = secondLevelCachePointBuilder.tag("class_name", shortName2).tag(influxDb.getGlobalTags()).build();
                    influxDb.getInfluxDbClient().write(point);
                    continue;
                }
                String slcPath = "statistics/slc/" + shortName2 + "/";
                this.dataList.addData(slcPath + "count", (Serializable)Long.valueOf(slcStats.getElementCountInMemory()));
                this.dataList.addData(slcPath + "hit", (Serializable)Long.valueOf(slcStats.getHitCount()));
                this.dataList.addData(slcPath + "miss", (Serializable)Long.valueOf(slcStats.getMissCount()));
                this.dataList.addData(slcPath + "put", (Serializable)Long.valueOf(slcStats.getPutCount()));
            }
            for (String entityName : stats.getEntityNames()) {
                if (!entityName.startsWith("org.lsst.ccs")) continue;
                shortName = entityName.substring(entityName.lastIndexOf(".") + 1);
                EntityStatistics entityStats = stats.getEntityStatistics(entityName);
                if (influxDb != null) {
                    Point.Builder cachedEntitiesPointBuilder = Point.measurement((String)"db_cached_entities").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    cachedEntitiesPointBuilder = cachedEntitiesPointBuilder.addField("delete", entityStats.getDeleteCount()).addField("fetch", entityStats.getFetchCount()).addField("insert", entityStats.getInsertCount()).addField("load", entityStats.getLoadCount()).addField("failure", entityStats.getOptimisticFailureCount()).addField("update", entityStats.getUpdateCount());
                    point = cachedEntitiesPointBuilder.tag("class_name", shortName).tag(influxDb.getGlobalTags()).build();
                    influxDb.getInfluxDbClient().write(point);
                    continue;
                }
                entitiesPath = "statistics/entities/" + shortName + "/";
                this.dataList.addData(entitiesPath + "load", (Serializable)Long.valueOf(entityStats.getLoadCount()));
                this.dataList.addData(entitiesPath + "fetch", (Serializable)Long.valueOf(entityStats.getFetchCount()));
            }
            for (String entityName : stats.getEntityNames()) {
                if (!entityName.startsWith("org.lsst.ccs") || !entityName.endsWith("##NaturalId")) continue;
                shortName = entityName.substring(entityName.lastIndexOf(".") + 1).replace("##NaturalId", "");
                NaturalIdCacheStatistics natIdStats = stats.getNaturalIdCacheStatistics(entityName);
                if (influxDb != null) {
                    Point.Builder naturalIdPointBuilder = Point.measurement((String)"db_natural_id").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                    naturalIdPointBuilder = naturalIdPointBuilder.addField("hit", natIdStats.getHitCount()).addField("miss", natIdStats.getMissCount()).addField("put", natIdStats.getPutCount()).addField("count_mem", natIdStats.getElementCountInMemory());
                    point = naturalIdPointBuilder.tag("class_name", shortName).tag(influxDb.getGlobalTags()).build();
                    influxDb.getInfluxDbClient().write(point);
                    continue;
                }
                entitiesPath = "statistics/naturalId/" + shortName + "/";
                this.dataList.addData(entitiesPath + "hit", (Serializable)Long.valueOf(natIdStats.getHitCount()));
                this.dataList.addData(entitiesPath + "miss", (Serializable)Long.valueOf(natIdStats.getMissCount()));
                this.dataList.addData(entitiesPath + "put", (Serializable)Long.valueOf(natIdStats.getPutCount()));
                this.dataList.addData(entitiesPath + "count", (Serializable)Long.valueOf(natIdStats.getElementCountInMemory()));
            }
            if (influxDb != null) {
                Point.Builder sessionPointBuilder = Point.measurement((String)"db_session").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                sessionPointBuilder = sessionPointBuilder.addField("connect", stats.getConnectCount()).addField("flush", stats.getFlushCount()).addField("sess_open", stats.getSessionOpenCount()).addField("sess_close", stats.getSessionCloseCount()).addField("transact", stats.getTransactionCount()).addField("transact_success", stats.getSuccessfulTransactionCount());
                Point point3 = sessionPointBuilder.tag(influxDb.getGlobalTags()).build();
                influxDb.getInfluxDbClient().write(point3);
            } else {
                this.dataList.addData("statistics/sessionStats/connectCount", (Serializable)Long.valueOf(stats.getConnectCount()));
                this.dataList.addData("statistics/sessionStats/flushCount", (Serializable)Long.valueOf(stats.getFlushCount()));
                this.dataList.addData("statistics/sessionStats/sessionOpenCount", (Serializable)Long.valueOf(stats.getSessionOpenCount()));
                this.dataList.addData("statistics/sessionStats/sessionCloseCount", (Serializable)Long.valueOf(stats.getSessionCloseCount()));
                this.dataList.addData("statistics/sessionStats/transactionCount", (Serializable)Long.valueOf(stats.getTransactionCount()));
                this.dataList.addData("statistics/sessionStats/successfulTransactionCount", (Serializable)Long.valueOf(stats.getSuccessfulTransactionCount()));
            }
            stats.clear();
        }
    }

    public KeyValueDataList getStatData() {
        return this.dataList;
    }
}

