/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.resource.transaction.spi.TransactionStatus;
import org.influxdb.dto.Point;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.LocalDBAlert;
import org.lsst.ccs.localdb.statusdb.StatusDataPersister;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.services.InfluxDbClientService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class BatchPersister<T>
implements Runnable,
HasLifecycle {
    protected final Logger log = Logger.getLogger((String)this.getClass().getCanonicalName());
    @LookupName
    private String persisterName;
    private final int nMax;
    private final boolean flushAtCommit;
    private final Queue<T> rq = new ConcurrentLinkedQueue<T>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent a;
    @LookupField(strategy=LookupField.Strategy.TREE)
    StatusDataPersister statusDataPersister;
    @LookupField(strategy=LookupField.Strategy.TREE)
    InfluxDbClientService influxDbClientService;
    private int nThreads = 1;
    private final ExecutorService exec;
    private static final int maximumTasksPerThread = 100;
    private volatile AlertState batchSubmissionAlertState = AlertState.NOMINAL;

    public static ExecutorService newFixedThreadPoolBoundedQueue(int nThreads, int nQueue) {
        LinkedBlockingQueue<Runnable> queue = nQueue > 0 ? new LinkedBlockingQueue<Runnable>(nQueue) : new LinkedBlockingQueue();
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, queue);
    }

    public BatchPersister(int nMax, boolean flushAtCommit, int threads, int threadQueueSize) {
        this.nMax = nMax;
        this.flushAtCommit = flushAtCommit;
        this.nThreads = threads;
        this.exec = BatchPersister.newFixedThreadPoolBoundedQueue(this.nThreads, threadQueueSize);
    }

    public BatchPersister(int nMax, boolean flushAtCommit, int threads) {
        this(nMax, flushAtCommit, threads, 100 * threads);
    }

    public BatchPersister(int nMax, boolean flushAtCommit) {
        this(nMax, flushAtCommit, 1);
    }

    public void init() {
        ClearAlertHandler alwaysClear = new ClearAlertHandler(){

            public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
                return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
            }
        };
        this.alertService.registerAlert(LocalDBAlert.BatchException.getAlert(this.persisterName, null), alwaysClear);
        this.alertService.registerAlert(LocalDBAlert.BatchRollbackException.getAlert(this.persisterName, null), alwaysClear);
        this.alertService.registerAlert(LocalDBAlert.BatchIngestionQueueSize.getAlert(this.persisterName, null), alwaysClear);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistBatch(List<T> batch) {
        this.log.debug((Object)(this.persisterName + " start batch " + this.getClass().getName() + " " + this + " " + batch.size()));
        long tstart = System.currentTimeMillis();
        Session sess = StatusdbUtils.getSessionFactory().openSession();
        if (this.flushAtCommit) {
            sess.setFlushMode(FlushMode.COMMIT);
        }
        Transaction tx = null;
        try {
            tx = sess.beginTransaction();
            for (T t : batch) {
                this.persist(t, sess);
            }
            tx.commit();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, this.persisterName + " caught exception when persisting", (Throwable)ex);
            this.alertService.raiseAlert(LocalDBAlert.BatchException.getAlert(this.persisterName, ex), AlertState.WARNING, LocalDBAlert.getFirstException(ex));
            try {
                if (tx != null && (tx.getStatus() == TransactionStatus.ACTIVE || tx.getStatus() == TransactionStatus.MARKED_ROLLBACK)) {
                    tx.rollback();
                }
            }
            catch (Exception rbEx) {
                this.log.error((Object)(this.persisterName + " Rollback of transaction failed : " + rbEx), (Throwable)rbEx);
                this.alertService.raiseAlert(LocalDBAlert.BatchRollbackException.getAlert(this.persisterName, ex), AlertState.WARNING, LocalDBAlert.getFirstException(ex));
            }
        }
        finally {
            if (sess.isOpen()) {
                sess.close();
            }
        }
        long time = System.currentTimeMillis() - tstart;
        if (this.influxDbClientService != null) {
            Point.Builder batchPersisterPointBuilder = Point.measurement((String)"db_persist").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            batchPersisterPointBuilder = batchPersisterPointBuilder.addField("btime_tot", time).addField("bcount", (long)batch.size()).addField("btime_avg", (double)time / (double)batch.size());
            Point point = batchPersisterPointBuilder.tag("persister", this.persisterName).tag(this.influxDbClientService.getGlobalTags()).build();
            this.influxDbClientService.getInfluxDbClient().write(point);
        } else {
            KeyValueDataList kvdl = new KeyValueDataList(this.persisterName);
            kvdl.addData(this.persisterName + "/transactionTime", (Serializable)Long.valueOf(time));
            kvdl.addData(this.persisterName + "/batchSize", (Serializable)Integer.valueOf(batch.size()));
            kvdl.addData(this.persisterName + "/entityAverageTime", (Serializable)Double.valueOf((double)time / (double)batch.size()));
            this.statusDataPersister.processEncodedData(this.a.getName(), kvdl);
        }
        this.log.debug((Object)(this.persisterName + " end batch "));
    }

    @Override
    public void run() {
        this.log.fine((Object)(this.persisterName + " start run " + this.rq.size()));
        int n = 0;
        int nAcc = 0;
        boolean done = false;
        long tstart = System.currentTimeMillis();
        int queueAtStart = this.rq.size();
        int tasksAtStart = ((ThreadPoolExecutor)this.exec).getQueue().size();
        int nbatch = 0;
        while (!done) {
            ArrayList<T> batch = new ArrayList<T>(this.nMax);
            int i = 0;
            while (i < this.nMax) {
                T t = this.rq.poll();
                n = i++;
                if (t == null) {
                    done = i == 0;
                    break;
                }
                batch.add(t);
            }
            if (batch.size() > 0) {
                String cause;
                Alert batchSubmissionAlert = LocalDBAlert.BatchIngestionQueueSize.getAlert(this.persisterName, null);
                try {
                    this.exec.submit(() -> this.persistBatch(batch));
                    int taskSubmissionQueueSize = ((ThreadPoolExecutor)this.exec).getQueue().size();
                    if (taskSubmissionQueueSize > this.nThreads * 100 / 2) {
                        cause = null;
                        if (this.batchSubmissionAlertState == AlertState.NOMINAL) {
                            cause = "The submission queue is filling up. Ingestion is falling behind.\n";
                        } else if (this.batchSubmissionAlertState == AlertState.ALARM && taskSubmissionQueueSize < 3 * this.nThreads * 100 / 4) {
                            cause = "The submission queue is being drained. Ingestion is catching up.\n";
                        }
                        if (cause != null) {
                            cause = cause + "Executor task queue size: " + taskSubmissionQueueSize + " (nThreads=" + this.nThreads + ")";
                            this.batchSubmissionAlertState = AlertState.WARNING;
                            this.alertService.raiseAlert(batchSubmissionAlert, this.batchSubmissionAlertState, cause);
                        }
                    } else if (taskSubmissionQueueSize < this.nThreads * 100 / 8 && this.batchSubmissionAlertState != AlertState.NOMINAL) {
                        cause = "Ingestion is caught up.\n";
                        cause = cause + "Executor task queue size: " + taskSubmissionQueueSize + " (nThreads=" + this.nThreads + ")";
                        this.batchSubmissionAlertState = AlertState.NOMINAL;
                        this.alertService.raiseAlert(batchSubmissionAlert, this.batchSubmissionAlertState, cause);
                    }
                }
                catch (RejectedExecutionException e) {
                    if (this.batchSubmissionAlertState != AlertState.ALARM) {
                        cause = "Failed to submit a new task. Ingestion is all filled up. \nExecutor task queue size " + ((ThreadPoolExecutor)this.exec).getQueue().size();
                        this.batchSubmissionAlertState = AlertState.ALARM;
                        this.alertService.raiseAlert(batchSubmissionAlert, this.batchSubmissionAlertState, cause);
                    }
                    this.rq.addAll(batch);
                }
                ++nbatch;
                boolean bl = done = this.rq.size() < this.nMax / 5;
                if (done) {
                    this.log.fine((Object)(this.persisterName + " run done, left in queue " + this.rq.size()));
                }
            }
            if (n <= 0) continue;
            nAcc += n;
            this.log.debug((Object)(this.persisterName + " processed " + n + " entities."));
        }
        if (nAcc > 0) {
            long time = System.currentTimeMillis() - tstart;
            if (this.influxDbClientService != null) {
                Point.Builder batchPersisterPointBuilder = Point.measurement((String)"db_persist").time(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                int submissionQueueSize = ((ThreadPoolExecutor)this.exec).getQueue().size();
                double perThreadSize = (double)submissionQueueSize / (double)this.nThreads;
                batchPersisterPointBuilder = batchPersisterPointBuilder.addField("time_tot", time).addField("count", (long)nAcc).addField("time_avg", (double)time / (double)nAcc).addField("exec_queue_size", (double)submissionQueueSize).addField("exec_queue_size_per_threads", perThreadSize);
                Point point = batchPersisterPointBuilder.tag("persister", this.persisterName).tag(this.influxDbClientService.getGlobalTags()).build();
                this.influxDbClientService.getInfluxDbClient().write(point);
            } else {
                KeyValueDataList kvdl = new KeyValueDataList(this.persisterName);
                kvdl.addData(this.persisterName + "/queueProcessingTime", (Serializable)Long.valueOf(time));
                kvdl.addData(this.persisterName + "/queueSize", (Serializable)Integer.valueOf(queueAtStart));
                kvdl.addData(this.persisterName + "/nBatchInRun", (Serializable)Integer.valueOf(nbatch));
                kvdl.addData(this.persisterName + "/activeThreads", (Serializable)Integer.valueOf(((ThreadPoolExecutor)this.exec).getActiveCount()));
                kvdl.addData(this.persisterName + "/queuedTasks", (Serializable)Integer.valueOf(tasksAtStart));
                this.log.fine((Object)(this.persisterName + " queued tasks " + tasksAtStart + " " + ((ThreadPoolExecutor)this.exec).getQueue().size()));
                this.statusDataPersister.processEncodedData(this.a.getName(), kvdl);
            }
        }
        this.log.fine((Object)(this.persisterName + " end run "));
    }

    public void addToQueue(T obj) {
        this.rq.add(obj);
    }

    public abstract void persist(T var1, Session var2);
}

