/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.QualifiedSequenceName;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.schema.extract.internal.ExtractionContextImpl;
import org.hibernate.tool.schema.extract.internal.InformationExtractorJdbcDatabaseMetaDataImpl;
import org.hibernate.tool.schema.extract.spi.DatabaseInformation;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.InformationExtractor;
import org.hibernate.tool.schema.extract.spi.SequenceInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;

public class DatabaseInformationImpl
implements DatabaseInformation,
ExtractionContext.DatabaseObjectAccess {
    private final JdbcEnvironment jdbcEnvironment;
    private final ExtractionContext extractionContext;
    private final InformationExtractor extractor;
    private final Map<QualifiedSequenceName, SequenceInformation> sequenceInformationMap = new HashMap<QualifiedSequenceName, SequenceInformation>();

    public DatabaseInformationImpl(JdbcEnvironment jdbcEnvironment, InformationExtractor extractor, ExtractionContext extractionContext) throws SQLException {
        this.jdbcEnvironment = jdbcEnvironment;
        this.extractionContext = extractionContext;
        this.extractor = extractor;
        this.initializeSequences();
    }

    public DatabaseInformationImpl(ServiceRegistry serviceRegistry, JdbcEnvironment jdbcEnvironment, JdbcConnectionAccess jdbcConnectionAccess, Identifier defaultCatalogName, Identifier defaultSchemaName) throws SQLException {
        this.jdbcEnvironment = jdbcEnvironment;
        this.extractionContext = new ExtractionContextImpl(serviceRegistry, jdbcEnvironment, jdbcConnectionAccess, this, defaultCatalogName, defaultSchemaName);
        this.extractor = new InformationExtractorJdbcDatabaseMetaDataImpl(this.extractionContext);
        this.initializeSequences();
    }

    private void initializeSequences() throws SQLException {
        Iterable<SequenceInformation> itr = this.jdbcEnvironment.getDialect().getSequenceInformationExtractor().extractMetadata(this.extractionContext);
        for (SequenceInformation sequenceInformation : itr) {
            this.sequenceInformationMap.put(new QualifiedSequenceName(null, null, sequenceInformation.getSequenceName().getSequenceName()), sequenceInformation);
        }
    }

    @Override
    public boolean schemaExists(Namespace.Name schema) {
        return this.extractor.schemaExists(schema.getCatalog(), schema.getSchema());
    }

    @Override
    public TableInformation getTableInformation(Identifier catalogName, Identifier schemaName, Identifier tableName) {
        return this.getTableInformation(new QualifiedTableName(catalogName, schemaName, tableName));
    }

    @Override
    public TableInformation getTableInformation(Namespace.Name schemaName, Identifier tableName) {
        return this.getTableInformation(new QualifiedTableName(schemaName, tableName));
    }

    @Override
    public TableInformation getTableInformation(QualifiedTableName qualifiedTableName) {
        if (qualifiedTableName.getObjectName() == null) {
            throw new IllegalArgumentException("Passed table name cannot be null");
        }
        return this.extractor.getTable(qualifiedTableName.getCatalogName(), qualifiedTableName.getSchemaName(), qualifiedTableName.getTableName());
    }

    @Override
    public SequenceInformation getSequenceInformation(Identifier catalogName, Identifier schemaName, Identifier sequenceName) {
        return this.getSequenceInformation(new QualifiedSequenceName(catalogName, schemaName, sequenceName));
    }

    @Override
    public SequenceInformation getSequenceInformation(Namespace.Name schemaName, Identifier sequenceName) {
        return this.getSequenceInformation(new QualifiedSequenceName(schemaName, sequenceName));
    }

    @Override
    public SequenceInformation getSequenceInformation(QualifiedSequenceName qualifiedSequenceName) {
        return this.locateSequenceInformation(qualifiedSequenceName);
    }

    @Override
    public boolean catalogExists(Identifier catalog) {
        return this.extractor.catalogExists(catalog);
    }

    @Override
    public TableInformation locateTableInformation(QualifiedTableName tableName) {
        return this.getTableInformation(tableName);
    }

    @Override
    public SequenceInformation locateSequenceInformation(QualifiedSequenceName sequenceName) {
        if (sequenceName.getCatalogName() != null || sequenceName.getSchemaName() != null) {
            sequenceName = new QualifiedSequenceName(null, null, sequenceName.getSequenceName());
        }
        return this.sequenceInformationMap.get(sequenceName);
    }

    @Override
    public void cleanup() {
        this.extractionContext.cleanup();
    }
}

