/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.persist;

import java.awt.Component;
import java.io.Serializable;
import org.lsst.ccs.gconsole.services.persist.Creator;
import org.lsst.ccs.gconsole.services.persist.Savable;

public interface Persistable
extends Savable {
    @Override
    default public void restore(Serializable descriptor) {
        if (descriptor instanceof Descriptor) {
            this.restore((Descriptor)descriptor);
        }
    }

    default public void restore(Descriptor descriptor) {
    }

    @Override
    default public Descriptor save() {
        return this.getDescriptor().clone();
    }

    public Descriptor getDescriptor();

    default public String getCategory() {
        return this.getDescriptor().getCategory();
    }

    default public Persistable edit(String title, Component parent) {
        return null;
    }

    public static class Descriptor
    implements Serializable,
    Cloneable {
        private Creator.Descriptor creator;
        private String name;
        private String category;
        private String path;
        private String description;

        public void saveOrigin(Descriptor other) {
            if (other == null) {
                return;
            }
            this.setCreator(other.getCreator());
            this.setName(other.getName());
            this.setCategory(other.getCategory());
            this.setPath(other.getPath());
            this.setDescription(other.getDescription());
        }

        public Creator.Descriptor getCreator() {
            return this.creator;
        }

        public void setCreator(Creator.Descriptor creator) {
            this.creator = creator;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCategory() {
            if (this.category == null) {
                return this.creator == null ? null : this.creator.getCategory();
            }
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Descriptor clone() {
            try {
                Descriptor clone = (Descriptor)super.clone();
                if (this.creator != null) {
                    clone.creator = this.creator.clone();
                }
                return clone;
            }
            catch (CloneNotSupportedException x) {
                return null;
            }
        }
    }
}

