/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.Axis;
import jas.plot.CoordinateTransformation;
import jas.plot.DataAreaLayout;
import jas.plot.EditableLabel;
import jas.plot.MovableObject;
import jas.plot.Overlay;
import jas.plot.OverlayContainer;
import jas.plot.PrintHelper;
import jas.plot.SetablePlotGraphics;
import jas.plot.java1.PlotGraphics11;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.JComponent;

public class DataArea
extends MovableObject {
    private final Vector overlays = new Vector();
    public static final int PG2_NEVER = 0;
    public static final int PG2_PRINTING = 1;
    public static final int PG2_ALWAYS = 2;
    private int usepg2 = 0;
    private NormalDataArea normal;
    private Component special;
    private CardLayout cardLayout;
    private SetablePlotGraphics pg2;
    private SetablePlotGraphics pg1 = new PlotGraphics11();
    private Axis xAxis;
    private final Axis[] yAxis = new Axis[2];
    private EditableLabel xAxisLabel;
    private final EditableLabel[] yAxisLabel = new EditableLabel[2];

    public DataArea(Axis x, Axis y) {
        this();
        this.add(x, (Object)"x");
        this.add(y, (Object)"yl");
    }

    public DataArea() {
        super("Data Area");
        this.normal = new NormalDataArea();
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        super.add((Component)this.normal, "Normal");
        String usePG2Property = System.getProperty("jas.plot.usePG2", "true");
        if (usePG2Property.equalsIgnoreCase("false") || usePG2Property.equalsIgnoreCase("never")) {
            this.usePG2(0);
        } else if (usePG2Property.equalsIgnoreCase("printing")) {
            this.usePG2(1);
        } else {
            this.usePG2(2);
        }
    }

    public void add(Axis a, Object constraint) {
        if (a == null) {
            return;
        }
        if (constraint == "x") {
            if (this.xAxis != null) {
                this.remove(this.xAxis);
            }
            this.xAxis = a;
        } else if (constraint == "yl") {
            if (this.yAxis[0] != null) {
                this.remove(this.yAxis[0]);
            }
            this.yAxis[0] = a;
        } else if (constraint == "yr") {
            if (this.yAxis[1] != null) {
                this.remove(this.yAxis[1]);
            }
            this.yAxis[1] = a;
        }
        this.normal.add((Component)a, constraint);
    }

    public void add(EditableLabel a, Object constraint) {
        if (a == null) {
            return;
        }
        if (constraint == "xl") {
            if (this.xAxisLabel != null) {
                this.remove(this.xAxisLabel);
            }
            this.xAxisLabel = a;
        } else if (constraint == "yll") {
            if (this.yAxisLabel[0] != null) {
                this.remove(this.yAxisLabel[0]);
            }
            this.yAxisLabel[0] = a;
        } else if (constraint == "yrl") {
            if (this.yAxisLabel[1] != null) {
                this.remove(this.yAxisLabel[1]);
            }
            this.yAxisLabel[1] = a;
        }
        this.normal.add((Component)a, constraint);
    }

    public void add(Overlay o) {
        this.overlays.addElement(o);
        o.containerNotify(this.normal);
    }

    public void setSpecialComponent(Component special) {
        if (special == this.special) {
            return;
        }
        if (special == null) {
            this.cardLayout.first(this);
            super.remove(this.special);
            this.special = null;
        } else {
            super.add(special, "Special");
            this.cardLayout.last(this);
            if (this.special != null) {
                super.remove(this.special);
            }
            this.special = special;
        }
    }

    @Override
    public void remove(Component c) {
        if (c == this.xAxis) {
            this.xAxis = null;
        } else if (c == this.yAxis[0]) {
            this.yAxis[0] = null;
        } else if (c == this.yAxis[1]) {
            this.yAxis[1] = null;
        } else if (c == this.xAxisLabel) {
            this.xAxisLabel = null;
        } else if (c == this.yAxisLabel[0]) {
            this.yAxisLabel[0] = null;
        } else if (c == this.yAxisLabel[1]) {
            this.yAxisLabel[1] = null;
        }
        this.normal.remove(c);
    }

    public Axis getXAxis() {
        return this.xAxis;
    }

    public Axis getYAxis() {
        return this.yAxis[0];
    }

    public Axis getYAxis(int index) {
        return this.yAxis[index];
    }

    public void remove(Overlay o) {
        this.overlays.removeElement(o);
        o.containerNotify(null);
    }

    public EditableLabel getLabel(Axis a) {
        if (a == this.xAxis) {
            return this.xAxisLabel;
        }
        if (a == this.yAxis[0]) {
            return this.yAxisLabel[0];
        }
        if (a == this.yAxis[1]) {
            return this.yAxisLabel[1];
        }
        return null;
    }

    public void setLabel(Axis a, EditableLabel l) {
        if (a == this.xAxis) {
            this.add(l, (Object)"xl");
        } else if (a == this.yAxis[0]) {
            this.add(l, (Object)"yll");
        } else if (a == this.yAxis[1]) {
            this.add(l, (Object)"yrl");
        }
    }

    public void usePG2(int mode) {
        if (mode != 0 && this.pg2 == null) {
            try {
                Class<?> c = Class.forName("jas.plot.java2.PlotGraphics12");
                this.pg2 = (SetablePlotGraphics)c.newInstance();
            }
            catch (Throwable x) {
                this.usepg2 = 0;
                return;
            }
        }
        if (this.usepg2 != mode) {
            this.usepg2 = mode;
            this.repaint();
        }
    }

    private class NormalDataArea
    extends JComponent
    implements OverlayContainer {
        private boolean printing;

        NormalDataArea() {
            this.setLayout(new DataAreaLayout());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(Graphics g) {
            try {
                this.printing = true;
                super.print(g);
                super.invalidate();
            }
            finally {
                this.printing = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintChildren(Graphics g) {
            boolean pg2now = DataArea.this.usepg2 == 2 || DataArea.this.usepg2 == 1 && this.isPrinting();
            SetablePlotGraphics pg = pg2now ? DataArea.this.pg2 : DataArea.this.pg1;
            try {
                super.paintChildren(g);
                pg.setGraphics(g);
                DataArea.this.xAxis.paint(pg);
                if (DataArea.this.yAxis[0] != null) {
                    DataArea.this.yAxis[0].paint(pg);
                }
                if (DataArea.this.yAxis[1] != null) {
                    DataArea.this.yAxis[1].paint(pg);
                }
                pg.setClip(DataArea.this.xAxis.getMinLocation(), DataArea.this.xAxis.getMaxLocation(), DataArea.this.yAxis[0].getMinLocation(), DataArea.this.yAxis[0].getMaxLocation());
                int s = DataArea.this.overlays.size();
                for (int i = 0; i < s; ++i) {
                    pg.clearTransformation();
                    Overlay o = (Overlay)DataArea.this.overlays.elementAt(i);
                    o.paint(pg, this.isPrinting());
                }
            }
            catch (Throwable t) {
                System.err.println("Exception while painting DataArea");
                t.printStackTrace();
            }
            finally {
                pg.setGraphics(null);
            }
        }

        @Override
        public CoordinateTransformation getXTransformation() {
            return ((DataArea)DataArea.this).xAxis.type.getCoordinateTransformation();
        }

        @Override
        public CoordinateTransformation getYTransformation() {
            return ((DataArea)DataArea.this).yAxis[0].type.getCoordinateTransformation();
        }

        @Override
        public CoordinateTransformation getYTransformation(int index) {
            return ((DataArea)DataArea.this).yAxis[index].type.getCoordinateTransformation();
        }

        private boolean isPrinting() {
            return this.printing || PrintHelper.isPrinting();
        }
    }
}

