/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.io.Closeable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.config.CategoryDataChain;
import org.lsst.ccs.config.CategoryDescription;
import org.lsst.ccs.config.ConfigurationDAO;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationLoadedData;
import org.lsst.ccs.config.ConfigurationServiceException;
import org.lsst.ccs.config.LocalConfigurationDAO;
import org.lsst.ccs.config.SingleCategoryTag;
import org.lsst.ccs.config.SingleCategoryTagData;
import org.lsst.ccs.config.remote.LocalToRemoteMigrationDAO;
import org.lsst.ccs.config.remote.RestFileServerRemoteDAO;

public class ConfigurationDAOWrapper
implements Closeable {
    private static final Logger LOG = Logger.getLogger(ConfigurationDAOWrapper.class.getName());
    private final ConfigurationService configurationService;
    private final ConfigurationDAO configurationDao;

    ConfigurationDAOWrapper(String descriptionName, ConfigurationService configurationService) {
        this.configurationService = configurationService;
        Properties props = BootstrapResourceUtils.getBootstrapSystemProperties();
        String dao = props.getProperty("org.lsst.ccs.config.remote", "");
        if (dao.isEmpty()) {
            dao = props.getProperty("org.lsst.ccs.remote", "false");
        }
        this.configurationDao = dao.equalsIgnoreCase("true") ? new RestFileServerRemoteDAO(descriptionName) : (dao.equalsIgnoreCase("migrate") ? new LocalToRemoteMigrationDAO(descriptionName) : new LocalConfigurationDAO());
    }

    ConfigurationDAOWrapper(String descriptionName) {
        this(descriptionName, null);
    }

    Properties getConfigurationProperties(SingleCategoryTag singleCategoryTag) throws ConfigurationServiceException {
        Properties res = new Properties();
        try {
            SingleCategoryTagData data = this.configurationDao.loadCategoryTag(singleCategoryTag);
            res.putAll((Map<?, ?>)data.getConfigurationData());
        }
        catch (ConfigurationServiceException e) {
            LOG.log(Level.FINE, "Unable to load build configuration " + singleCategoryTag, e);
        }
        return res;
    }

    public ConfigurationLoadedData initialLoadConfiguration(ConfigurationDescription configDescription, boolean failOnException) {
        ConfigurationLoadedData viewResult = this.loadConfiguration(configDescription, failOnException);
        return viewResult;
    }

    public ConfigurationLoadedData loadConfiguration(ConfigurationDescription configDescription) throws ConfigurationServiceException {
        return this.loadConfiguration(configDescription, true);
    }

    private ConfigurationLoadedData loadConfiguration(ConfigurationDescription configDescription, boolean failOnException) throws ConfigurationServiceException {
        ConfigurationLoadedData loadedData = new ConfigurationLoadedData();
        for (String category : configDescription.getCategoriesSet()) {
            CategoryDescription categoryTag = configDescription.getCategoryTag(category);
            CategoryDataChain categoryDataChain = new CategoryDataChain(category);
            for (SingleCategoryTag singleCategoryTag : categoryTag.getSingleCategoryTags()) {
                if (singleCategoryTag.getSource() == null || singleCategoryTag.getSource().isEmpty()) {
                    throw new IllegalArgumentException("Cannot load data with an empty source: " + singleCategoryTag);
                }
                try {
                    SingleCategoryTagData tagData;
                    block9: {
                        tagData = new SingleCategoryTagData(singleCategoryTag);
                        try {
                            tagData = this.configurationDao.loadCategoryTag(singleCategoryTag);
                        }
                        catch (ConfigurationServiceException ex) {
                            if (!failOnException) break block9;
                            throw ex;
                        }
                    }
                    this.configurationService.verifyIntegrityOfLoadedData(tagData, failOnException);
                    configDescription.putSingleTagForCategory(category, singleCategoryTag, tagData.getSingleCategoryTag().getResolvedVersion());
                    categoryDataChain.addSingleCategoryTagData(tagData, this.configurationService.agent.getAgentInfo());
                }
                catch (ConfigurationServiceException ex) {
                    if (!failOnException) continue;
                    throw ex;
                }
            }
            loadedData.putCategoryDataChain(categoryDataChain);
        }
        return loadedData;
    }

    public ConfigurationDescription resolveConfigurationDescription(ConfigurationDescription configDescription) {
        ConfigurationDescription result = new ConfigurationDescription(configDescription.getCategoriesSet());
        for (String category : configDescription.getCategoriesSet()) {
            CategoryDescription categoryTag = configDescription.getCategoryTag(category);
            CategoryDescription newCategoryDescription = new CategoryDescription(categoryTag.getCategoryName(), null);
            for (SingleCategoryTag singleCategoryTag : categoryTag.getSingleCategoryTags()) {
                String version = this.configurationDao.resolveVersionForCategoryTag(singleCategoryTag);
                SingleCategoryTag newSingleCategoryTag = new SingleCategoryTag(singleCategoryTag, version);
                newCategoryDescription.addOrUpdadateSingleTag(newSingleCategoryTag);
            }
            result.addCategoryTag(newCategoryDescription);
        }
        return result;
    }

    public SingleCategoryTagData loadCategoryTag(SingleCategoryTag tag) throws ConfigurationServiceException {
        return this.configurationDao.loadCategoryTag(tag);
    }

    public SingleCategoryTag saveChangesForCategoriesAs(SingleCategoryTagData singleCategoryDataToSave) throws ConfigurationServiceException {
        SingleCategoryTag savedToTag = this.configurationDao.saveCategoryTagData(singleCategoryDataToSave);
        SingleCategoryTag result = new SingleCategoryTag(savedToTag.getSource(), savedToTag.getTag(), savedToTag.getCategory(), savedToTag.getResolvedVersion(), savedToTag.getResolvedVersion());
        return result;
    }

    @Override
    public void close() {
        if (this.configurationDao != null) {
            this.configurationDao.close();
        }
    }

    public ConfigurationDAO getConfigurationDAO() {
        return this.configurationDao;
    }
}

