/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystem.teststand.AP9630UPSDevice;
import org.lsst.ccs.subsystem.teststand.data.TSState;

public class AP9630UPSSimDevice
extends AP9630UPSDevice {
    @Override
    protected void initDevice() {
        this.fullName = "Simulated AP9630 UPS";
    }

    @Override
    protected void initialize() {
        this.initSensors();
        this.kstate = TSState.pwrstates.OK;
        this.sLog.info((Object)("Connected to " + this.fullName));
        this.inited = true;
        this.setOnline(true);
    }

    @Override
    protected void close() {
        this.kstate = TSState.pwrstates.NOTCONFIGURED;
    }

    @Override
    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        return new int[]{0, 0};
    }

    @Override
    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
    }

    @Override
    protected double readChannel(int hwChan, int type) {
        switch (hwChan) {
            case 0: {
                return 111.0;
            }
            case 1: {
                return 15.0;
            }
            case 2: {
                return 1650.0;
            }
            case 4: {
                return 100.0;
            }
            case 5: {
                return 100.0;
            }
            case 3: {
                return 21.0;
            }
            case 6: {
                return 0.0;
            }
            case 7: {
                return 999.0;
            }
        }
        return 0.0;
    }

    @Override
    @Command(name="getStatus", description="Get the UPS status")
    public int getStatus() {
        return 0;
    }

    @Override
    @Command(name="getRemTime", description="Get the UPS remaining time")
    public int getRemTime() {
        return 999;
    }
}

