/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.apcpdu.AP7900;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.teststand.PDUDevice;
import org.lsst.ccs.subsystem.teststand.data.TSConfig;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.utilities.logging.Logger;

public class AP7900Device
extends Device
implements PDUDevice {
    private static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    private final Thread readW = new Thread(new Reader());
    private int last_state = -1;
    private int nRead = 0;
    private int nByte = 0;
    private int nTimeout = 0;
    private boolean open = false;
    private boolean isconnected = false;
    TSConfig cfg = new TSConfig();
    AP7900 devpdu = null;
    String pdu_host = null;
    int pdu_port = 23;
    TSState.pwrstates kstate = TSState.pwrstates.NOTCONFIGURED;
    boolean failedToInitialize = false;
    private int major_version;

    public AP7900Device(String host, int port) throws DriverException {
        this.isconnected = true;
        this.pdu_host = host;
        this.pdu_port = port;
        try {
            this.devpdu = new AP7900();
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to AP7900 device!");
            this.isconnected = false;
        }
        this.readW.setDaemon(true);
        this.readW.start();
    }

    public AP7900Device() {
        try {
            this.devpdu = new AP7900();
        }
        catch (DriverException f) {
            System.out.println("Failed to create to AP7900 device instance!");
        }
    }

    protected void initDevice() {
        this.fullName = "AP7900 module";
    }

    protected void close() {
        try {
            if (this.devpdu != null) {
                this.devpdu.close();
            }
            this.kstate = TSState.pwrstates.NOTCONFIGURED;
        }
        catch (DriverException e) {
            this.log.error((Object)"AP7900 device failed to close!!!");
        }
    }

    protected void initialize() {
        if (this.isconnected) {
            this.log.debug((Object)"AP7900 device is already initialized");
            this.log.debug((Object)"Setting device online.");
            this.kstate = TSState.pwrstates.OK;
            this.setOnline(true);
        } else if (!this.failedToInitialize) {
            this.log.error((Object)"Tried to initialize unconnected PDU device!");
            this.failedToInitialize = true;
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, name="setOutletState", description="set the state of an outlet")
    public void setOutletState(@Argument(name="outlet", description="outlet number") int outlet, @Argument(name="otlstate", description="on(true)/off(false) state") boolean otlstate) {
        if (this.devpdu == null) {
            return;
        }
        try {
            this.devpdu.opennet(this.pdu_host, this.pdu_port, this.major_version);
            this.open = true;
            this.devpdu.setTimeout(60.0);
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to AP7900 device!");
            this.isconnected = false;
        }
        try {
            if (this.open) {
                this.devpdu.setOutletState(outlet, otlstate);
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed open/close the AP7900");
        }
        try {
            this.open = false;
            Thread.sleep(500L);
            this.devpdu.close();
        }
        catch (DriverException f) {
            System.out.println("Failed to close connection to AP7900 device!");
        }
        catch (InterruptedException e) {
            System.out.println("Sleep interrupted" + e);
        }
    }

    @Override
    @Command(type=Command.CommandType.ACTION, name="getOutletState", description="set the state of an outlet")
    public boolean getOutletState(@Argument(name="outlet", description="outlet number") int outlet) {
        boolean otlstate = false;
        if (this.devpdu == null) {
            return false;
        }
        try {
            this.devpdu.opennet(this.pdu_host, this.pdu_port, this.major_version);
            this.open = true;
            this.devpdu.setTimeout(60.0);
        }
        catch (DriverException f) {
            System.out.println("Failed to open connection to AP7900 device!");
            this.open = false;
        }
        try {
            if (this.open) {
                this.devpdu.isOutletOn(outlet);
                this.last_state = -1;
                int countdown = 100;
                while (countdown-- > 0 && this.last_state < 0) {
                    System.out.println("Waiting for a response from the PDU");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        System.out.println("Sleep attempt interrupted" + ex);
                    }
                }
                if (this.last_state < 0) {
                    throw new DriverException("PDU never responded to outlet state request");
                }
                otlstate = this.last_state == 1;
            }
        }
        catch (DriverException f) {
            this.log.error((Object)"Failed open/close the AP7900");
        }
        try {
            this.open = false;
            Thread.sleep(500L);
            this.devpdu.close();
        }
        catch (DriverException f) {
            System.out.println("Failed to close connection to AP7900 device!");
        }
        catch (InterruptedException e) {
            System.out.println("Sleep interrupted" + e);
        }
        return otlstate;
    }

    private String getOnOff(boolean on) {
        return on ? "on" : "off";
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"type", (Object)type);
        } else if (iType != 3) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"Wrong channel type specified! type = ", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(int chan, int type, int subtype) {
        try {
            if (type == 3) {
                this.log.debug((Object)("setting channel online - chan=" + chan));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Error configuring channel type " + type + ": " + e));
        }
    }

    protected double readChannel(int chan, int type) {
        double value = 0.0;
        this.log.debug((Object)("AP7900Device readChannel called! chan=" + chan + " type=" + type));
        try {
            if (type == 3) {
                value = 1.0;
            }
        }
        catch (Exception e) {
            this.log.debug((Object)("Error reading channel type " + type + ": " + e));
        }
        return value;
    }

    @Command(name="setstate", description="set AP7900 device status")
    public void setState(int istate) {
        this.kstate = TSState.pwrstates.values()[istate];
    }

    @Command(name="getstate", description="get AP7900 device status")
    public int getState() {
        return this.kstate.ordinal();
    }

    private class Reader
    implements Runnable {
        private Reader() {
        }

        @Override
        public void run() {
            System.out.println("Reader thread started.");
            while (true) {
                if (AP7900Device.this.open) {
                    try {
                        String reply = AP7900Device.this.devpdu.read();
                        if (reply.indexOf("State") >= 0) {
                            AP7900Device.this.last_state = 0;
                            if (reply.indexOf("ON") >= 0) {
                                AP7900Device.this.last_state = 1;
                            }
                        }
                        System.out.println(reply);
                        ++AP7900Device.this.nRead;
                        AP7900Device.this.nByte += reply.length();
                    }
                    catch (DriverTimeoutException e) {
                        ++AP7900Device.this.nTimeout;
                    }
                    catch (DriverException e) {
                        if (!AP7900Device.this.open) continue;
                        System.out.println((Object)e);
                        System.exit(0);
                    }
                    continue;
                }
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException ex) {
                    System.out.println("Sleep interrupted:" + ex);
                    continue;
                }
                break;
            }
        }
    }
}

