/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.samp.gui;

import java.awt.AWTException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public abstract class SysTray {
    private static SysTray instance_;
    private static final Logger logger_;
    static /* synthetic */ Class class$java$awt$Image;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$PopupMenu;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public abstract boolean isSupported();

    public abstract Object addIcon(Image var1, String var2, PopupMenu var3, ActionListener var4) throws AWTException;

    public abstract void removeIcon(Object var1) throws AWTException;

    public static SysTray getInstance() {
        if (instance_ == null) {
            SysTray instance;
            boolean isJava6;
            String jvers = System.getProperty("java.specification.version");
            boolean bl = isJava6 = jvers != null && jvers.matches("^[0-9]+\\.[0-9]+$") && Double.parseDouble(jvers) > 1.5999;
            if (!isJava6) {
                logger_.info("Not expecting system tray support (java version < 1.6)");
            }
            try {
                instance = new Java6SysTray();
            }
            catch (Throwable e) {
                if (isJava6) {
                    logger_.info("No system tray support: " + e);
                }
                instance = new NoSysTray();
            }
            instance_ = instance;
        }
        return instance_;
    }

    static {
        logger_ = Logger.getLogger(SysTray.class.getName());
    }

    private static class Java6SysTray
    extends SysTray {
        private final Class systemTrayClass_ = Class.forName("java.awt.SystemTray");
        private final Method addMethod_;
        private final Method removeMethod_;
        private final Class trayIconClass_ = Class.forName("java.awt.TrayIcon");
        private final Constructor trayIconConstructor_;
        private final Method setImageAutoSizeMethod_;
        private final Method addActionListenerMethod_;
        private final Object systemTrayInstance_;

        Java6SysTray() throws ClassNotFoundException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
            this.addMethod_ = this.systemTrayClass_.getMethod("add", this.trayIconClass_);
            this.removeMethod_ = this.systemTrayClass_.getMethod("remove", this.trayIconClass_);
            this.trayIconConstructor_ = this.trayIconClass_.getConstructor(class$java$awt$Image == null ? (class$java$awt$Image = SysTray.class$("java.awt.Image")) : class$java$awt$Image, class$java$lang$String == null ? (class$java$lang$String = SysTray.class$("java.lang.String")) : class$java$lang$String, class$java$awt$PopupMenu == null ? (class$java$awt$PopupMenu = SysTray.class$("java.awt.PopupMenu")) : class$java$awt$PopupMenu);
            this.setImageAutoSizeMethod_ = this.trayIconClass_.getMethod("setImageAutoSize", Boolean.TYPE);
            this.addActionListenerMethod_ = this.trayIconClass_.getMethod("addActionListener", class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = SysTray.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
            boolean isSupported = Boolean.TRUE.equals(this.systemTrayClass_.getMethod("isSupported", new Class[0]).invoke(null, new Object[0]));
            this.systemTrayInstance_ = isSupported ? this.systemTrayClass_.getMethod("getSystemTray", new Class[0]).invoke(null, new Object[0]) : null;
        }

        public boolean isSupported() {
            return this.systemTrayInstance_ != null;
        }

        public Object addIcon(Image im, String tooltip, PopupMenu popup, ActionListener iconListener) throws AWTException {
            try {
                Object trayIcon = this.trayIconConstructor_.newInstance(im, tooltip, popup);
                this.setImageAutoSizeMethod_.invoke(trayIcon, Boolean.TRUE);
                if (iconListener != null) {
                    this.addActionListenerMethod_.invoke(trayIcon, iconListener);
                }
                this.addMethod_.invoke(this.systemTrayInstance_, trayIcon);
                return trayIcon;
            }
            catch (InvocationTargetException e) {
                String msg = e.getCause() instanceof AWTException ? e.getCause().getMessage() : "Add tray icon invocation failed";
                throw (AWTException)new AWTException(msg).initCause(e);
            }
            catch (Exception e) {
                throw (AWTException)new AWTException("Add tray icon invocation failed").initCause(e);
            }
        }

        public void removeIcon(Object trayIcon) throws AWTException {
            try {
                this.removeMethod_.invoke(this.systemTrayInstance_, trayIcon);
            }
            catch (Exception e) {
                throw (AWTException)new AWTException("Remove tray icon invocation failed").initCause(e);
            }
        }
    }

    private static class NoSysTray
    extends SysTray {
        private NoSysTray() {
        }

        public boolean isSupported() {
            return false;
        }

        public Object addIcon(Image im, String tooltip, PopupMenu popup, ActionListener iconListener) {
            throw new UnsupportedOperationException();
        }

        public void removeIcon(Object trayIcon) {
            throw new UnsupportedOperationException();
        }
    }
}

