/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum.data;

import java.io.Serializable;
import java.util.Arrays;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.subsystem.vacuum.constants.ConditionState;
import org.lsst.ccs.subsystem.vacuum.constants.CryoVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.DeviceState;
import org.lsst.ccs.subsystem.vacuum.constants.HxVacuumState;
import org.lsst.ccs.subsystem.vacuum.constants.LatchState;
import org.lsst.ccs.subsystem.vacuum.constants.PLCState;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchEnable;
import org.lsst.ccs.subsystem.vacuum.constants.SwitchState;

@SkipEncoding
public class VacSysState
implements Serializable {
    public static final String KEY = "VacuumState";
    private int tickMillis;
    private CryoVacuumState cryoVacuumState = CryoVacuumState.UNKNOWN;
    private HxVacuumState hxVacuumState = HxVacuumState.UNKNOWN;
    private PLCState plcState = PLCState.ALIVE;
    private double CryoPress;
    private double HXPress;
    private double CryoTurboPress;
    private double HXTurboPress;
    private double CryoFlinePress;
    private double HXFlinePress;
    private double PCPress;
    private double pcTargetPressure;
    private double maxVentPressure;
    private double minPumpPressure;
    private int cyclingStatus;
    private int ventingStatus;
    private String cryoForelineValveStatus;
    private String hxForelineValveStatus;
    private String pcTargetPressureSrc;
    private boolean pumpCartPumpingSwitchState;
    private boolean pumpCartVentingSwitchState;
    private boolean pumpPCAbortPumpState;
    private boolean pumpPCAbortVentState;
    private boolean cryoTurboVentingSwitchState;
    private boolean hxTurboVentingSwitchState;
    private Boolean cryoTurboPumpSwitchState;
    private Boolean hxTurboPumpSwitchState;
    private final SwitchState[] switchState = new SwitchState[28];
    private final SwitchEnable[] switchEnable = new SwitchEnable[28];
    private final DeviceState[] deviceState = new DeviceState[28];
    private final LatchState[] latchState = new LatchState[8];
    private final ConditionState[] conditionState = new ConditionState[10];
    private static final long serialVersionUID = -2669272698864689859L;

    public VacSysState() {
        Arrays.fill((Object[])this.switchState, (Object)SwitchState.OFFLINE);
        Arrays.fill((Object[])this.switchEnable, (Object)SwitchEnable.OFF);
        Arrays.fill((Object[])this.latchState, (Object)LatchState.CLEAR);
        Arrays.fill((Object[])this.conditionState, (Object)ConditionState.NO);
    }

    public void setTickMillis(int value) {
        this.tickMillis = value;
    }

    public int getTickMillis() {
        return this.tickMillis;
    }

    public void setCryoVacuumState(CryoVacuumState value) {
        this.cryoVacuumState = value;
    }

    public CryoVacuumState getCryoVacuumState() {
        return this.cryoVacuumState;
    }

    public void setHxVacuumState(HxVacuumState value) {
        this.hxVacuumState = value;
    }

    public HxVacuumState getHxVacuumState() {
        return this.hxVacuumState;
    }

    public void setPlcState(PLCState value) {
        this.plcState = value;
    }

    public PLCState getPlcState() {
        return this.plcState;
    }

    public void setSwitchState(int sw, SwitchState state) {
        this.switchState[sw] = state;
    }

    public SwitchState getSwitchState(int sw) {
        return this.switchState[sw];
    }

    public void setSwitchEnable(int sw, SwitchEnable enable) {
        this.switchEnable[sw] = enable;
    }

    public SwitchEnable getSwitchEnable(int sw) {
        return this.switchEnable[sw];
    }

    public void setDeviceState(int sw, DeviceState state) {
        this.deviceState[sw] = state;
    }

    public DeviceState getDeviceState(int sw) {
        return this.deviceState[sw];
    }

    public void setLatch(int latch, LatchState state) {
        this.latchState[latch] = state;
    }

    public LatchState getLatch(int latch) {
        return this.latchState[latch];
    }

    public void setCondition(int cond, ConditionState state) {
        this.conditionState[cond] = state;
    }

    public ConditionState getCondition(int cond) {
        return this.conditionState[cond];
    }

    public void setCryoPress(double value) {
        this.CryoPress = value;
    }

    public double getCryoPress() {
        return this.CryoPress;
    }

    public void setHXPress(double value) {
        this.HXPress = value;
    }

    public double getHXPress() {
        return this.HXPress;
    }

    public void setCryoTurboPress(double value) {
        this.CryoTurboPress = value;
    }

    public double getCryoTurboPress() {
        return this.CryoTurboPress;
    }

    public void setHXTurboPress(double value) {
        this.HXTurboPress = value;
    }

    public double getHXTurboPress() {
        return this.HXTurboPress;
    }

    public void setCryoFlinePress(double value) {
        this.CryoFlinePress = value;
    }

    public double getCryoFlinePress() {
        return this.CryoFlinePress;
    }

    public void setHXFlinePress(double value) {
        this.HXFlinePress = value;
    }

    public double getHXFlinePress() {
        return this.HXFlinePress;
    }

    public void setCyclingStatus(int value) {
        this.cyclingStatus = value;
    }

    public double getCyclingStatus() {
        return this.cyclingStatus;
    }

    public void setPumpCartPumpingSwitchState(boolean value) {
        this.pumpCartPumpingSwitchState = value;
    }

    public boolean getPumpCartPumpingSwitchState() {
        return this.pumpCartPumpingSwitchState;
    }

    public void setPumpCartVentingSwitchState(boolean value) {
        this.pumpCartVentingSwitchState = value;
    }

    public boolean getPumpCartVentingSwitchState() {
        return this.pumpCartVentingSwitchState;
    }

    public void setCryoTurboVentingSwitchState(boolean value) {
        this.cryoTurboVentingSwitchState = value;
    }

    public boolean getCryoTurboVentingSwitchState() {
        return this.cryoTurboVentingSwitchState;
    }

    public void setCryoTurboPumpSwitchState(boolean value) {
        this.cryoTurboPumpSwitchState = value;
    }

    public Boolean getCryoTurboPumpSwitchState() {
        return this.cryoTurboPumpSwitchState;
    }

    public void setHXTurboVentingSwitchState(boolean value) {
        this.hxTurboVentingSwitchState = value;
    }

    public boolean getHXTurboVentingSwitchState() {
        return this.hxTurboVentingSwitchState;
    }

    public void setHXTurboPumpSwitchState(boolean value) {
        this.hxTurboPumpSwitchState = value;
    }

    public Boolean getHXTurboPumpSwitchState() {
        return this.hxTurboPumpSwitchState;
    }

    public void setPCAbortVentState(boolean value) {
        this.pumpPCAbortVentState = value;
    }

    public boolean getPCAbortVentState() {
        return this.pumpPCAbortVentState;
    }

    public void setPCAbortPumpState(boolean value) {
        this.pumpPCAbortPumpState = value;
    }

    public boolean getPCAbortPumpState() {
        return this.pumpPCAbortPumpState;
    }

    public void setPCTargetPressureSrc(String value) {
        this.pcTargetPressureSrc = value;
    }

    public String getPCTargetPressureSrc() {
        return this.pcTargetPressureSrc;
    }

    public void setPCTargetPressure(double value) {
        this.pcTargetPressure = value;
    }

    public double getPCTargetPressure() {
        return this.pcTargetPressure;
    }

    public void setMinPumpPressure(double value) {
        this.minPumpPressure = value;
    }

    public double getMinPumpPressure() {
        return this.minPumpPressure;
    }

    public void setMaxVentPressure(double value) {
        this.maxVentPressure = value;
    }

    public double getMaxVentPressure() {
        return this.maxVentPressure;
    }

    public void setVentingStatus(int value) {
        this.ventingStatus = value;
    }

    public double getVentingStatus() {
        return this.ventingStatus;
    }

    public void setCryoForelineValveStatus(String value) {
        this.cryoForelineValveStatus = value;
    }

    public String getCryoForelineValveStatus() {
        return this.cryoForelineValveStatus;
    }

    public void setHXForelineValveStatus(String value) {
        this.hxForelineValveStatus = value;
    }

    public String getHXForelineValveStatus() {
        return this.hxForelineValveStatus;
    }

    public void setPCPress(double value) {
        this.PCPress = value;
    }

    public double getPCPress() {
        return this.PCPress;
    }
}

