/*
 * Decompiled with CFR 0.152.
 */
package org.indilib.i4j.client;

import org.indilib.i4j.Constants;
import org.indilib.i4j.INDIException;
import org.indilib.i4j.client.INDIDevice;
import org.indilib.i4j.client.INDILightElement;
import org.indilib.i4j.client.INDIProperty;
import org.indilib.i4j.client.INDIPropertyListener;
import org.indilib.i4j.client.INDIViewCreator;
import org.indilib.i4j.protocol.DefElement;
import org.indilib.i4j.protocol.DefLight;
import org.indilib.i4j.protocol.DefLightVector;
import org.indilib.i4j.protocol.DefVector;
import org.indilib.i4j.protocol.NewVector;
import org.indilib.i4j.protocol.OneLight;
import org.indilib.i4j.protocol.SetVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class INDILightProperty
extends INDIProperty<INDILightElement> {
    private static final Logger LOG = LoggerFactory.getLogger(INDILightProperty.class);
    private INDIPropertyListener uiComponent;

    protected INDILightProperty(DefLightVector xml, INDIDevice device) {
        super((DefVector<?>)xml, device);
        for (DefElement element : xml.getElements()) {
            String name;
            INDILightElement iel;
            if (!(element instanceof DefLight) || (iel = this.getElement(name = element.getName())) != null) continue;
            INDILightElement ite = new INDILightElement((DefLight)element, this);
            this.addElement(ite);
        }
    }

    @Override
    protected void update(SetVector<?> el) {
        super.update(el, OneLight.class);
    }

    @Override
    protected void setPermission(Constants.PropertyPermissions permission) {
        super.setPermission(Constants.PropertyPermissions.RO);
    }

    @Override
    protected void setTimeout(int timeout) {
        super.setTimeout(0);
    }

    @Override
    protected NewVector<?> getXMLPropertyChangeInit() {
        LOG.error("changed but not possible, it should not be possible to change a light!");
        return null;
    }

    @Override
    public INDIPropertyListener getDefaultUIComponent() throws INDIException {
        if (this.uiComponent != null) {
            this.removeINDIPropertyListener(this.uiComponent);
        }
        this.uiComponent = INDIViewCreator.getDefault().createLightPropertyView(this);
        this.addINDIPropertyListener(this.uiComponent);
        return this.uiComponent;
    }

    @Override
    public INDILightElement getElement(String name) {
        return (INDILightElement)super.getElement(name);
    }
}

