/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import io.minio.BucketExistsArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import io.minio.StatObjectArgs;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.MinioException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;

public class S3FileUploaderAndDeleter {
    private final String lfaId;
    private final String lfaSecret;
    private final String lfaBucket;
    private final String lfaEndpoint;
    private final String cscName;
    private boolean enforceNoOverwite;

    public S3FileUploaderAndDeleter(OCSBridgeConfig config) {
        this(BootstrapResourceUtils.getBootstrapProperties((String)config.getLfaCredentialsFile()), config.getDevice().getCscName());
    }

    public S3FileUploaderAndDeleter(Properties lfaProperties, String cscName) {
        this.cscName = cscName;
        this.lfaId = lfaProperties.getProperty("lfa.id", "");
        this.lfaSecret = lfaProperties.getProperty("lfa.secret", "");
        this.lfaBucket = lfaProperties.getProperty("lfa.bucket", "");
        String endPoint = lfaProperties.getProperty("lfa.endpoint", "");
        if (this.lfaId.isEmpty() || this.lfaSecret.isEmpty() || this.lfaBucket.isEmpty() || endPoint.isEmpty()) {
            throw new IllegalArgumentException("The following quantities must be specified for the LFA credentials: id, secret, bucket, endpoint.");
        }
        this.lfaEndpoint = endPoint.endsWith("/") ? endPoint : endPoint + "/";
    }

    public String writeToS3(AdditionalFile additionalFile) throws IOException {
        String objectName = this.computePathForFile(additionalFile);
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(this.lfaEndpoint).credentials(this.lfaId, this.lfaSecret).build();
            boolean bucketFound = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.lfaBucket)).build());
            if (!bucketFound) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.lfaBucket)).build());
            }
            boolean allowOverwrite = this.lfaEndpoint.contains("play.min.io") && !this.enforceNoOverwite;
            boolean alreadyThere = S3FileUploaderAndDeleter.objectExists(minioClient, this.lfaBucket, objectName);
            if (alreadyThere && !allowOverwrite) {
                throw new IOException("S3 file already exists " + this.lfaEndpoint + this.lfaBucket + "/" + objectName);
            }
            try (ByteArrayOutputStream boutstream = new ByteArrayOutputStream();){
                additionalFile.writeFile((OutputStream)boutstream);
                try (ByteArrayInputStream binstream = new ByteArrayInputStream(boutstream.toByteArray());){
                    minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.lfaBucket)).object(objectName)).stream((InputStream)binstream, (long)binstream.available(), -1L).build());
                }
            }
        }
        catch (MinioException | InvalidKeyException | NoSuchAlgorithmException ex) {
            System.out.println(" Exception coming next " + ex.toString());
            throw new IOException("Unable to write s3 file", ex);
        }
        return this.lfaEndpoint + this.lfaBucket + "/" + objectName;
    }

    private String computePathForFile(AdditionalFile additionalFile) {
        return this.cscName + "/" + additionalFile.getFileType() + "/" + additionalFile.getObsId().getDateString() + "/" + additionalFile.getFileName();
    }

    void deleteFromS3(AdditionalFile additionalFile) throws IOException {
        try {
            MinioClient minioClient = MinioClient.builder().endpoint(this.lfaEndpoint).credentials(this.lfaId, this.lfaSecret).build();
            boolean found = minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(this.lfaBucket)).build());
            if (!found) {
                minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(this.lfaBucket)).build());
            }
            minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.lfaBucket)).object(this.computePathForFile(additionalFile))).build());
        }
        catch (MinioException | InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IOException("Unable to delete s3 file", ex);
        }
    }

    private static boolean objectExists(MinioClient minioClient, String bucketName, String objectName) throws IOException {
        try {
            minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
            return true;
        }
        catch (ErrorResponseException e) {
            if ("NoSuchKey".equals(e.errorResponse().code())) {
                return false;
            }
            throw new IOException("Error occurred while checking object existence", e);
        }
        catch (MinioException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException("Error occurred while checking object existence", e);
        }
    }

    void enforceNoOverwrite(boolean enforce) {
        this.enforceNoOverwite = enforce;
    }
}

