/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.ClassNamePatternFilterUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.DefaultLauncher;
import org.junit.platform.launcher.core.DefaultLauncherSession;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherConfigurationParameters;
import org.junit.platform.launcher.core.ListenerRegistry;
import org.junit.platform.launcher.core.ServiceLoaderRegistry;
import org.junit.platform.launcher.core.ServiceLoaderTestEngineRegistry;
import org.junit.platform.launcher.core.SessionPerRequestLauncher;

@API(status=API.Status.STABLE, since="1.0")
public class LauncherFactory {
    private static final ServiceLoaderRegistry SERVICE_LOADER_REGISTRY = new ServiceLoaderRegistry();

    private LauncherFactory() {
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.8")
    public static LauncherSession openSession() throws PreconditionViolationException {
        return LauncherFactory.openSession(LauncherConfig.DEFAULT);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.8")
    public static LauncherSession openSession(LauncherConfig config) throws PreconditionViolationException {
        return new DefaultLauncherSession(LauncherFactory.createDefaultLauncher(config), LauncherFactory.createLauncherSessionListener(config));
    }

    public static Launcher create() throws PreconditionViolationException {
        return LauncherFactory.create(LauncherConfig.DEFAULT);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.3")
    public static Launcher create(LauncherConfig config) throws PreconditionViolationException {
        return new SessionPerRequestLauncher(LauncherFactory.createDefaultLauncher(config), LauncherFactory.createLauncherSessionListener(config));
    }

    private static DefaultLauncher createDefaultLauncher(LauncherConfig config) {
        Preconditions.notNull((Object)config, (String)"LauncherConfig must not be null");
        Set<TestEngine> engines = LauncherFactory.collectTestEngines(config);
        List<PostDiscoveryFilter> filters = LauncherFactory.collectPostDiscoveryFilters(config);
        DefaultLauncher launcher = new DefaultLauncher(engines, filters);
        LauncherFactory.registerLauncherDiscoveryListeners(config, launcher);
        LauncherFactory.registerTestExecutionListeners(config, launcher);
        return launcher;
    }

    private static Set<TestEngine> collectTestEngines(LauncherConfig config) {
        LinkedHashSet<TestEngine> engines = new LinkedHashSet<TestEngine>();
        if (config.isTestEngineAutoRegistrationEnabled()) {
            new ServiceLoaderTestEngineRegistry().loadTestEngines().forEach(engines::add);
        }
        engines.addAll(config.getAdditionalTestEngines());
        return engines;
    }

    private static LauncherSessionListener createLauncherSessionListener(LauncherConfig config) {
        ListenerRegistry<LauncherSessionListener> listenerRegistry = ListenerRegistry.forLauncherSessionListeners();
        if (config.isLauncherSessionListenerAutoRegistrationEnabled()) {
            SERVICE_LOADER_REGISTRY.load(LauncherSessionListener.class).forEach(listenerRegistry::add);
        }
        config.getAdditionalLauncherSessionListeners().forEach(listenerRegistry::add);
        return listenerRegistry.getCompositeListener();
    }

    private static List<PostDiscoveryFilter> collectPostDiscoveryFilters(LauncherConfig config) {
        ArrayList<PostDiscoveryFilter> filters = new ArrayList<PostDiscoveryFilter>();
        if (config.isPostDiscoveryFilterAutoRegistrationEnabled()) {
            SERVICE_LOADER_REGISTRY.load(PostDiscoveryFilter.class).forEach(filters::add);
        }
        filters.addAll(config.getAdditionalPostDiscoveryFilters());
        return filters;
    }

    private static void registerLauncherDiscoveryListeners(LauncherConfig config, Launcher launcher) {
        if (config.isLauncherDiscoveryListenerAutoRegistrationEnabled()) {
            SERVICE_LOADER_REGISTRY.load(LauncherDiscoveryListener.class).forEach(xva$0 -> launcher.registerLauncherDiscoveryListeners((LauncherDiscoveryListener)xva$0));
        }
        config.getAdditionalLauncherDiscoveryListeners().forEach(xva$0 -> launcher.registerLauncherDiscoveryListeners((LauncherDiscoveryListener)xva$0));
    }

    private static void registerTestExecutionListeners(LauncherConfig config, Launcher launcher) {
        if (config.isTestExecutionListenerAutoRegistrationEnabled()) {
            LauncherFactory.loadAndFilterTestExecutionListeners().forEach(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
        }
        config.getAdditionalTestExecutionListeners().forEach(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
    }

    private static Stream<TestExecutionListener> loadAndFilterTestExecutionListeners() {
        Iterable<TestExecutionListener> listeners = SERVICE_LOADER_REGISTRY.load(TestExecutionListener.class);
        LauncherConfigurationParameters configurationParameters = LauncherConfigurationParameters.builder().build();
        String deactivatedListenersPattern = configurationParameters.get("junit.platform.execution.listeners.deactivate").orElse(null);
        return StreamSupport.stream(listeners.spliterator(), false).filter(ClassNamePatternFilterUtils.excludeMatchingClasses((String)deactivatedListenersPattern));
    }
}

