/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.services.alert.AlertEvent;
import org.lsst.ccs.services.alert.AlertListener;
import org.lsst.ccs.subsystem.common.devices.pluto.PlutoDevice;
import org.lsst.ccs.subsystem.refrig.constants.ChillerPLCState;
import org.lsst.ccs.subsystem.refrig.constants.ChillerPlcAlert;
import org.lsst.ccs.subsystem.refrig.constants.ConditionState;
import org.lsst.ccs.subsystem.refrig.constants.LatchState;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.ChillerPlcState;

public class ChillerPlutoDevice
extends PlutoDevice
implements AlertListener {
    private static final int NUM_AREAS = 14;
    private static final int SWDI_ON_BIT = 0;
    private static final int SWDI_OFF_BIT = 1;
    private static final int SWDI_READ_AREA = 2;
    private static final int SWDI_READ_BIT = 3;
    private static final int LTDI_RESET_BIT = 0;
    private static final int LTDI_READ_AREA = 1;
    private static final int LTDI_READ_BIT = 2;
    private static final int LTDI_PEND_AREA = 3;
    private static final int LTDI_PEND_BIT = 4;
    private static final int CNDI_READ_AREA = 0;
    private static final int CNDI_READ_BIT = 1;
    private static final int CLEAR_ALL_LATCHES_BIT = 5;
    private static final int PLC_STATUS_MASK = 1;
    private static final int ERROR_AREA = 11;
    private static final int[][] switches = new int[1][];
    private static final int[][] latches;
    private static final int[][] conditions;
    private static final Map<Integer, ChillerPlcAlert> latchAlertMap;
    private static final Map<String, Integer> revLatchAlertMap;
    private static final Map<Integer, ChillerPlcAlert> condAlertMap;

    public ChillerPlutoDevice() {
        super(14);
    }

    public void init() {
        super.init();
        for (ChillerPlcAlert alert : ChillerPlcAlert.values()) {
            this.alertService.registerAlert(alert.getAlert());
        }
        this.alertService.addListener((AlertListener)this);
    }

    public Boolean isPlcActive() {
        try {
            int status = this.plu.readModuleStatus();
            return (status & 1) != 0;
        }
        catch (DriverException e) {
            return null;
        }
    }

    public ChillerPLCState getPlcState() {
        Boolean isActive = this.isPlcActive();
        return isActive == null ? ChillerPLCState.OFFLINE : (isActive == false ? ChillerPLCState.PLC_DEAD : (this.isConditionActive(6) != false ? ChillerPLCState.RUNNING : ChillerPLCState.STOPPED));
    }

    protected void setSwitchOn(int sw, boolean on) {
        int bitNum = switches[sw][on ? 0 : 1];
        this.toggleBit(bitNum / 16, bitNum & 0xF);
    }

    public SwitchState getSwitchState(int sw) {
        Boolean isOn = this.isSwitchOn(sw);
        return isOn != null ? (isOn.booleanValue() ? SwitchState.ON : SwitchState.OFF) : SwitchState.OFFLINE;
    }

    protected Boolean isSwitchOn(int sw) {
        int[] swData = switches[sw];
        Integer value = this.readAddBit(swData[2], swData[3] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public Boolean isLatchActive(int cond) {
        int[] condData = latches[cond];
        Integer value = this.readAddBit(condData[1], condData[2] + 16);
        return value != null ? Boolean.valueOf(value == 0) : null;
    }

    public Boolean isLatchLatched(int cond) {
        int[] condData = latches[cond];
        Integer value = this.readAddBit(condData[3], condData[4] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public void clearLatch(int cond) {
        int bitNum = latches[cond][0];
        this.toggleBit(bitNum / 16, bitNum & 0xF);
    }

    public void clearAllLatches() {
        int bitNum = 5;
        this.toggleBit(bitNum / 16, bitNum & 0xF);
    }

    public Boolean isConditionActive(int cond) {
        int[] condData = conditions[cond];
        Integer value = this.readAddBit(condData[0], condData[1] + 16);
        return value != null ? Boolean.valueOf(value != 0) : null;
    }

    public int getErrorCode() {
        return this.readAddWord(11, 0);
    }

    public boolean updateState(ChillerPlcState plcState) {
        Boolean active;
        int cond;
        ChillerPLCState oldPlcState;
        boolean changed = false;
        ChillerPLCState newPlcState = this.getPlcState();
        if (newPlcState != (oldPlcState = plcState.getPlcState())) {
            changed = true;
            plcState.setPlcState(newPlcState);
            ChillerPlcAlert alert = ChillerPlcAlert.PLC_NOT_ALIVE;
            String plcDesc = "Chiller protection PLC ";
            if (newPlcState == ChillerPLCState.STOPPED || newPlcState == ChillerPLCState.RUNNING) {
                if (oldPlcState != ChillerPLCState.STOPPED && oldPlcState != ChillerPLCState.RUNNING) {
                    this.lowerAlert(alert, plcDesc + "is alive");
                }
            } else {
                String errDesc = newPlcState == ChillerPLCState.PLC_DEAD ? "has died: error = " + this.getErrorCode() : "is offline";
                this.raiseAlarm(alert, plcDesc + errDesc);
            }
        }
        for (int sw = 0; sw < 1; ++sw) {
            SwitchState state = this.getSwitchState(sw);
            if (state == plcState.getSwitchState(sw)) continue;
            plcState.setSwitchState(sw, state);
            changed = true;
        }
        for (cond = 0; cond < 7; ++cond) {
            LatchState oldState;
            active = this.isLatchActive(cond);
            Boolean latched = this.isLatchLatched(cond);
            LatchState state = active == null || latched == null ? LatchState.OFFLINE : (latched != false ? LatchState.LATCHED : (active != false ? LatchState.ACTIVE : LatchState.CLEAR));
            if (state == (oldState = plcState.getLatch(cond))) continue;
            plcState.setLatch(cond, state);
            ChillerPlcAlert alert = latchAlertMap.get(cond);
            if (state == LatchState.ACTIVE) {
                this.raiseAlarm(alert, "Chiller protection PLC error condition set");
            } else if (state != LatchState.OFFLINE) {
                if (oldState != LatchState.ACTIVE && state == LatchState.LATCHED) {
                    this.raiseAlarm(alert, "Chiller protection PLC error condition set");
                }
                if (oldState == LatchState.ACTIVE || state == LatchState.LATCHED) {
                    this.lowerAlert(alert, "Chiller protection PLC error condition cleared");
                }
            }
            changed = true;
        }
        for (cond = 0; cond < 12; ++cond) {
            ConditionState state;
            active = this.isConditionActive(cond);
            ConditionState conditionState = active == null ? ConditionState.OFF : (state = active != false ? ConditionState.YES : ConditionState.NO);
            if (state == plcState.getCondition(cond)) continue;
            plcState.setCondition(cond, state);
            ChillerPlcAlert alert = condAlertMap.get(cond);
            if (alert != null) {
                if (state == ConditionState.NO) {
                    this.raiseWarning(alert, "Chiller protection PLC warning condition set");
                } else if (state == ConditionState.YES) {
                    this.lowerAlert(alert, "Chiller protection PLC warning condition cleared");
                }
            }
            changed = true;
        }
        return changed;
    }

    private void raiseAlarm(ChillerPlcAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.ALARM, cond);
    }

    private void raiseWarning(ChillerPlcAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.WARNING, cond);
    }

    private void lowerAlert(ChillerPlcAlert alert, String cond) {
        this.alertService.raiseAlert(alert.getAlert(), AlertState.NOMINAL, cond);
    }

    public void onAlert(AlertEvent event) {
        if (event.getType() != AlertEvent.AlertEventType.ALERT_CLEARED) {
            return;
        }
        for (String id : event.getClearedIds()) {
            Integer cond = revLatchAlertMap.get(id);
            if (cond == null) continue;
            this.clearLatch(cond);
        }
    }

    static {
        ChillerPlutoDevice.switches[0] = new int[]{0, 1, 13, 4};
        latches = new int[7][];
        ChillerPlutoDevice.latches[0] = new int[]{2, 10, 1, 10, 3};
        ChillerPlutoDevice.latches[1] = new int[]{3, 10, 5, 10, 7};
        ChillerPlutoDevice.latches[2] = new int[]{7, 10, 9, 10, 11};
        ChillerPlutoDevice.latches[3] = new int[]{4, 12, 1, 12, 3};
        ChillerPlutoDevice.latches[4] = new int[]{6, 12, 9, 12, 11};
        ChillerPlutoDevice.latches[5] = new int[]{8, 11, 3, 11, 5};
        ChillerPlutoDevice.latches[6] = new int[]{9, 11, 11, 11, 13};
        conditions = new int[12][];
        ChillerPlutoDevice.conditions[0] = new int[]{13, 0};
        ChillerPlutoDevice.conditions[1] = new int[]{13, 1};
        ChillerPlutoDevice.conditions[2] = new int[]{13, 2};
        ChillerPlutoDevice.conditions[3] = new int[]{13, 3};
        ChillerPlutoDevice.conditions[4] = new int[]{13, 4};
        ChillerPlutoDevice.conditions[5] = new int[]{13, 5};
        ChillerPlutoDevice.conditions[6] = new int[]{13, 6};
        ChillerPlutoDevice.conditions[7] = new int[]{13, 7};
        ChillerPlutoDevice.conditions[8] = new int[]{13, 8};
        ChillerPlutoDevice.conditions[9] = new int[]{13, 9};
        ChillerPlutoDevice.conditions[10] = new int[]{13, 10};
        ChillerPlutoDevice.conditions[11] = new int[]{13, 11};
        latchAlertMap = new HashMap<Integer, ChillerPlcAlert>();
        latchAlertMap.put(0, ChillerPlcAlert.SMOKE_DETC);
        latchAlertMap.put(5, ChillerPlcAlert.LEAK_DETC);
        latchAlertMap.put(6, ChillerPlcAlert.LEAK_DETC_FAULT);
        latchAlertMap.put(1, ChillerPlcAlert.NO_PERMIT);
        latchAlertMap.put(2, ChillerPlcAlert.EXT_EMO);
        latchAlertMap.put(3, ChillerPlcAlert.BD_SUPPLY_ERROR);
        latchAlertMap.put(4, ChillerPlcAlert.BD_RETURN_ERROR);
        revLatchAlertMap = new HashMap<String, Integer>();
        for (Map.Entry<Integer, ChillerPlcAlert> e : latchAlertMap.entrySet()) {
            revLatchAlertMap.put(e.getValue().getId(), (int)e.getKey());
        }
        condAlertMap = new HashMap<Integer, ChillerPlcAlert>();
        condAlertMap.put(8, ChillerPlcAlert.BD_SUPPLY_WARN);
        condAlertMap.put(10, ChillerPlcAlert.BD_RETURN_WARN);
    }
}

