/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.refrig;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20DiscControl;
import org.lsst.ccs.subsystem.refrig.ChillerPlutoDevice;
import org.lsst.ccs.subsystem.refrig.constants.ChillerLatches;
import org.lsst.ccs.subsystem.refrig.constants.SwitchState;
import org.lsst.ccs.subsystem.refrig.data.ChillerPlcTestState;
import org.lsst.ccs.subsystem.refrig.data.RefrigException;

public class ChillerPlcTest
extends Subsystem
implements HasLifecycle,
AgentPresenceListener {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private ChillerPlutoDevice devPluto;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Maq20DiscControl[] maq20Ctrl;
    private static final Logger LOG = Logger.getLogger(ChillerPlcTest.class.getName());
    private final ChillerPlcTestState controlState = new ChillerPlcTestState();
    private boolean gotCommand;

    public ChillerPlcTest() {
        super("chiller", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        AgentPeriodicTask ucs = new AgentPeriodicTask("updateCtrlState", () -> this.updateControlState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(ucs);
    }

    public void init() {
        this.propertiesService.setAgentProperty("ChillerPlcTest", ChillerPlcTest.class.getCanonicalName());
        if (this.devPluto == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Pluto device", (String)"not specified");
        }
        if (this.maq20Ctrl == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Maq20 controls", (String)"not specified");
        }
        if (this.maq20Ctrl.length < 2) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"Maq20 controls", (String)"must have at least two elements");
        }
    }

    public void postStart() {
    }

    public void shutdown() {
    }

    @Command(type=Command.CommandType.QUERY, description="Get the chiller state", level=0)
    public ChillerPlcTestState getControlState() {
        return this.controlState;
    }

    @Command(type=Command.CommandType.ACTION, description="Block or enable chiller operation")
    public void blockChiller(boolean on) {
        this.gotCommand = true;
        this.devPluto.setSwitchOn(0, on);
    }

    @Command(type=Command.CommandType.QUERY, description="Get latched PLC condition names", level=0)
    public List<String> getPlcLatchNames() {
        return ChillerLatches.getNames();
    }

    @Command(type=Command.CommandType.ACTION, description="Clear a latched PLC condition")
    public void clearPlcLatch(@Argument(description="The condition name") String cond) throws RefrigException {
        this.gotCommand = true;
        this.devPluto.clearLatch(ChillerLatches.getId(cond));
    }

    @Command(type=Command.CommandType.ACTION, description="Set a latched PLC condition")
    public void setPlcLatch(@Argument(description="The condition number") int cond, @Argument(description="Whether on or off") boolean on) throws RefrigException {
        this.gotCommand = true;
        try {
            this.maq20Ctrl[cond / 5].setLineOn(cond % 5, on);
        }
        catch (DriverException e) {
            throw new RefrigException("Error setting MAQ20 line: " + e);
        }
    }

    private void updateControlState() {
        boolean changed = this.gotCommand;
        for (int cond = 0; cond < 10; ++cond) {
            SwitchState state;
            Boolean on = this.maq20Ctrl[cond / 5].isLineOn(cond % 5);
            SwitchState switchState = on == null ? SwitchState.OFFLINE : (state = on != false ? SwitchState.ON : SwitchState.OFF);
            if (state == this.controlState.getSwitchState(cond)) continue;
            this.controlState.setSwitchState(cond, state);
            changed = true;
        }
        if (changed |= this.devPluto.updateState(this.controlState.getPlcState())) {
            this.publishControlState();
        }
        this.gotCommand = false;
    }

    private void publishControlState() {
        this.publishSubsystemDataOnStatusBus(new KeyValueData("ChillerPlcTestState", (Serializable)this.controlState));
    }
}

