/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class CreateSequenceTable {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");

    public static void main(String[] args) throws SQLException {
        String propertiesFile = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.localdb.database.connection.file", "statusPersister.properties");
        Properties p = BootstrapResourceUtils.getBootstrapProperties((String)propertiesFile);
        String[] connSplit = p.getProperty("hibernate.connection.url", "").split("/");
        String schemaName = connSplit[connSplit.length - 1];
        try (Connection connection = DriverManager.getConnection(p.getProperty("hibernate.connection.url") + "?user=" + p.getProperty("hibernate.connection.username") + "&password=" + p.getProperty("hibernate.connection.password"));){
            connection.setSchema(schemaName);
            PreparedStatement ps = connection.prepareStatement("show tables like 'ccs_enhanced_sequence'");
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                log.info((Object)"creating ccs_enhanced_sequence table");
                connection.prepareStatement("CREATE TABLE `ccs_enhanced_sequence` (`next_val` bigint(20) DEFAULT NULL)").execute();
                connection.prepareStatement("insert into ccs_enhanced_sequence(next_val)  values((select max(id)+1 from ccs_statTimeInterval))").execute();
            }
            System.out.println("done");
        }
    }
}

