/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.vacuum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.auxelex.IonPump;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.trendserver.TrendingClientService;
import org.lsst.ccs.localdb.utils.TrendingConnectionUtils;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.vacuum.IonPumpControl;
import org.lsst.ccs.subsystem.vacuum.SwitchDevice;
import org.lsst.ccs.subsystem.vacuum.data.VacuumException;

public class IonPumpDevice
extends Device
implements SwitchDevice {
    public static final int CHAN_HIP1 = 0;
    public static final int CHAN_HIP2 = 1;
    public static final int CHAN_OIP = 2;
    public static final int CHAN_CIP1 = 3;
    public static final int CHAN_CIP2 = 4;
    public static final int CHAN_CIP3 = 5;
    public static final int CHAN_CIP4 = 6;
    public static final int CHAN_CIP5 = 7;
    public static final int CHAN_CIP6 = 8;
    private static final int MON_TYPE_VOLTAGE = 0;
    private static final int MON_TYPE_CURRENT = 1;
    private static final int MON_TYPE_POWER = 2;
    private static final int MON_TYPE_USAGE = 3;
    private static final int MON_TYPE_LIFETIME = 4;
    private static final String IP_ADDRESS = "ipAddr";
    private static final Map<String, Integer> mTypeMap = new HashMap<String, Integer>();
    private static final int CHECK_INTERVAL = 10000;
    private static final double MAX_USAGE = 0.0375;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private TrendingClientService trendingService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, IonPumpControl> ctrlChans = new LinkedHashMap<String, IonPumpControl>();
    @ConfigurationParameter(name="ipAddr", category="Cryo", isFinal=true, units="unitless", description="The Ion Pump IP address")
    private volatile String ipAddr;
    private static final Logger LOG;
    private final IonPump ipc = new IonPump();
    private TrendingConnectionUtils trendingUtils;
    private boolean trendingError = false;
    private boolean usageInited = false;
    private final Map<String, Integer> usageChannelMap = new HashMap<String, Integer>();
    private final double[] savedUsage = new double[9];
    private final double[] accumUsage = new double[9];
    private final long[] updateTime = new long[9];
    private Channel cryoPressure;
    private Channel hxPressure;
    private long checkTime = 0L;
    private boolean initError = false;

    public IonPumpDevice() {
        System.setProperty("org.lsst.ccs.agent.usesTrending", "true");
        Arrays.fill(this.savedUsage, Double.NaN);
        Arrays.fill(this.accumUsage, 0.0);
    }

    public void postStart() {
        StringBuilder missingChans = new StringBuilder();
        for (int chan = 0; chan < 9; ++chan) {
            if (this.usageChannelMap.values().contains(chan)) continue;
            missingChans.append(" ").append(chan);
        }
        if (missingChans.length() != 0) {
            LOG.log(Level.INFO, "Ion pump {0} has no usage monitoring item for the following channels:{1}", new Object[]{this.name, missingChans});
        }
        this.initSavedTime();
    }

    protected void initDevice() {
        if (this.ipAddr == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)IP_ADDRESS, (String)"is missing");
        }
        this.fullName = "Ion pump controller (" + this.ipAddr + ")";
    }

    protected void initialize() {
        try {
            this.ipc.open(this.ipAddr);
            for (IonPumpControl ctrl : this.ctrlChans.values()) {
                ctrl.writeVoltage();
                ctrl.writeCurrent();
                ctrl.writePower();
            }
            this.initSensors();
            LOG.log(Level.INFO, "Connected to {0}", this.fullName);
            this.initError = false;
            this.setOnline(true);
        }
        catch (DriverException | VacuumException e) {
            if (!this.initError) {
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
            try {
                this.ipc.close();
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
    }

    protected void close() {
        try {
            this.ipc.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}: {1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int hwChan;
        String type = ch.getTypeStr();
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"type", (Object)type);
        }
        if ((hwChan = ch.getHwChan()) < 0 || hwChan >= 9) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"hw channel number", (Object)hwChan);
        }
        if (mType == 3) {
            this.usageChannelMap.put(ch.getPath(), hwChan);
        }
        return new int[]{mType, 0};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double readChannel(Channel ch) {
        double value = Double.NaN;
        String item = null;
        if (this.isOnline()) {
            int hwChan = ch.getHwChan();
            try {
                switch (ch.getType()) {
                    case 0: {
                        item = "voltage";
                        value = this.ipc.readVoltage(hwChan);
                        break;
                    }
                    case 1: {
                        item = "current";
                        value = this.ipc.readCurrent(hwChan);
                        break;
                    }
                    case 2: {
                        item = "power";
                        value = this.ipc.readPower(hwChan);
                        break;
                    }
                    case 3: {
                        long time = System.currentTimeMillis();
                        if (time - this.checkTime >= 10000L) {
                            this.initSavedTime();
                            this.checkTime = time;
                        }
                        Map<String, Integer> map = this.usageChannelMap;
                        synchronized (map) {
                            if (this.updateTime[hwChan] != 0L && this.isChannelOn(hwChan) == Boolean.TRUE) {
                                double pressure;
                                double d = pressure = hwChan == 0 || hwChan == 1 ? this.hxPressure.getValue() : this.cryoPressure.getValue();
                                if (!Double.isNaN(pressure)) {
                                    int n = hwChan;
                                    this.accumUsage[n] = this.accumUsage[n] + (double)(time - this.updateTime[hwChan]) * pressure / 3600000.0;
                                }
                            }
                            this.updateTime[hwChan] = time;
                            value = this.accumUsage[hwChan] + this.savedUsage[hwChan];
                            break;
                        }
                    }
                    case 4: {
                        if (this.isChannelOn(hwChan) != Boolean.TRUE) break;
                        value = (0.0375 - this.savedUsage[hwChan] - this.accumUsage[hwChan]) / (hwChan == 0 || hwChan == 1 ? this.hxPressure.getValue() : this.cryoPressure.getValue());
                    }
                }
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.fullName, item, e});
                this.setOnline(false);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSavedTime() {
        if (this.usageInited) {
            return;
        }
        this.trendingUtils = this.trendingService.getBusTrendingConnection();
        if (this.trendingUtils == null) {
            if (!this.trendingError) {
                LOG.log(Level.SEVERE, "Trending data cannot be accessed");
                this.trendingError = true;
            }
            return;
        }
        if (this.trendingError) {
            LOG.log(Level.INFO, "Trending data can now be accessed");
            this.trendingError = false;
        }
        Map<String, Integer> map = this.usageChannelMap;
        synchronized (map) {
            for (Map.Entry<String, Integer> e : this.usageChannelMap.entrySet()) {
                double value;
                if (!Double.isNaN(this.savedUsage[e.getValue()])) continue;
                String chName = this.subsys.getName() + "/" + e.getKey();
                TrendingData data = this.trendingUtils.getLatestData(chName);
                double d = value = data == null ? Double.NaN : data.getValue("value");
                if (Double.isNaN(value)) {
                    LOG.log(Level.WARNING, "No trending data present for ion pump channel {0}", chName);
                    value = 0.0;
                } else {
                    LOG.log(Level.INFO, "Got trending data for ion pump channel {0}", chName);
                }
                this.savedUsage[e.getValue().intValue()] = value;
            }
        }
        this.usageInited = true;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Get the set of usage channel names")
    public Set<String> getUsageChannelNames() {
        return new HashSet<String>(this.usageChannelMap.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Set the value for a usage monitoring channel", level=50)
    public void setUsageValue(@Argument(description="Channel name") String chanName, @Argument(description="Usage value") double usage) throws VacuumException {
        Integer hwChan = this.usageChannelMap.get(chanName);
        if (hwChan == null) {
            throw new VacuumException("Invalid usage channel name: " + chanName);
        }
        Map<String, Integer> map = this.usageChannelMap;
        synchronized (map) {
            this.savedUsage[hwChan.intValue()] = usage - this.accumUsage[hwChan];
        }
    }

    void setCryoPressureChannel(Channel pressure) {
        this.cryoPressure = pressure;
    }

    void setHxPressureChannel(Channel pressure) {
        this.hxPressure = pressure;
    }

    protected void setChannelOn(int chan, boolean on) {
        try {
            if (on) {
                this.ipc.powerOn(chan);
            } else {
                this.ipc.powerOff(chan);
            }
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error setting channel {0} on {1}", new Object[]{chan, this.fullName});
        }
    }

    protected Boolean isChannelOn(int chan) {
        if (!this.isOnline()) {
            return null;
        }
        try {
            return this.ipc.isPowered(chan);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting state for channel {0} on {1}", new Object[]{chan, this.fullName});
            return null;
        }
    }

    public List<String> getChannelNames() {
        return new ArrayList<String>(this.ctrlChans.keySet());
    }

    public List<Integer> getChannelNumbers() {
        ArrayList<Integer> chans = new ArrayList<Integer>();
        for (IonPumpControl ctrl : this.ctrlChans.values()) {
            chans.add(ctrl.getHwChan());
        }
        return chans;
    }

    void setVoltage(int chan, double value) throws VacuumException {
        try {
            this.ipc.setVoltage(chan, value);
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    void setCurrent(int chan, double value) throws VacuumException {
        try {
            this.ipc.setCurrent(chan, value);
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    void setPower(int chan, double value) throws VacuumException {
        try {
            this.ipc.setPower(chan, value);
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    @Override
    public int getSwitchDevice() {
        return 1;
    }

    @Override
    public void setSwitch(int sw, boolean on) {
        this.setChannelOn(sw, on);
    }

    @Override
    public Boolean isSwitchOn(int sw) {
        return this.isChannelOn(sw);
    }

    void powerOn(int chan) throws VacuumException {
        try {
            this.ipc.powerOn(chan);
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    void powerOff(int chan) throws VacuumException {
        try {
            this.ipc.powerOff(chan);
        }
        catch (DriverException e) {
            throw new VacuumException((Exception)((Object)e));
        }
    }

    double[] getUsage() {
        double[] usage = new double[9];
        for (int j = 0; j < 9; ++j) {
            usage[j] = this.savedUsage[j] + this.accumUsage[j];
        }
        return usage;
    }

    private IonPumpControl getControl(String name) throws VacuumException {
        IonPumpControl ctrl = this.ctrlChans.get(name);
        if (ctrl == null) {
            throw new VacuumException("Unrecognized ion pump name: " + name);
        }
        return ctrl;
    }

    static {
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
        mTypeMap.put("POWER", 2);
        mTypeMap.put("USAGE", 3);
        mTypeMap.put("LIFETIME", 4);
        LOG = Logger.getLogger(IonPumpDevice.class.getName());
    }
}

