/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.image.compression.hdu;

import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.header.Compression;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.image.compression.hdu.BackupRestoreUnCompressedHeaderCard;
import nom.tam.image.compression.hdu.CompressedTableData;
import nom.tam.util.ColumnTable;
import nom.tam.util.Cursor;
import nom.tam.util.type.PrimitiveTypes;

public class CompressedTableHDU
extends BinaryTableHDU {
    public static CompressedTableHDU fromBinaryTableHDU(BinaryTableHDU binaryTableHDU, int tileRows, String ... columnCompressionAlgorithms) throws FitsException {
        Header header = new Header();
        CompressedTableData compressedData = new CompressedTableData();
        int rowsPerTile = tileRows > 0 ? tileRows : ((BinaryTable)binaryTableHDU.getData()).getNRows();
        compressedData.setRowsPerTile(rowsPerTile);
        compressedData.fillHeader(header);
        Cursor<String, HeaderCard> headerIterator = header.iterator();
        Cursor<String, HeaderCard> imageIterator = binaryTableHDU.getHeader().iterator();
        while (imageIterator.hasNext()) {
            HeaderCard card = (HeaderCard)imageIterator.next();
            BackupRestoreUnCompressedHeaderCard.restore(card, headerIterator);
        }
        CompressedTableHDU compressedImageHDU = new CompressedTableHDU(header, compressedData);
        compressedData.setColumnCompressionAlgorithms(columnCompressionAlgorithms);
        compressedData.prepareUncompressedData((ColumnTable<BinaryTable.SaveState>)((BinaryTable)binaryTableHDU.getData()).getData());
        return compressedImageHDU;
    }

    public static boolean isHeader(Header hdr) {
        return hdr.getBooleanValue(Compression.ZTABLE, false);
    }

    public static CompressedTableData manufactureData(Header hdr) throws FitsException {
        return new CompressedTableData(hdr);
    }

    public CompressedTableHDU(Header hdr, CompressedTableData datum) {
        super(hdr, datum);
    }

    public BinaryTableHDU asBinaryTableHDU() throws FitsException {
        Header header = new Header();
        header.addValue((IFitsHeader)Standard.XTENSION, "BINTABLE");
        header.addValue((IFitsHeader)Standard.BITPIX, PrimitiveTypes.BYTE.bitPix());
        header.addValue((IFitsHeader)Standard.NAXIS, 2);
        Cursor<String, HeaderCard> headerIterator = header.iterator();
        Cursor<String, HeaderCard> iterator = this.getHeader().iterator();
        while (iterator.hasNext()) {
            HeaderCard card = (HeaderCard)iterator.next();
            BackupRestoreUnCompressedHeaderCard.backup(card, headerIterator);
        }
        BinaryTable data = BinaryTableHDU.manufactureData(header);
        BinaryTableHDU tableHDU = new BinaryTableHDU(header, data);
        this.getData().asBinaryTable(data, this.getHeader(), header);
        return tableHDU;
    }

    public CompressedTableHDU compress() throws FitsException {
        this.getData().compress(this.getHeader());
        return this;
    }

    @Override
    public CompressedTableData getData() {
        return (CompressedTableData)super.getData();
    }
}

