/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;

@SkipEncoding
public abstract class AdditionalFile
implements Serializable {
    private final String fileName;
    private final String fileType;
    private final ImageName obsId;
    private float version;
    private final String mimeType;
    private static final long serialVersionUID = 1L;
    public static final String EVENT_KEY = "additionalFile";
    static final float DEFAULT_VERSION = 1.0f;

    public AdditionalFile(String fileName, String fileType, ImageName obsId, float version, String mimeType) {
        this.fileName = fileName;
        this.obsId = obsId;
        this.fileType = fileType;
        this.version = version;
        this.mimeType = mimeType;
    }

    public AdditionalFile(String fileName, String fileType, ImageName obsId, float version) {
        this(fileName, fileType, obsId, version, null);
    }

    public AdditionalFile(String fileName, String fileType, ImageName obsId) {
        this(fileName, fileType, obsId, 1.0f, null);
    }

    public String getFileName() {
        return this.fileName;
    }

    public ImageName getObsId() {
        return this.obsId;
    }

    public String getFileType() {
        return this.fileType;
    }

    public float getVersion() {
        return this.version == 0.0f ? 1.0f : this.version;
    }

    public void setVersion(float version) {
        this.version = version;
    }

    public String getMimeType() {
        if (this.mimeType == null) {
            String guessedMimeType = "text/plain";
            if (this.fileName.endsWith("json")) {
                guessedMimeType = "application/json";
            } else if (this.fileName.endsWith("csv")) {
                guessedMimeType = "text/csv";
            }
            return guessedMimeType;
        }
        return this.mimeType;
    }

    public long computeFileSizeAndChecksum(Checksum cksum32) throws IOException {
        try (CountOutputStream cnos = new CountOutputStream();){
            long l;
            try (CheckedOutputStream cos = new CheckedOutputStream(cnos, cksum32);){
                this.writeFile(cos);
                cos.flush();
                l = cnos.getByteCount();
            }
            return l;
        }
    }

    public abstract void writeFile(OutputStream var1) throws IOException;

    public String toString() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeFile(baos);
            baos.close();
            return baos.toString();
        }
        catch (IOException x) {
            return x.toString();
        }
    }

    private class CountOutputStream
    extends OutputStream {
        long byteCount = 0L;

        private CountOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            ++this.byteCount;
        }

        long getByteCount() {
            return this.byteCount;
        }
    }
}

