/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs.common;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.subsystems.fcs.EPOSEnumerations;
import org.lsst.ccs.subsystems.fcs.FcsAlerts;
import org.lsst.ccs.subsystems.fcs.common.EPOSController;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public interface EPOSControllerForCarousel
extends EPOSController {
    public int getPositionSensorType();

    public void setPositionSensorType(int var1);

    public void setHoldingBrakes(boolean var1);

    public boolean isHoldingBrakes();

    @Override
    default public boolean isTargetReached() {
        return (this.getStatusWord() >> 10 & 1) == 1;
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="GoToSwitchOnDisabled and set PositionSensorType to Absolute encoder SSI : 4")
    default public void setPositionSensorTypeEncoderSSI() {
        FCSLOG.info(this.getName() + " setting PositionSensorType Absolute encoder SSI");
        long beginTime = System.currentTimeMillis();
        int nbTryMax = 15;
        int nbRecoverMax = 4;
        boolean controlerFailed = false;
        boolean swapDone = false;
        int i = 0;
        while (i++ < nbTryMax && !swapDone) {
            this.goToSwitchOnDisabled();
            this.doSetEncoderSSI();
            int ssiPosition = this.readSSIPosition();
            if (Math.abs(ssiPosition) <= 1) {
                FCSLOG.info("Error after doSetEncoderSSI, ssiPosition = " + ssiPosition + ". We go back to TypeSinusIncrementalEncoder and retry (" + i + "/" + nbTryMax + ")");
                this.doSetSinusIncrementalEncoder();
            } else {
                swapDone = true;
            }
            this.updateEposState();
            boolean inFault = this.isInState(EPOSEnumerations.EposState.FAULT);
            if (!inFault) continue;
            swapDone = false;
            FCSLOG.info("StatusWord= " + this.readStatusWord() + ", FAULT= " + inFault);
            if (controlerFailed) {
                this.raiseAlarm(FcsAlerts.IN_FAULT, "Controller faulted too many times while trying to change Carousel mode. Carousel's controller in fault, should be resetted manually.", this.getName());
                this.checkFault();
                return;
            }
            controlerFailed = true;
            this.updateEposState();
            int j = 0;
            while (j++ < nbRecoverMax && this.isInState(EPOSEnumerations.EposState.FAULT)) {
                FcsUtils.sleep(200, "Sleep before fault reset");
                this.writeControlWord(EPOSEnumerations.ControlWord.DISABLE_VOLTAGE);
                FcsUtils.sleep(10, "Sleep after controler disable voltage");
                this.writeControlWord(EPOSEnumerations.ControlWord.FAULT_RESET);
                FcsUtils.sleep(200, "Sleep after fault reset");
                this.updateEposState();
            }
            if (this.isInState(EPOSEnumerations.EposState.FAULT)) {
                this.raiseAlarm(FcsAlerts.IN_FAULT, "We failed to clear the controller's error " + nbRecoverMax + " times in a row for " + j * 2 * 200 + "ms, while trying to change Carousel mode. Carousel's controller in fault, should be resetted manually.", this.getName());
                this.checkFault();
            } else {
                this.raiseWarning(FcsAlerts.HARDWARE_ERROR, "We successfully cleared the controller's error in " + j + " tries in " + j * 2 * 200 + "ms.", this.getName());
            }
            this.doSetSinusIncrementalEncoder();
        }
        if (swapDone) {
            FCSLOG.info("We successfully switched the controller mode to absolute/SSI. It took " + i + " tries in" + (beginTime - System.currentTimeMillis()) + "ms.");
            return;
        }
        this.raiseAlarm(FcsAlerts.HARDWARE_ERROR, " after setPositionSensorTypeEncoderSSI, ssiPosition = " + this.readSSIPosition() + " we go back to TypeSinusIncrementalEncoder", this.getName());
        this.doSetSinusIncrementalEncoder();
    }

    default public void doSetEncoder(int val) {
        int controllerStructure = this.readControllerStructure();
        int valueToWrite = controllerStructure == 0 ? val : val + 512;
        this.writeParameter(EPOSEnumerations.EposParameter.PositionSensorType, valueToWrite);
        FcsUtils.sleep(80, "Switch encoder mode");
        this.checkPositionSensorType(valueToWrite);
    }

    default public void doSetEncoderSSI() {
        this.doSetEncoder(4);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="GoToSwitchOnDisabled and set PositionSensorType to Sinus Incremental Encoder : 8")
    default public void setPositionSensorTypeSinusIncrementalEncoder() {
        FCSLOG.info(this.getName() + " setting PositionSensorType Sinus Incremental Encoder");
        this.goToSwitchOnDisabled();
        this.doSetSinusIncrementalEncoder();
    }

    default public void doSetSinusIncrementalEncoder() {
        int val = 8;
        int controllerStructure = this.readControllerStructure();
        int valueToWrite = controllerStructure == 0 ? val : val + 512;
        this.writeParameter(EPOSEnumerations.EposParameter.PositionSensorType, valueToWrite);
        this.checkPositionSensorType(valueToWrite);
    }

    default public void checkPositionSensorType(int sensortype) {
        FcsUtils.checkAndWaitConditionWithTimeoutAndFixedDelay(() -> (long)sensortype == this.readParameter(EPOSEnumerations.EposParameter.PositionSensorType), null, this.getName() + " check position sensory type is " + sensortype + " after switching mode ", this.getName() + ": couldn't change position sensor type during time allocated of 500ms", 500L, 2L);
        this.setPositionSensorType(sensortype);
    }

    @Override
    @Command(type=Command.CommandType.ACTION, level=3, description="Define the actual position as position given as argument.")
    default public void defineAbsolutePosition(int position) {
        FCSLOG.finer(() -> this.getName() + " Defining Absolute Position:" + position);
        this.changeMode(EPOSEnumerations.EposMode.HOMING);
        if (EPOSEnumerations.EposMode.HOMING != this.readMode()) {
            FcsUtils.sleep(500, "Controller change mode");
            this.changeMode(EPOSEnumerations.EposMode.HOMING);
        }
        this.checkEposMode(EPOSEnumerations.EposMode.HOMING);
        this.writeParameter(EPOSEnumerations.EposParameter.HomePosition, position);
        this.writeParameter(EPOSEnumerations.EposParameter.HomingMethod, 35);
        this.goToOperationEnable();
        this.writeControlWord(EPOSEnumerations.ControlWord.ABSOLUTE_POSITION);
        this.checkHomingDone();
    }

    default public void activatePowerSave() {
        int val = (int)this.readParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityState);
        this.writeParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityState, FcsUtils.force2one(val, 13));
        this.publishData();
        FCSLOG.info(this.getName() + ": POWER SAVE activated.");
    }

    default public void deactivatePowerSave() {
        int val = (int)this.readParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityState);
        this.writeParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityState, FcsUtils.force2zero(val, 13));
        this.publishData();
        FCSLOG.info(this.getName() + ": POWER SAVE deactivate command executed.");
    }

    @Command(type=Command.CommandType.QUERY, level=1, description="Read bit holding brake into DigitalOutputFonctionnalityState. For carousel. index:2078 subindex:1 bit:2")
    default public boolean readHoldingBrakes() {
        int digitalOutput = (int)this.readParameter(EPOSEnumerations.EposParameter.DigitalOutputFonctionnalityState);
        boolean holdingBrakes = (digitalOutput >> 2 & 1) == 1;
        this.setHoldingBrakes(holdingBrakes);
        return holdingBrakes;
    }
}

