/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.fcs;

import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.subsystems.fcs.FcsEnumerations;
import org.lsst.ccs.subsystems.fcs.utils.FcsUtils;

public class Filter {
    @LookupName
    private String name;
    @ConfigurationParameter(description="Filter identification number as coded on its frame and read with 6 hall effect sensors", range="0..63", units="unitless", category="filter")
    private volatile int filterID;
    @ConfigurationParameter(description="Weight of the filter", range="0..100", units="kg", category="filter")
    private volatile double weight;
    @ConfigurationParameter(description="Filter family: Science | Dummy | French dummy | Test | Open | Unknown | None", units="unitless", category="filter")
    private volatile FcsEnumerations.FilterFamily family;
    @ConfigurationParameter(description="Autochanger delta STANDBY position to be used to store this filter on carousel", units="micron", category="filter")
    private volatile int deltaAutochangerStandbyPosition;

    public Filter() {
    }

    Filter(int filterID, double weight, FcsEnumerations.FilterFamily family, int deltaAutochangerStandbyPosition) {
        this.filterID = filterID;
        this.weight = weight;
        this.family = family;
        this.deltaAutochangerStandbyPosition = deltaAutochangerStandbyPosition;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Filter identification number")
    public int getFilterID() {
        return this.filterID;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Filter weight")
    public double getWeight() {
        return this.weight;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Filter family")
    public FcsEnumerations.FilterFamily getFamily() {
        return this.family;
    }

    @Command(type=Command.CommandType.QUERY, level=0, description="Autochanger delta to apply when storing in carousel")
    public int getDeltaAutochangerStandbyPosition() {
        return this.deltaAutochangerStandbyPosition;
    }

    public String getObservatoryName() {
        if (this.filterID == 0) {
            return "NONE";
        }
        return String.format("%s_%d", this.name, this.filterID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Filter: " + FcsUtils.padLeft(this.name, 4) + " | ");
        sb.append("ID: " + FcsUtils.padLeft(Integer.toString(this.filterID), 2) + " | ");
        sb.append("Weight: " + FcsUtils.padLeft(Double.toString(this.weight) + "kg", 6) + " | ");
        sb.append("Family: " + FcsUtils.padLeft(this.family.getFamilyName(), 29) + " | ");
        sb.append("DeltaAutochangerStandbyPosition: " + this.deltaAutochangerStandbyPosition);
        return sb.toString();
    }
}

