/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.image;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.image.HeaderSpecification;

public class FitsHeadersSpecificationsBuilder {
    private final Map<String, HeaderSpecification> headerSpecificationsMap = new LinkedHashMap<String, HeaderSpecification>();
    static final Logger LOG = Logger.getLogger(FitsHeadersSpecificationsBuilder.class.getName());

    public final void addSpecFile(String fileName) {
        this.readHeaderSpecification(fileName, null);
    }

    public final void addSpecFile(String fileName, String headerName) {
        this.readHeaderSpecification(fileName, headerName);
    }

    public final Map<String, HeaderSpecification> getHeaderSpecifications() {
        return Collections.unmodifiableMap(this.headerSpecificationsMap);
    }

    private void readHeaderSpecification(String name, String headerName) throws RuntimeException {
        Object fileName;
        Object object = fileName = name.endsWith(".spec") ? name : name + ".spec";
        if (headerName == null) {
            headerName = ((String)fileName).replace(".spec", "");
        }
        try (InputStream bootstrapResource = BootstrapResourceUtils.getBootstrapResource((String)fileName);){
            if (bootstrapResource == null) {
                LOG.log(Level.SEVERE, "Failed to open spec file {0}", fileName);
                return;
            }
            if (this.headerSpecificationsMap.containsKey(headerName)) {
                HeaderSpecification desc = this.headerSpecificationsMap.get(headerName);
                desc.loadHeaderSpecification(bootstrapResource);
            } else {
                HeaderSpecification desc = new HeaderSpecification(headerName, bootstrapResource);
                this.headerSpecificationsMap.put(headerName, desc);
            }
            LOG.log(Level.FINE, "Loaded fits header spec file {0} {1}. Already loaded spec files: {2}", new Object[]{fileName, headerName, this.headerSpecificationsMap.keySet()});
        }
        catch (IOException x) {
            throw new RuntimeException("Error reading " + (String)fileName, x);
        }
    }
}

