/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.utility;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

public class HeatTransferChannel
extends DerivedChannel {
    @LookupPath
    private String path;
    private static final Logger LOG = Logger.getLogger(HeatTransferChannel.class.getName());
    private double factor = 1.0;
    private Channel flowChannel;
    private Channel inletTChannel;
    private Channel outletTChannel;

    public void postInit() {
        if (this.flowChannel == null) {
            throw new RuntimeException(this.path + ": flowChannel has not been specified");
        }
        if (this.inletTChannel == null) {
            throw new RuntimeException(this.path + ": inletTChannel has not been specified");
        }
        if (this.outletTChannel == null) {
            throw new RuntimeException(this.path + ": outletTChannel has not been specified");
        }
    }

    public void setFactor(double factor) {
        this.factor = factor;
        LOG.log(Level.INFO, "{0}: Constant factor set to {1}", new Object[]{this.path, factor});
    }

    public double evaluateDerivedValue() {
        return (this.outletTChannel.getValue() - this.inletTChannel.getValue()) * this.flowChannel.getValue() * this.factor;
    }
}

