/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.i2c;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.i2c.I2c;

public class I2cImplUsb
implements I2c.Impl {
    private static final int DEFAULT_BAUDRATE = 19200;
    private static final double DEFAULT_TIMEOUT = 0.5;
    private static final byte I2C_SGL = 83;
    private static final byte I2C_MUL = 84;
    private static final byte I2C_AD1 = 85;
    private static final byte I2C_AD2 = 86;
    private static final byte I2C_USB = 90;
    private final Ascii asc = new Ascii();

    @Override
    public void open(String ident, int param) throws DriverException {
        int dchar = Ascii.makeDataCharacteristics((Ascii.DataBits)Ascii.DataBits.EIGHT, (Ascii.StopBits)Ascii.StopBits.TWO, (Ascii.Parity)Ascii.Parity.NONE, (Ascii.FlowCtrl)Ascii.FlowCtrl.NONE);
        try {
            this.asc.open(DriverConstants.ConnType.SERIAL, ident, 19200, dchar);
            this.asc.setTimeout(0.5);
        }
        catch (DriverException e) {
            this.asc.closeSilent();
            throw e;
        }
    }

    @Override
    public void close() throws DriverException {
        this.asc.close();
    }

    @Override
    public void setTimeout(double timeout) throws DriverException {
        this.asc.setTimeout(timeout);
    }

    @Override
    public synchronized void write(int addr, int value) throws DriverException {
        byte[] cmnd = new byte[]{83, (byte)(addr & 0xFE), (byte)value};
        this.asc.writeBytes(cmnd);
    }

    @Override
    public synchronized int read(int addr) throws DriverException {
        this.asc.flush();
        byte[] cmnd = new byte[]{83, (byte)(addr | 1)};
        this.asc.writeBytes(cmnd);
        byte[] resp = new byte[1];
        return this.readBytes(resp, 1) > 0 ? resp[0] & 0xFF : -1;
    }

    @Override
    public synchronized int read(int addr, byte[] buff, int count) throws DriverException {
        this.asc.flush();
        byte[] cmnd = new byte[]{84, (byte)(addr | 1), (byte)count};
        this.asc.writeBytes(cmnd);
        return this.readBytes(buff, count);
    }

    @Override
    public synchronized void write(int addr, int reg, byte[] buff, int count) throws DriverException {
        byte[] cmnd = new byte[count + 4];
        cmnd[0] = 85;
        cmnd[1] = (byte)(addr & 0xFE);
        cmnd[2] = (byte)reg;
        cmnd[3] = (byte)count;
        System.arraycopy(buff, 0, cmnd, 4, count);
        this.asc.writeBytes(cmnd);
    }

    @Override
    public synchronized int read(int addr, int reg, byte[] buff, int count) throws DriverException {
        this.asc.flush();
        byte[] cmnd = new byte[]{85, (byte)(addr | 1), (byte)reg, (byte)count};
        this.asc.writeBytes(cmnd);
        return this.readBytes(buff, count);
    }

    @Override
    public synchronized void write2(int addr, int reg, byte[] buff, int count) throws DriverException {
        byte[] cmnd = new byte[count + 5];
        cmnd[0] = 85;
        cmnd[1] = (byte)(addr & 0xFE);
        cmnd[2] = (byte)(reg >> 8);
        cmnd[3] = (byte)reg;
        cmnd[4] = (byte)count;
        System.arraycopy(buff, 0, cmnd, 5, count);
        this.asc.writeBytes(cmnd);
    }

    @Override
    public synchronized int read2(int addr, int reg, byte[] buff, int count) throws DriverException {
        this.asc.flush();
        byte[] cmnd = new byte[]{86, (byte)(addr | 1), (byte)(reg >> 8), (byte)reg, (byte)count};
        this.asc.writeBytes(cmnd);
        return this.readBytes(buff, count);
    }

    private int readBytes(byte[] buff, int count) throws DriverException {
        int nread;
        byte[] buff1 = new byte[count];
        for (nread = 0; nread < count; nread += this.asc.readBytes(buff1, nread)) {
            try {
                continue;
            }
            catch (DriverTimeoutException e) {
                // empty catch block
                break;
            }
        }
        System.arraycopy(buff1, 0, buff, 0, nread);
        return nread;
    }
}

